/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.bean;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.anwiba.commons.resource.utilities.StringUtilities;
import net.anwiba.tools.definition.schema.json.generator.java.bean.AnnotationHandler;
import net.anwiba.tools.definition.schema.json.generator.java.bean.BeanNameConverter;
import net.anwiba.tools.definition.schema.json.gramma.element.IJsonTypeVisitor;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JField;
import net.anwiba.tools.definition.schema.json.gramma.element.JObject;
import net.anwiba.tools.definition.schema.json.gramma.element.JParameter;
import net.anwiba.tools.definition.schema.json.gramma.element.JType;
import net.anwiba.tools.definition.schema.json.gramma.element.JValue;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Argument;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.configuration.BeanBuilder;
import net.anwiba.tools.generator.java.bean.configuration.Builders;
import net.anwiba.tools.generator.java.bean.configuration.CreatorBuilder;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.configuration.MemberBuilder;
import net.anwiba.tools.generator.java.bean.configuration.PropertiesBuilder;
import net.anwiba.tools.generator.java.bean.configuration.Type;
import net.anwiba.tools.generator.java.bean.configuration.TypeBuilder;
import net.anwiba.tools.generator.java.bean.factory.SourceFactoryUtilities;

public class JObjectToBeanConverter {
    private static final String DELEGATION = "delegation";
    private static final String PROPERTY = "property";
    private static final String ARGUMENTS = "arguments";
    private static final String ARGUMENT = "argument";
    private static final String CREATE = "create";
    private static final String FACTORY = "factory";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    private static final String REFLECTION = "reflection";
    private static final String VALUE = "value";
    private static final String _UNKNOWN_MEMBERS = "_unknownMembers";
    private static final String JSSD_PROPERTIES = "JssdProperties";
    private static final String JSSD_NO_PROPERTY = "JssdNoProperty";
    private static final String JSSD_IMMUTABLE = "JssdImmutable";
    private static final String JSSD_ARRAYS_NOT_NULLABLE = "JssdArraysNotNullable";
    private static final String JSSD_NOT_NULLABLE = "JssdNotNullable";
    private static final String JSSD_FACTORY = "JssdFactory";
    private static final String JSSD_BUILDER = "JssdBuilder";
    private static final String JSSD_NAMED_VALUE_PROVIDER = "JssdNamedValueProvider";
    private static final String JSSD_UNKNOWN_MEMBER = "JssdUnknownMember";
    private static final String JSSD_PRIMITIVES_ENABLED = "JssdPrimitivesEnabled";
    private static final String JSSD_EQUALS = "JssdEquals";
    private static final String JSSD_EXTENDS = "JssdExtends";
    private static final String JSSD_NAME = "JssdName";
    private static final String ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JACKSON_INJECT = JacksonInject.class.getName();
    private static final String ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_PROPERTY = JsonProperty.class.getName();
    private static final String ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_CREATOR = JsonCreator.class.getName();
    private static final String ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_IGNORE = JsonIgnore.class.getName();
    private static final String ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_ANY_SETTER = JsonAnySetter.class.getName();
    private static final String ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_ANY_GETTER = JsonAnyGetter.class.getName();
    private final BeanNameConverter beanNameConverter;
    private final AnnotationHandler annotationHandler;
    private final String comment;
    private final boolean isBuilderBeanPatternEnabled;

    public JObjectToBeanConverter(String packageName, String comment, boolean isBuilderBeanPatternEnabled) {
        this.comment = comment;
        this.isBuilderBeanPatternEnabled = isBuilderBeanPatternEnabled;
        this.beanNameConverter = new BeanNameConverter(packageName);
        this.annotationHandler = new AnnotationHandler();
    }

    public Bean convert(String name, JObject object) {
        Map<String, JAnnotation> jssdAnnotations = this.annotationHandler.extractJssdAnnotations(object.annotations());
        BeanBuilder builder = Builders.bean((String)this.getClassName(jssdAnnotations, JSSD_NAME, VALUE, name));
        builder.extend(this.getClassName(jssdAnnotations, JSSD_EXTENDS, TYPE, null));
        builder.setMutable(!this.isBuilderBeanPatternEnabled);
        builder.setEnableBuilder(jssdAnnotations.containsKey(JSSD_BUILDER));
        builder.setArrayNullable(!jssdAnnotations.containsKey(JSSD_ARRAYS_NOT_NULLABLE));
        builder.setCollectionNullable(!jssdAnnotations.containsKey(JSSD_ARRAYS_NOT_NULLABLE));
        builder.setEqualsEnabled(jssdAnnotations.containsKey(JSSD_EQUALS));
        builder.setPrimitivesEnabled(jssdAnnotations.containsKey(JSSD_PRIMITIVES_ENABLED));
        builder.comment(this.comment);
        this.addMembers(object, builder, this.getFactoryMembers(jssdAnnotations.get(JSSD_FACTORY)));
        if (jssdAnnotations.containsKey(JSSD_UNKNOWN_MEMBER)) {
            this.addUnknownMembersMethod(builder, jssdAnnotations);
        }
        if (jssdAnnotations.containsKey(JSSD_FACTORY)) {
            this.addFactoryMethode(builder, jssdAnnotations);
        }
        this.addClassAnnotations(object, builder);
        return builder.build();
    }

    private Set<String> getFactoryMembers(JAnnotation annotation) {
        if (annotation == null) {
            return new HashSet<String>();
        }
        if (annotation.hasParameters()) {
            if (annotation.parameter(ARGUMENT) != null) {
                return new HashSet<String>(Arrays.asList(this.getTypeName(annotation.parameter(ARGUMENT).value().toString())));
            }
            if (annotation.parameter(ARGUMENTS) != null) {
                return new HashSet<String>(this.getTypeNames(annotation.parameter(ARGUMENTS).value().toString()));
            }
        }
        return new HashSet<String>(Arrays.asList(TYPE));
    }

    private List<String> getTypeNames(String types) {
        StringTokenizer tokenizer = new StringTokenizer(types, ",");
        ArrayList<String> typeNames = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            typeNames.add(this.getTypeName(tokenizer.nextToken()));
        }
        return typeNames;
    }

    private String getTypeName(String type) {
        if (type.indexOf(58) == -1) {
            return type;
        }
        return StringUtilities.getStringAfterLastChar((String)type, (char)':').trim();
    }

    private void addClassAnnotations(JObject object, BeanBuilder builder) {
        for (JAnnotation annotation : object.annotations()) {
            if (this.annotationHandler.isJssdAnnotation(annotation)) continue;
            builder.annotation(this.annotationHandler.convert(annotation));
        }
    }

    private void addUnknownMembersMethod(BeanBuilder builder, Map<String, JAnnotation> jssdAnnotations) {
        PropertiesBuilder properties = Builders.properties((Type)Builders.type((String)this.beanNameConverter.convert(Object.class.getName()), (String[])new String[0]).build(), (String)_UNKNOWN_MEMBERS);
        properties.getterName("get").getterAnnotation(Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_ANY_GETTER).build());
        properties.setterName("set").setterAnnotation(Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_ANY_SETTER).build());
        properties.isImutable(false);
        properties.isNullable(true);
        properties.setInjectionAnnotationName(JsonProperty.class.getSimpleName());
        properties.setImplementsNamedValueProvider(jssdAnnotations.containsKey(JSSD_NAMED_VALUE_PROVIDER));
        properties.namesGetterAnnotation(Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_IGNORE).build());
        builder.properties(properties.build());
    }

    private void addFactoryMethode(BeanBuilder builder, Map<String, JAnnotation> jssdAnnotations) {
        JAnnotation annotation = jssdAnnotations.get(JSSD_FACTORY);
        CreatorBuilder createMethodeBuilder = Builders.creator((String)CREATE).annotation(Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_CREATOR).build());
        JParameter typeParameter = annotation.parameter(TYPE);
        if (!annotation.hasParameters() || typeParameter == null || typeParameter.value().equals(REFLECTION)) {
            String anotationName = this.getAnnotationName(annotation.parameter(SOURCE));
            JParameter argumentParameter = annotation.parameter(ARGUMENT);
            if (argumentParameter == null) {
                builder.creator(createMethodeBuilder.addArgument(this.argument(JavaConstants.JAVA_LANG_STRING, TYPE, anotationName)).build());
            } else {
                builder.creator(createMethodeBuilder.addArgument(this.argument(JavaConstants.JAVA_LANG_STRING, argumentParameter.value().toString(), anotationName)).build());
            }
        } else if (typeParameter.value().equals(DELEGATION)) {
            JParameter factoryParameter = annotation.parameter(FACTORY);
            if (factoryParameter == null) {
                throw new IllegalArgumentException("missing factory parameter in JssdFactory annotation");
            }
            createMethodeBuilder.setFactory(this.argument(factoryParameter.value().toString(), ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JACKSON_INJECT));
            JParameter argumentsParameter = annotation.parameter(ARGUMENTS);
            if (argumentsParameter != null) {
                List<Argument> arguments = this.arguments(argumentsParameter.value().toString(), ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_PROPERTY);
                for (Argument argument : arguments) {
                    createMethodeBuilder.addArgument(argument);
                }
            }
            builder.creator(createMethodeBuilder.build());
        }
    }

    private String getAnnotationName(JParameter sourceParameter) {
        if (sourceParameter == null || sourceParameter.value().equals(PROPERTY)) {
            return ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_PROPERTY;
        }
        if (sourceParameter.value().equals("inject")) {
            return ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JACKSON_INJECT;
        }
        throw new UnsupportedOperationException();
    }

    private List<Argument> arguments(String parameters, String anotationName) {
        StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        while (tokenizer.hasMoreTokens()) {
            arguments.add(this.argument(tokenizer.nextToken(), anotationName));
        }
        return arguments;
    }

    private Argument argument(String parameter, String anotationName) {
        String name = StringUtilities.getStringBeforLastChar((String)parameter, (char)':').trim();
        String type = StringUtilities.getStringAfterLastChar((String)parameter, (char)':').trim();
        return this.argument(type, name, anotationName);
    }

    private Argument argument(String type, String name, String anotationName) {
        return new Argument(Builders.type((String)type, (String[])new String[0]).build(), SourceFactoryUtilities.createFieldName((String)name), Arrays.asList(Builders.annotation((String)anotationName).parameter(VALUE, name).build()));
    }

    public String getClassName(Map<String, JAnnotation> jssdAnnotations, String annotationName, String parameterName, String defaultValue) {
        String name;
        JParameter parameter;
        if (jssdAnnotations.containsKey(annotationName) && (parameter = jssdAnnotations.get(annotationName).parameter(parameterName)) != null && (name = (String)parameter.value()) != null) {
            return this.beanNameConverter.convert(name);
        }
        return defaultValue == null ? null : this.beanNameConverter.convert(defaultValue);
    }

    public void addMembers(JObject object, BeanBuilder builder, Set<String> factoryMembers) {
        for (String fieldname : object.names()) {
            JField field = object.field(fieldname);
            Map<String, JAnnotation> jssdAnnotations = this.annotationHandler.extractJssdAnnotations(field.annotations());
            if (jssdAnnotations.containsKey(JSSD_PROPERTIES)) {
                PropertiesBuilder properties = Builders.properties((Type)Builders.type((String)this.beanNameConverter.convert(field.type().name()), (String[])new String[0]).build(), (String)field.name());
                Annotation jsonPropertyAnnotation = Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_PROPERTY).parameter(VALUE, field.name()).build();
                properties.getterAnnotation(jsonPropertyAnnotation);
                properties.setterAnnotation(jsonPropertyAnnotation);
                properties.isNullable(true);
                properties.setSingleValueSetterEnabled(true);
                properties.setNamedValueGetterEnabled(true);
                properties.setImplementsNamedValueProvider(false);
                builder.properties(properties.build());
                continue;
            }
            builder.member(this.convert(jssdAnnotations, field, factoryMembers));
        }
    }

    public Member convert(Map<String, JAnnotation> jssdAnnotations, JField field, Set<String> factoryMembers) {
        JType type = field.type();
        TypeBuilder typeBuilder = Builders.type((String)this.beanNameConverter.convert(type.name()), (String[])new String[0]);
        typeBuilder.dimension(type.dimension());
        String[] stringArray = type.generics();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String generic = stringArray[n2];
            typeBuilder.generic(this.beanNameConverter.convert(generic));
            ++n2;
        }
        MemberBuilder builder = Builders.member((Type)typeBuilder.build(), (String)field.name());
        if (!jssdAnnotations.containsKey(JSSD_NO_PROPERTY)) {
            Annotation jsonPropertyAnnotation = Builders.annotation((String)ORG_CODEHAUS_JACKSON_ANNOTATE_JSON_PROPERTY).parameter(VALUE, field.name()).build();
            builder.getterAnnotation(jsonPropertyAnnotation);
            builder.setterAnnotation(jsonPropertyAnnotation);
        }
        builder.isNullable(!jssdAnnotations.containsKey(JSSD_NOT_NULLABLE));
        builder.isImutable(jssdAnnotations.containsKey(JSSD_IMMUTABLE));
        builder.isSetterEnabled(!factoryMembers.contains(field.name()));
        this.adjustValue(builder, type, field.value());
        for (JAnnotation annotation : field.annotations()) {
            if (this.annotationHandler.isJssdAnnotation(annotation)) continue;
            if (this.annotationHandler.isGetterAnnotation(annotation)) {
                builder.getterAnnotation(this.annotationHandler.convert(annotation));
                continue;
            }
            if (this.annotationHandler.isSetterAnnotation(annotation)) {
                builder.setterAnnotation(this.annotationHandler.convert(annotation));
                continue;
            }
            builder.annotation(this.annotationHandler.convert(annotation));
        }
        return builder.build();
    }

    private void adjustValue(final MemberBuilder builder, final JType type, final JValue value) {
        IJsonTypeVisitor<Void, RuntimeException> visitor = new IJsonTypeVisitor<Void, RuntimeException>(){

            @Override
            public Void visitString() throws RuntimeException {
                if (value == null) {
                    return null;
                }
                String string = (String)value.value();
                builder.value(string);
                return null;
            }

            @Override
            public Void visitObject() throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Void visitNumber() throws RuntimeException {
                Number number = (Number)value.value();
                if (JavaConstants.shortTypes.contains(type.name())) {
                    builder.value(number.shortValue());
                    return null;
                }
                if (JavaConstants.integerTypes.contains(type.name())) {
                    builder.value(number.intValue());
                    return null;
                }
                if (JavaConstants.longTypes.contains(type.name())) {
                    builder.value(number.longValue());
                    return null;
                }
                if (JavaConstants.floatTypes.contains(type.name())) {
                    builder.value(number.floatValue());
                    return null;
                }
                if (JavaConstants.doubleTypes.contains(type.name())) {
                    builder.value(number.doubleValue());
                    return null;
                }
                if (JavaConstants.byteTypes.contains(type.name())) {
                    builder.value(number.byteValue());
                    return null;
                }
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public Void visitNull() throws RuntimeException {
                return null;
            }

            @Override
            public Void visitBoolean() throws RuntimeException {
                builder.value(((Boolean)value.value()).booleanValue());
                return null;
            }

            @Override
            public Void visitArray() throws RuntimeException {
                if (JavaConstants.shortTypes.contains(type.name())) {
                    List list = (List)value.value();
                    short[] values = new short[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? (short)0 : ((Number)list.get(i)).shortValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.integerTypes.contains(type.name())) {
                    List list = (List)value.value();
                    int[] values = new int[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? 0 : ((Number)list.get(i)).intValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.longTypes.contains(type.name())) {
                    List list = (List)value.value();
                    long[] values = new long[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? 0L : ((Number)list.get(i)).longValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.floatTypes.contains(type.name())) {
                    List list = (List)value.value();
                    float[] values = new float[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? 0.0f : ((Number)list.get(i)).floatValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.doubleTypes.contains(type.name())) {
                    List list = (List)value.value();
                    double[] values = new double[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? 0.0 : ((Number)list.get(i)).doubleValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.byteTypes.contains(type.name())) {
                    List list = (List)value.value();
                    byte[] values = new byte[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? (byte)0 : ((Number)list.get(i)).byteValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.booleanTypes.contains(type.name())) {
                    List list = (List)value.value();
                    boolean[] values = new boolean[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? false : (Boolean)list.get(i);
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.characterTypes.contains(type.name())) {
                    List list = (List)value.value();
                    char[] values = new char[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? (char)'\u0000' : ((Character)list.get(i)).charValue();
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                if (JavaConstants.stringTypes.contains(type.name())) {
                    List list = (List)value.value();
                    String[] values = new String[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = list.get(i) == null ? null : (String)list.get(i);
                        ++i;
                    }
                    builder.value(values);
                    return null;
                }
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public Void visitCharacter() throws RuntimeException {
                if (value == null) {
                    return null;
                }
                Character string = (Character)value.value();
                builder.value(string.charValue());
                return null;
            }
        };
        value.type().accept(visitor);
    }
}

