/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.gramma.element;

import java.util.List;
import net.anwiba.tools.definition.schema.json.gramma.element.IJNode;
import net.anwiba.tools.definition.schema.json.gramma.element.JObject;
import net.anwiba.tools.definition.schema.json.gramma.element.JsonType;

public class JValue
implements IJNode {
    private final Object value;
    private final JsonType type;

    public JValue(Object value) {
        this.value = value;
        this.type = this.createType(value);
    }

    public <T> T value() {
        return (T)this.value;
    }

    public JsonType type() {
        return this.type;
    }

    private JsonType createType(Object object) {
        if (object instanceof JObject) {
            return JsonType.OBJECT;
        }
        if (object instanceof List) {
            return JsonType.ARRAY;
        }
        if (object == null) {
            return JsonType.NULL;
        }
        if (object instanceof String) {
            return JsonType.STRING;
        }
        if (object instanceof Number) {
            return JsonType.NUMBER;
        }
        if (object instanceof Boolean) {
            return JsonType.BOOLEAN;
        }
        if (object instanceof Character) {
            return JsonType.CHARACTER;
        }
        throw new IllegalArgumentException();
    }
}

