/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.tools.definition.schema.json.generator.java.bean.IOutput;
import net.anwiba.tools.definition.schema.json.generator.java.bean.JsonBeanGeneratorExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate")
public class JsonBeanGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/schema")
    private File sourceDirectory = null;
    @Parameter(defaultValue="${basedir}/target/generated/java")
    private File outputDirectory = null;
    @Parameter
    private String pakkage;
    @Parameter
    private String comment;
    @Component
    private BuildContext buildContext;
    @Parameter
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setPackage(String pakkage) {
        Ensure.ensureArgumentNotNull((Object)pakkage);
        this.pakkage = pakkage;
    }

    public void setComment(String comment) {
        Ensure.ensureArgumentNotNull((Object)comment);
        this.comment = "//" + comment;
    }

    public void setSourceDirectory(String sourceDirectory) throws IOException {
        if (sourceDirectory == null || sourceDirectory.trim().length() == 0) {
            this.sourceDirectory = null;
            return;
        }
        this.sourceDirectory = this.getFile(sourceDirectory);
    }

    public void setOutputDirectory(String outputDirectory) throws IOException {
        if (outputDirectory == null || outputDirectory.trim().length() == 0) {
            this.outputDirectory = null;
            return;
        }
        this.outputDirectory = this.getFile(outputDirectory);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private File getFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file.getCanonicalFile();
        }
        File projectPath = this.getBasePath();
        return new File(projectPath, fileName).getCanonicalFile();
    }

    private File getBasePath() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        if (this.getPluginContext() == null) {
            throw new RuntimeException("missing plugin context");
        }
        if (this.getPluginContext().get("project") == null) {
            throw new RuntimeException("missing project info in plugin context");
        }
        String basedirString = this.getPluginContext().get("project").toString();
        File projectPath = new File(basedirString);
        return projectPath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing ...");
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("missing target path value");
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("missing source folder value");
        }
        if (this.pakkage == null) {
            throw new MojoExecutionException("missing packge name");
        }
        List<File> sources = this.getChildren(this.sourceDirectory);
        if (!this.checkUpToDate(sources)) {
            try {
                JsonBeanGeneratorExecutor excecutor = new JsonBeanGeneratorExecutor(this.sourceDirectory, this.pakkage, this.comment, new IOutput(){

                    @Override
                    public void warn(String message) {
                        JsonBeanGeneratorMojo.this.getLog().warn((CharSequence)message);
                    }

                    @Override
                    public void info(String message) {
                        JsonBeanGeneratorMojo.this.getLog().info((CharSequence)message);
                    }

                    @Override
                    public void error(String message, Throwable throwable) {
                        JsonBeanGeneratorMojo.this.getLog().error((CharSequence)message, throwable);
                    }
                });
                excecutor.excecute(this.outputDirectory);
                this.buildContext.refresh(this.outputDirectory);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Internal exception", e);
            }
        } else {
            this.getLog().info((CharSequence)"Everything is up to date");
        }
    }

    private List<File> getChildren(File directory) {
        File[] sourceFiles;
        ArrayList<File> children = new ArrayList<File>();
        File[] fileArray = sourceFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return "jssd".equalsIgnoreCase(FileUtilities.getExtension((File)pathname));
            }
        });
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                children.addAll(this.getChildren(file));
            } else {
                children.add(file);
            }
            ++n2;
        }
        return children;
    }

    private boolean checkUpToDate(List<File> sourceFiles) {
        boolean uptodate = true;
        for (File file : sourceFiles) {
            if (!this.buildContext.hasDelta(file)) continue;
            uptodate = false;
            break;
        }
        return uptodate;
    }
}

