/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.bean;

import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JParameter;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.AnnotationBuilder;
import net.anwiba.tools.generator.java.bean.configuration.Builders;

public class AnnotationHandler {
    boolean isJssdAnnotation(JAnnotation annotation) {
        return !annotation.name().contains(".") && annotation.name().toLowerCase().startsWith("jssd");
    }

    boolean isGetterAnnotation(JAnnotation annotation) {
        return IterableUtilities.containsAcceptedItems(annotation.parameters(), (IAcceptor)new IAcceptor<JParameter>(){

            public boolean accept(JParameter parameter) {
                return parameter.name().equalsIgnoreCase("JssdTarget") && parameter.value().toString().equalsIgnoreCase("getter");
            }
        });
    }

    Annotation convertGetterAnnotation(JAnnotation annotation) {
        return this.convert(annotation);
    }

    Annotation convertSetterAnnotation(JAnnotation annotation) {
        return this.convert(annotation);
    }

    boolean isSetterAnnotation(JAnnotation annotation) {
        return IterableUtilities.containsAcceptedItems(annotation.parameters(), (IAcceptor)new IAcceptor<JParameter>(){

            public boolean accept(JParameter parameter) {
                return parameter.name().equalsIgnoreCase("JssdTarget") && parameter.value().toString().equalsIgnoreCase("setter");
            }
        });
    }

    Annotation convert(JAnnotation annotation) {
        AnnotationBuilder builder = Builders.annotation((String)annotation.name());
        for (JParameter parameter : annotation.parameters()) {
            this.addAnnotationParameter(builder, parameter);
        }
        return builder.build();
    }

    private void addAnnotationParameter(AnnotationBuilder builder, JParameter parameter) {
        if (parameter.name().toLowerCase().startsWith("jssd")) {
            return;
        }
        Object value = parameter.value();
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value instanceof String) {
            builder.parameter(parameter.name(), (String)value);
            return;
        }
        if (value instanceof Class) {
            builder.parameter(parameter.name(), (Class)value);
            return;
        }
        if (value instanceof Integer) {
            builder.parameter(parameter.name(), ((Integer)value).intValue());
            return;
        }
        throw new UnsupportedOperationException();
    }

    public Map<String, JAnnotation> extractJssdAnnotations(Iterable<JAnnotation> annotations) {
        HashMap<String, JAnnotation> map = new HashMap<String, JAnnotation>();
        for (JAnnotation annotation : annotations) {
            if (!this.isJssdAnnotation(annotation)) continue;
            map.put(annotation.name(), annotation);
        }
        return map;
    }
}

