/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.persistence.mongo;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.common.persistence.mongo.BaseMongoPersistenceServiceImpl;
import net.anotheria.portalkit.services.foreignid.ForeignId;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceService;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceServiceException;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.MongoDaoException;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.MongoForeignIdDAO;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.MongoForeignIdDAOImpl;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.entity.ForeignIdEntity;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoForeignIdPersistenceServiceImpl
extends BaseMongoPersistenceServiceImpl
implements ForeignIdPersistenceService {
    private Logger log = LoggerFactory.getLogger(MongoForeignIdPersistenceServiceImpl.class);
    private final MongoForeignIdDAO foreignIdDAO = new MongoForeignIdDAOImpl();

    public MongoForeignIdPersistenceServiceImpl() {
        super("pk-mongo-foreignid");
    }

    @Override
    public void link(AccountId accountId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        try {
            Datastore datastore = this.connect();
            ForeignIdEntity savedForeignId = this.getForeignIdBySidAndFid(sid, fid);
            if (savedForeignId != null) {
                throw new ForeignIdPersistenceServiceException("ForeignId entity already exists with sid:" + sid + " fid:" + fid);
            }
            ForeignIdEntity entity = new ForeignIdEntity(new ObjectId());
            entity.setAccountId(accountId);
            entity.setForeignid(fid);
            entity.setSourceId(sid);
            entity.setDaoCreated(System.currentTimeMillis());
            entity.setDaoUpdated(System.currentTimeMillis());
            this.foreignIdDAO.createEntity(datastore, entity);
        }
        catch (MongoDaoException e) {
            this.log.error("Error while saving foreignId to mongo", (Throwable)e);
            throw new ForeignIdPersistenceServiceException("Error while saving foreignId to mongo", e);
        }
    }

    private ForeignIdEntity getForeignIdBySidAndFid(int sid, String fid) throws ForeignIdPersistenceServiceException {
        ForeignIdEntity foreignEntity;
        block3: {
            try {
                Datastore datastore = this.connect();
                foreignEntity = this.foreignIdDAO.getForeignIdBySidAndFid(datastore, sid, fid);
                if (foreignEntity != null) break block3;
                return null;
            }
            catch (MongoDaoException e) {
                this.log.error("Can't find account by sid: " + sid + " and fid: " + fid, (Throwable)e);
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
        }
        return foreignEntity;
    }

    @Override
    public AccountId getAccountIdByForeignId(int sid, String fid) throws ForeignIdPersistenceServiceException {
        AccountId accountId;
        block3: {
            try {
                Datastore datastore = this.connect();
                accountId = this.foreignIdDAO.getAccountIdByForeignId(datastore, sid, fid);
                if (accountId != null) break block3;
                return null;
            }
            catch (MongoDaoException e) {
                throw new ForeignIdPersistenceServiceException("Can't find account by sid: " + sid + " and fid: " + fid, e);
            }
        }
        return accountId;
    }

    @Override
    public List<ForeignId> getForeignIdsByAccountId(AccountId accountId) throws ForeignIdPersistenceServiceException {
        List<ForeignIdEntity> foreignIds;
        block3: {
            try {
                Datastore datastore = this.connect();
                foreignIds = this.foreignIdDAO.getForeignIdsByAccountId(datastore, accountId);
                if (foreignIds != null) break block3;
                return null;
            }
            catch (MongoDaoException e) {
                throw new ForeignIdPersistenceServiceException("Can't find foreignIds by accid: " + accountId, e);
            }
        }
        return this.convertToForeignIds(foreignIds);
    }

    private List<ForeignId> convertToForeignIds(List<ForeignIdEntity> foreignIds) {
        ArrayList<ForeignId> result = new ArrayList<ForeignId>();
        for (ForeignIdEntity foreignId : foreignIds) {
            result.add(new ForeignId(foreignId.getAccountId(), foreignId.getSourceId(), foreignId.getForeignid()));
        }
        return result;
    }

    @Override
    public void unlink(int sid, String fid) throws ForeignIdPersistenceServiceException {
        try {
            Datastore datastore = this.connect();
            AccountId accountId = this.foreignIdDAO.getAccountIdByForeignId(datastore, sid, fid);
            this.foreignIdDAO.deleteEntity(datastore, accountId, sid, fid);
        }
        catch (MongoDaoException e) {
            this.log.error("Can't delete account with sid={}, fid={}", (Object)sid, (Object)fid);
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
    }

    @Override
    public void unlink(AccountId accountId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        try {
            Datastore datastore = this.connect();
            this.foreignIdDAO.deleteEntity(datastore, accountId, sid, fid);
        }
        catch (MongoDaoException e) {
            this.log.error("Can't delete account with accid={}, sid={}, fid={}", new Object[]{accountId, sid, fid});
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
    }
}

