/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.persistence.mongo;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoException;
import java.util.List;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.MongoDaoException;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.MongoForeignIdDAO;
import net.anotheria.portalkit.services.foreignid.persistence.mongo.entity.ForeignIdEntity;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoForeignIdDAOImpl
implements MongoForeignIdDAO {
    private final Logger log = LoggerFactory.getLogger(MongoForeignIdDAOImpl.class);

    @Override
    public ForeignIdEntity createEntity(Datastore datastore, ForeignIdEntity entity) throws MongoDaoException {
        if (entity == null) {
            throw new IllegalArgumentException("foreignId is null.");
        }
        try {
            datastore.save((Object)entity);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            this.log.error("id already exists " + entity.getId());
            throw new MongoDaoException("Id already exists");
        }
        catch (MongoException mongoException) {
            this.log.error("Can't store " + entity.toString());
            throw new MongoDaoException("Can't store " + entity.toString());
        }
        return null;
    }

    @Override
    public ForeignIdEntity getForeignIdBySidAndFid(Datastore datastore, int sid, String fid) throws MongoDaoException {
        List result;
        block4: {
            if (fid == null) {
                throw new IllegalArgumentException("fid is null.");
            }
            try {
                result = ((Query)((Query)datastore.createQuery(ForeignIdEntity.class).field("sourceId").equal((Object)sid)).field("foreignid").equal((Object)fid)).asList();
                if (!result.isEmpty()) break block4;
                return null;
            }
            catch (MongoException mongoException) {
                this.log.error("Can't find foreignId with sid: " + sid + " fid:" + fid);
                throw new MongoDaoException("Can't find foreignId with sid: " + sid + " fid:" + fid);
            }
        }
        return (ForeignIdEntity)((Object)result.get(0));
    }

    @Override
    public AccountId getAccountIdByForeignId(Datastore datastore, int sid, String fid) throws MongoDaoException {
        List result;
        block4: {
            if (fid == null) {
                throw new IllegalArgumentException("fid is null.");
            }
            try {
                result = ((Query)((Query)datastore.createQuery(ForeignIdEntity.class).field("sourceId").equal((Object)sid)).field("foreignid").equal((Object)fid)).asList();
                if (!result.isEmpty()) break block4;
                return null;
            }
            catch (MongoException mongoException) {
                throw new MongoDaoException("Can't find foreignId with sid: " + sid + " fid:" + fid);
            }
        }
        return ((ForeignIdEntity)((Object)result.get(0))).getAccountId();
    }

    @Override
    public List<ForeignIdEntity> getForeignIdsByAccountId(Datastore datastore, AccountId accId) throws MongoDaoException {
        if (accId == null) {
            throw new IllegalArgumentException("accId is null.");
        }
        try {
            List result = ((Query)datastore.createQuery(ForeignIdEntity.class).field("accountId").equal((Object)accId)).asList();
            if (result.isEmpty()) {
                throw new MongoDaoException("Can't find foreignIds with accid: " + accId);
            }
            return result;
        }
        catch (MongoException mongoException) {
            throw new MongoDaoException("Can't find foreignId with accid: " + accId);
        }
    }

    @Override
    public void deleteEntity(Datastore datastore, AccountId accountId, int sid, String fid) throws MongoDaoException {
        if (accountId == null) {
            throw new IllegalArgumentException("Entity accid is null.");
        }
        try {
            datastore.delete((Query)((Query)((Query)datastore.createQuery(ForeignIdEntity.class).field("accountId").equal((Object)accountId)).field("sourceId").equal((Object)sid)).field("foreignid").equal((Object)fid));
        }
        catch (MongoException mongoException) {
            this.log.error("Can't delete foreignId with accid={}, fid={}, sid={}", new Object[]{accountId, fid, sid});
            throw new MongoDaoException("Can't delete foreignId");
        }
    }
}

