/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.persistence.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.common.persistence.jdbc.BasePersistenceServiceJDBCImpl;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAO;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAOException;
import net.anotheria.portalkit.services.common.persistence.jdbc.JDBCUtil;
import net.anotheria.portalkit.services.foreignid.ForeignId;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceService;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceServiceException;
import net.anotheria.portalkit.services.foreignid.persistence.jdbc.ForeignIdDAO;

public class JDBCForeignIdPersistenceServiceImpl
extends BasePersistenceServiceJDBCImpl
implements ForeignIdPersistenceService {
    private ForeignIdDAO dao = new ForeignIdDAO();

    public JDBCForeignIdPersistenceServiceImpl() {
        super("pk-jdbc-foreignid");
        this.addDaos(new DAO[]{this.dao});
    }

    @Override
    public AccountId getAccountIdByForeignId(int sid, String fid) throws ForeignIdPersistenceServiceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            AccountId accountId = this.dao.getAccountIdByForeignId(conn, sid, fid);
            return accountId;
        }
        catch (DAOException e) {
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
        finally {
            JDBCUtil.close((Connection)conn);
        }
    }

    @Override
    public List<ForeignId> getForeignIdsByAccountId(AccountId accId) throws ForeignIdPersistenceServiceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<ForeignId> list = this.dao.getForeignIdsByAccountId(conn, accId);
            return list;
        }
        catch (DAOException e) {
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
        }
        finally {
            JDBCUtil.close((Connection)conn);
        }
    }

    @Override
    public void link(AccountId accId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                this.dao.link(conn, accId, sid, fid);
            }
            catch (DAOException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
            catch (SQLException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
        }
        finally {
            JDBCUtil.close((Connection)conn);
        }
    }

    @Override
    public void unlink(AccountId accId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                this.dao.unlink(conn, accId, sid, fid);
            }
            catch (DAOException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
            catch (SQLException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
        }
        finally {
            JDBCUtil.close((Connection)conn);
        }
    }

    @Override
    public void unlink(int sid, String fid) throws ForeignIdPersistenceServiceException {
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                this.dao.unlink(conn, sid, fid);
            }
            catch (DAOException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
            catch (SQLException e) {
                throw new ForeignIdPersistenceServiceException(e.getMessage(), e);
            }
        }
        finally {
            JDBCUtil.close((Connection)conn);
        }
    }
}

