/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.persistence.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.sql.callingAspect.ConnectionCallAspect;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.common.persistence.jdbc.AbstractDAO;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAO;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAOException;
import net.anotheria.portalkit.services.common.persistence.jdbc.JDBCUtil;
import net.anotheria.portalkit.services.foreignid.ForeignId;
import net.anotheria.portalkit.services.foreignid.persistence.jdbc.ForeignIdDAO$AjcClosure1;
import net.anotheria.portalkit.services.foreignid.persistence.jdbc.ForeignIdDAO$AjcClosure3;
import net.anotheria.portalkit.services.foreignid.persistence.jdbc.ForeignIdDAO$AjcClosure5;
import net.anotheria.portalkit.services.foreignid.persistence.jdbc.ForeignIdDAO$AjcClosure7;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignIdDAO
extends AbstractDAO
implements DAO {
    public static final String TABLE_NAME = "foreignid";
    public static final String ACCOUNTID_FIELD_NAME = "accid";
    public static final String SOURCEID_FIELD_NAME = "sourceid";
    public static final String FOREIGN_FIELD_NAME = "foreignid";
    private static Logger log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        ForeignIdDAO.ajc$preClinit();
        log = LoggerFactory.getLogger(ForeignIdDAO.class);
    }

    protected String[] getTableNames() {
        return new String[]{"foreignid"};
    }

    public void link(Connection connection, AccountId accId, int sid, String fid) throws DAOException, SQLException {
        PreparedStatement insertStatement = null;
        try {
            insertStatement = connection.prepareStatement("insert into foreignid (accid, sourceid, foreignid) values (?, ?, ?);");
            insertStatement.setString(1, accId.getInternalId());
            insertStatement.setInt(2, sid);
            insertStatement.setString(3, fid);
            PreparedStatement preparedStatement = insertStatement;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(new ForeignIdDAO$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112)));
        }
        finally {
            JDBCUtil.close((Statement)insertStatement);
        }
    }

    public AccountId getAccountIdByForeignId(Connection connection, int sid, String fid) throws DAOException, SQLException {
        AccountId accId;
        ResultSet result;
        PreparedStatement stat;
        block3: {
            stat = null;
            result = null;
            try {
                stat = connection.prepareStatement("SELECT accid from foreignid WHERE sourceid = ? and foreignid = ?;");
                stat.setInt(1, sid);
                stat.setString(2, fid);
                PreparedStatement preparedStatement = stat;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)preparedStatement);
                Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
                result = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(new ForeignIdDAO$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
                if (result.next()) break block3;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(result);
                JDBCUtil.close((Statement)stat);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)result);
            JDBCUtil.close((Statement)stat);
            return null;
        }
        AccountId accountId = accId = new AccountId(result.getString(1));
        JDBCUtil.close((ResultSet)result);
        JDBCUtil.close((Statement)stat);
        return accountId;
    }

    public List<ForeignId> getForeignIdsByAccountId(Connection connection, AccountId accId) throws DAOException, SQLException {
        ArrayList<ForeignId> arrayList;
        PreparedStatement stat = null;
        ResultSet result = null;
        try {
            stat = connection.prepareStatement("SELECT * from foreignid WHERE accid = ?;");
            stat.setString(1, accId.getInternalId());
            PreparedStatement preparedStatement = stat;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            result = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(new ForeignIdDAO$AjcClosure5(objectArray).linkClosureAndJoinPoint(4112));
            ArrayList<ForeignId> res = new ArrayList<ForeignId>();
            while (result.next()) {
                res.add(new ForeignId(new AccountId(result.getString(ACCOUNTID_FIELD_NAME)), result.getInt(SOURCEID_FIELD_NAME), result.getString("foreignid")));
            }
            arrayList = res;
        }
        catch (Throwable throwable) {
            JDBCUtil.close(result);
            JDBCUtil.close((Statement)stat);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)result);
        JDBCUtil.close((Statement)stat);
        return arrayList;
    }

    public void unlink(Connection connection, AccountId accId, int sid, String fid) throws DAOException, SQLException {
        PreparedStatement deleteStatement = null;
        try {
            deleteStatement = connection.prepareStatement("delete from foreignid where accid = ? and sourceid = ? and foreignid = ?;");
            deleteStatement.setString(1, accId.getInternalId());
            deleteStatement.setInt(2, sid);
            deleteStatement.setString(3, fid);
            PreparedStatement preparedStatement = deleteStatement;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(new ForeignIdDAO$AjcClosure7(objectArray).linkClosureAndJoinPoint(4112)));
        }
        finally {
            JDBCUtil.close((Statement)deleteStatement);
        }
    }

    public void unlink(Connection connection, int sid, String fid) throws DAOException, SQLException {
        AccountId accid = this.getAccountIdByForeignId(connection, sid, fid);
        this.unlink(connection, accid, sid, fid);
    }

    static final /* synthetic */ int executeUpdate_aroundBody0(ForeignIdDAO foreignIdDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody2(ForeignIdDAO foreignIdDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody4(ForeignIdDAO foreignIdDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ int executeUpdate_aroundBody6(ForeignIdDAO foreignIdDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ForeignIdDAO.java", ForeignIdDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 72);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 96);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 124);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 155);
    }
}

