/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.persistence.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.foreignid.ForeignId;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceService;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceServiceException;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;

public class InMemoryForeignIdPersistenceServiceImpl
implements ForeignIdPersistenceService {
    private ConcurrentHashMap<AccountId, List<ForeignId>> storage = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ForeignId> foreignIdCache = new ConcurrentHashMap();
    private final IdBasedLockManager<AccountId> lockManager = new SafeIdBasedLockManager();

    private String getKey(int sid, String fid) {
        return "key_" + sid + "_" + fid;
    }

    @Override
    public AccountId getAccountIdByForeignId(int sid, String fid) throws ForeignIdPersistenceServiceException {
        ForeignId foreignId = this.foreignIdCache.get(this.getKey(sid, fid));
        if (foreignId == null) {
            return null;
        }
        return foreignId.getAccountId();
    }

    @Override
    public List<ForeignId> getForeignIdsByAccountId(AccountId accountId) throws ForeignIdPersistenceServiceException {
        if (accountId == null) {
            throw new ForeignIdPersistenceServiceException("accountId is null");
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)accountId);
        try {
            lock.lock();
            List<ForeignId> list = this.storage.get(accountId);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void link(AccountId accId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        if (accId == null) {
            throw new ForeignIdPersistenceServiceException("accountId is null");
        }
        if (fid == null) {
            throw new ForeignIdPersistenceServiceException("foreignId is null");
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)accId);
        try {
            lock.lock();
            List<ForeignId> fids = this.storage.get(accId);
            ForeignId foreignId = new ForeignId(accId, sid, fid);
            if (fids == null) {
                fids = new ArrayList<ForeignId>();
                fids.add(foreignId);
                this.storage.put(accId, fids);
            } else {
                fids.add(foreignId);
            }
            this.foreignIdCache.putIfAbsent(this.getKey(sid, fid), foreignId);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void unlink(int sid, String fid) throws ForeignIdPersistenceServiceException {
        AccountId accId = this.getAccountIdByForeignId(sid, fid);
        this.unlink(accId, sid, fid);
    }

    @Override
    public void unlink(AccountId accId, int sid, String fid) throws ForeignIdPersistenceServiceException {
        if (accId == null) {
            throw new ForeignIdPersistenceServiceException("accountId is null");
        }
        if (fid == null) {
            throw new ForeignIdPersistenceServiceException("foreignId is null");
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)accId);
        try {
            lock.lock();
            List<ForeignId> fids = this.storage.get(accId);
            if (fids != null) {
                ForeignId currFid = new ForeignId(accId, sid, fid);
                fids.remove(currFid);
                this.foreignIdCache.remove(this.getKey(sid, fid));
            } else {
                this.storage.remove(accId);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

