/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid.generated;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.portalkit.services.foreignid.ForeignIdService;
import net.anotheria.portalkit.services.foreignid.generated.ForeignIdServiceConstants;
import net.anotheria.portalkit.services.foreignid.generated.RemoteForeignIdService;
import net.anotheria.portalkit.services.foreignid.generated.RemoteForeignIdServiceSkeleton;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.PidTools;
import org.distributeme.agents.transporter.generated.TransporterServer;
import org.distributeme.core.RMIRegistryUtil;
import org.distributeme.core.RegistryUtil;
import org.distributeme.core.ServerShutdownHook;
import org.distributeme.core.ServiceDescriptor;
import org.distributeme.core.Verbosity;
import org.distributeme.core.conventions.SystemProperties;
import org.distributeme.core.lifecycle.LifecycleComponentImpl;
import org.distributeme.core.lifecycle.ServiceAdapter;
import org.distributeme.core.listener.ListenerRegistry;
import org.distributeme.core.listener.ServerLifecycleListener;
import org.distributeme.core.listener.ServerLifecycleListenerShutdownHook;
import org.distributeme.core.routing.RegistrationNameProvider;
import org.distributeme.core.routing.RoutingAware;
import org.distributeme.core.util.LocalServiceDescriptorStore;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
import org.distributeme.support.lifecycle.generated.LifecycleSupportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ForeignIdServer {
    private static Logger log;
    private static Marker FATAL;
    private static long serverStartTime;
    private static final List<ServerLifecycleListener> serverListeners;
    private static RemoteForeignIdService skeleton;
    private static RemoteForeignIdService rmiServant;
    private static String serviceId;

    static {
        FATAL = MarkerFactory.getMarker((String)"FATAL");
        serverStartTime = System.currentTimeMillis();
        serverListeners = new ArrayList<ServerLifecycleListener>(0);
        skeleton = null;
        rmiServant = null;
        serviceId = null;
    }

    public static void main(String[] a) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPermission(Permission perm) {
                }
            });
        }
        try {
            ForeignIdServer.init();
            PidTools.logPid();
            Verbosity.logServerSideExceptions();
            ForeignIdServer.createSupportServicesAndRegisterLocally();
            ForeignIdServer.createServiceAndRegisterLocally();
            ForeignIdServer.startService();
            ForeignIdServer.notifyListenersAboutStart();
        }
        catch (Throwable e) {
            log.error(FATAL, "Unhandled exception caught", e);
            System.err.println(e.getMessage());
            System.exit(-4);
        }
    }

    private static void notifyListenersAboutStart() {
        List configuredListeners = ListenerRegistry.getInstance().getServerLifecycleListeners();
        if (configuredListeners != null && configuredListeners.size() > 0) {
            for (ServerLifecycleListener listener : configuredListeners) {
                try {
                    listener.afterStart();
                }
                catch (Exception e) {
                    log.error("Couldn't call afterStart on  listener " + listener, (Throwable)e);
                }
            }
        }
    }

    public static void init() throws Exception {
        log = LoggerFactory.getLogger(ForeignIdServer.class);
    }

    public static void createServiceAndRegisterLocally() throws Exception {
        ForeignIdServer.createServiceAndRegisterLocally(-1);
    }

    public static void createServiceAndRegisterLocally(int customRegistryPort) throws Exception {
        try {
            Class<?> factoryClazz = Class.forName("net.anotheria.portalkit.services.foreignid.ForeignIdServiceFactory");
            MetaFactory.addFactoryClass(ForeignIdService.class, (Extension)Extension.LOCAL, factoryClazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> implClazz = Class.forName("net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl");
                MetaFactory.createOnTheFlyFactory(ForeignIdService.class, (Extension)Extension.LOCAL, (Service)((ForeignIdService)implClazz.newInstance()));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.info("Giving up trying to find an impl instance, tried net.anotheria.portalkit.services.foreignid.ForeignIdServiceFactory and net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl, expect start to fail since init code were empty too and no factory has been supplied explicitely");
            }
        }
        ForeignIdService impl = null;
        try {
            impl = (ForeignIdService)MetaFactory.get(ForeignIdService.class, (Extension)Extension.LOCAL);
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
            throw new AssertionError((Object)"Un- or mis-configured, can't instantiate service instance for net.anotheria.portalkit.services.foreignid.ForeignIdService tried initcode, submitted factory, autoguessed factory (net.anotheria.portalkit.services.foreignid.ForeignIdServiceFactory) and impl class (net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl)");
        }
        skeleton = new RemoteForeignIdServiceSkeleton(impl);
        rmiServant = (RemoteForeignIdService)UnicastRemoteObject.exportObject((Remote)skeleton, SystemProperties.SERVICE_BINDING_PORT.getAsInt());
        String definedServiceId = serviceId = ForeignIdServiceConstants.getServiceId();
        String regNameProviderClass = System.getProperty("dimeRegistrationNameProvider");
        if (regNameProviderClass != null) {
            RegistrationNameProvider suppliedNameProvider = (RegistrationNameProvider)Class.forName(regNameProviderClass).newInstance();
            serviceId = suppliedNameProvider.getRegistrationName(serviceId);
        }
        log.info("Getting local registry");
        Registry registry = null;
        try {
            registry = RMIRegistryUtil.findOrCreateRegistry((int)customRegistryPort);
        }
        catch (RemoteException e) {
            log.error(FATAL, "Couldn't obtain free port for a local rmi registry", (Throwable)e);
            System.err.println("Couldn't obtain a free port for local rmi registry");
            System.exit(-1);
        }
        log.info("Registering " + serviceId + " locally.");
        try {
            registry.rebind(serviceId, rmiServant);
        }
        catch (Exception e) {
            log.error(FATAL, "Couldn't rebind myself at the local registry", (Throwable)e);
            System.err.println("Couldn't rebind myself at the local registry");
            e.printStackTrace();
            System.exit(-2);
        }
        if (impl instanceof RoutingAware) {
            ((RoutingAware)impl).notifyServiceId(definedServiceId, serviceId, null, null);
        }
        LifecycleComponentImpl.INSTANCE.registerPublicService(serviceId, (ServiceAdapter)skeleton);
    }

    public static ServiceDescriptor createDescriptor(String instanceId) throws Exception {
        return RegistryUtil.createLocalServiceDescription((ServiceDescriptor.Protocol)ServiceDescriptor.Protocol.RMI, (String)serviceId, (String)instanceId, (int)RMIRegistryUtil.getRmiRegistryPort());
    }

    public static void startService() throws Exception {
        boolean registerCentrally;
        String instanceId = IdCodeGenerator.generateCode((int)10);
        boolean bl = registerCentrally = !SystemProperties.SKIP_CENTRAL_REGISTRY.getAsBoolean();
        if (registerCentrally) {
            ServiceDescriptor descriptor = ForeignIdServer.createDescriptor(instanceId);
            LocalServiceDescriptorStore.getInstance().addServiceDescriptor(descriptor);
            if (!RegistryUtil.bind((ServiceDescriptor)descriptor)) {
                log.error(FATAL, "Couldn't bind myself to the central registry at " + RegistryUtil.describeRegistry());
                System.err.println("Couldn't bind myself at the central registry at " + RegistryUtil.describeRegistry());
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook((Thread)new ServerShutdownHook(descriptor));
        } else {
            System.out.println("skipping registration for " + serviceId);
        }
        System.out.println("Server " + serviceId + " is up and ready (in " + (System.currentTimeMillis() - serverStartTime) + " ms).");
        Runtime.getRuntime().addShutdownHook((Thread)new ServerLifecycleListenerShutdownHook(serverListeners));
    }

    public static void createSupportServicesAndRegisterLocally() throws Exception {
        LifecycleSupportServer.init();
        LifecycleSupportServer.createServiceAndRegisterLocally();
        EventServiceRMIBridgeServer.init();
        EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
        TransporterServer.init();
        TransporterServer.createServiceAndRegisterLocally();
    }
}

