/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.foreignid;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.Caches;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.moskito.aop.annotation.Monitor;
import net.anotheria.moskito.aop.aspect.MonitoringAspect;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.foreignid.ForeignId;
import net.anotheria.portalkit.services.foreignid.ForeignIdAlreadyExistsServiceException;
import net.anotheria.portalkit.services.foreignid.ForeignIdService;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceException;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl$AjcClosure1;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl$AjcClosure3;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl$AjcClosure5;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl$AjcClosure7;
import net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl$AjcClosure9;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceService;
import net.anotheria.portalkit.services.foreignid.persistence.ForeignIdPersistenceServiceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Monitor(subsystem="portalkit")
public class ForeignIdServiceImpl
implements ForeignIdService {
    private ForeignIdPersistenceService persistenceService;
    private Cache<AccountId, List<ForeignId>> cacheByAccountId = Caches.createHardwiredCache((String)"foreignidservice-cacheaccountid");
    private Cache<String, AccountId> cacheByForeignId = Caches.createHardwiredCache((String)"foreignidservice-cacheforeignid");
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ForeignIdServiceImpl() {
        try {
            this.persistenceService = (ForeignIdPersistenceService)MetaFactory.get(ForeignIdPersistenceService.class);
        }
        catch (MetaFactoryException e) {
            throw new IllegalStateException("Can't start without persistence service ", e);
        }
    }

    private String getForeignIdString(String foreignId, int sourceId) {
        String string = foreignId;
        int n = sourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
        return (String)MonitoringAspect.aspectOf().doProfilingClass(new ForeignIdServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648), ForeignIdServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void addForeignId(AccountId accId, String foreignId, int sourceId) throws ForeignIdServiceException {
        AccountId accountId = accId;
        String string = foreignId;
        int n = sourceId;
        Object[] objectArray = new Object[]{accountId, string, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, accountId, string, Conversions.intObject((int)n), joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new ForeignIdServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648), ForeignIdServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void removeForeignId(AccountId accId, String foreignId, int sourceId) throws ForeignIdServiceException {
        AccountId accountId = accId;
        String string = foreignId;
        int n = sourceId;
        Object[] objectArray = new Object[]{accountId, string, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, accountId, string, Conversions.intObject((int)n), joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new ForeignIdServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648), ForeignIdServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public AccountId getAccountIdByForeignId(String foreignId, int sourceId) throws ForeignIdServiceException {
        String string = foreignId;
        int n = sourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
        return (AccountId)MonitoringAspect.aspectOf().doProfilingClass(new ForeignIdServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648), ForeignIdServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public List<ForeignId> getForeignIds(AccountId accId) throws ForeignIdServiceException {
        AccountId accountId = accId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)accountId);
        Object[] objectArray = new Object[]{this, accountId, joinPoint};
        return (List)MonitoringAspect.aspectOf().doProfilingClass(new ForeignIdServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648), ForeignIdServiceImpl.class.getAnnotation(Monitor.class));
    }

    static {
        ForeignIdServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getForeignIdString_aroundBody0(ForeignIdServiceImpl ajc$this, String foreignId, int sourceId, JoinPoint joinPoint) {
        return "fid_" + sourceId + "_" + foreignId;
    }

    static final /* synthetic */ void addForeignId_aroundBody2(ForeignIdServiceImpl ajc$this, AccountId accId, String foreignId, int sourceId, JoinPoint joinPoint) {
        try {
            AccountId accountIdByForeignId = ajc$this.persistenceService.getAccountIdByForeignId(sourceId, foreignId);
            if (accountIdByForeignId != null) {
                throw new ForeignIdAlreadyExistsServiceException("Account already exists by provided foreign id and source id.");
            }
            ajc$this.persistenceService.link(accId, sourceId, foreignId);
            ArrayList<ForeignId> list = (ArrayList<ForeignId>)ajc$this.cacheByAccountId.get((Object)accId);
            if (list == null) {
                list = new ArrayList<ForeignId>();
                ajc$this.cacheByAccountId.put((Object)accId, list);
            }
            list.add(new ForeignId(accId, sourceId, foreignId));
            ajc$this.cacheByForeignId.put((Object)ajc$this.getForeignIdString(foreignId, sourceId), (Object)accId);
        }
        catch (ForeignIdPersistenceServiceException e) {
            throw new ForeignIdServiceException("persistenceService.link failed", (Throwable)((Object)e));
        }
    }

    static final /* synthetic */ void removeForeignId_aroundBody4(ForeignIdServiceImpl ajc$this, AccountId accId, String foreignId, int sourceId, JoinPoint joinPoint) {
        try {
            ajc$this.persistenceService.unlink(accId, sourceId, foreignId);
            List list = (List)ajc$this.cacheByAccountId.get((Object)accId);
            if (list != null) {
                list.remove(new ForeignId(accId, sourceId, foreignId));
            }
            ajc$this.cacheByForeignId.remove((Object)ajc$this.getForeignIdString(foreignId, sourceId));
        }
        catch (ForeignIdPersistenceServiceException e) {
            throw new ForeignIdServiceException("persistenceService.unlink failed", (Throwable)((Object)e));
        }
    }

    static final /* synthetic */ AccountId getAccountIdByForeignId_aroundBody6(ForeignIdServiceImpl ajc$this, String foreignId, int sourceId, JoinPoint joinPoint) {
        if (foreignId == null) {
            throw new IllegalArgumentException("Null parameter foreignId to getForeignIds(foreignId, sourceId)");
        }
        AccountId accId = (AccountId)ajc$this.cacheByForeignId.get((Object)ajc$this.getForeignIdString(foreignId, sourceId));
        if (accId != null) {
            return accId;
        }
        try {
            AccountId fromPersistence = ajc$this.persistenceService.getAccountIdByForeignId(sourceId, foreignId);
            if (fromPersistence != null) {
                ajc$this.cacheByForeignId.put((Object)ajc$this.getForeignIdString(foreignId, sourceId), (Object)fromPersistence);
            }
            return fromPersistence;
        }
        catch (ForeignIdPersistenceServiceException e) {
            throw new ForeignIdServiceException("persistenceService.getAccountIdByForeignId failed", (Throwable)((Object)e));
        }
    }

    static final /* synthetic */ List getForeignIds_aroundBody8(ForeignIdServiceImpl ajc$this, AccountId accId, JoinPoint joinPoint) {
        if (accId == null) {
            throw new IllegalArgumentException("Null parameter accId to getForeignIds(accId)");
        }
        List fromCache = (List)ajc$this.cacheByAccountId.get((Object)accId);
        if (fromCache != null) {
            return fromCache;
        }
        try {
            List<ForeignId> fromPersistence = ajc$this.persistenceService.getForeignIdsByAccountId(accId);
            if (fromPersistence == null) {
                fromPersistence = new ArrayList<ForeignId>();
            }
            ajc$this.cacheByAccountId.put((Object)accId, fromPersistence);
            return fromPersistence;
        }
        catch (ForeignIdPersistenceServiceException e) {
            throw new ForeignIdServiceException("persistenceService.getForeignIdsByAccountId failed", (Throwable)((Object)e));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ForeignIdServiceImpl.java", ForeignIdServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getForeignIdString", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl", "java.lang.String:int", "foreignId:sourceId", "", "java.lang.String"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addForeignId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl", "net.anotheria.portalkit.services.common.AccountId:java.lang.String:int", "accId:foreignId:sourceId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceException", "void"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeForeignId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl", "net.anotheria.portalkit.services.common.AccountId:java.lang.String:int", "accId:foreignId:sourceId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceException", "void"), 86);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccountIdByForeignId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl", "java.lang.String:int", "foreignId:sourceId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceException", "net.anotheria.portalkit.services.common.AccountId"), 102);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getForeignIds", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceImpl", "net.anotheria.portalkit.services.common.AccountId", "accId", "net.anotheria.portalkit.services.foreignid.ForeignIdServiceException", "java.util.List"), 122);
    }
}

