/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.accountarchive.persistence.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.sql.callingAspect.ConnectionCallAspect;
import net.anotheria.portalkit.services.accountarchive.ArchivedAccount;
import net.anotheria.portalkit.services.accountarchive.ArchivedAccountQuery;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure1;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure11;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure13;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure15;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure17;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure19;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure21;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure23;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure3;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure5;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure7;
import net.anotheria.portalkit.services.accountarchive.persistence.jdbc.AccountArchiveDAO$AjcClosure9;
import net.anotheria.portalkit.services.common.AccountId;
import net.anotheria.portalkit.services.common.persistence.jdbc.AbstractDAO;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAO;
import net.anotheria.portalkit.services.common.persistence.jdbc.DAOException;
import net.anotheria.portalkit.services.common.persistence.jdbc.JDBCUtil;
import net.anotheria.util.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountArchiveDAO
extends AbstractDAO
implements DAO {
    public static final String TABLE_NAME = "account_archive";
    private static final Logger LOGGER;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    static {
        AccountArchiveDAO.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(AccountArchiveDAO.class);
    }

    protected String[] getTableNames() {
        return new String[]{TABLE_NAME};
    }

    public ArchivedAccount getAccount(Connection connection, AccountId id) throws DAOException, SQLException {
        ResultSet result;
        PreparedStatement stat;
        block3: {
            stat = null;
            result = null;
            try {
                stat = connection.prepareStatement("SELECT id, name, email, type, regts, status, tenant, deleted_at, deleted_note, brand from account_archive WHERE id = ?;");
                stat.setString(1, id.getInternalId());
                PreparedStatement preparedStatement = stat;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)preparedStatement);
                Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
                AccountArchiveDAO$AjcClosure1 accountArchiveDAO$AjcClosure1 = new AccountArchiveDAO$AjcClosure1(objectArray);
                result = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure1.linkClosureAndJoinPoint(4112));
                if (result.next()) break block3;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(result);
                JDBCUtil.close((Statement)stat);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)result);
            JDBCUtil.close((Statement)stat);
            return null;
        }
        ArchivedAccount archivedAccount = this.mapArchivedAccount(id, result);
        JDBCUtil.close((ResultSet)result);
        JDBCUtil.close((Statement)stat);
        return archivedAccount;
    }

    private ArchivedAccount mapArchivedAccount(AccountId id, ResultSet result) throws SQLException {
        ArchivedAccount acc = new ArchivedAccount(id);
        acc.setName(result.getString("name"));
        acc.setEmail(result.getString("email"));
        acc.setRegistrationTimestamp(result.getLong("regts"));
        acc.setType(result.getInt("type"));
        acc.setStatus(result.getLong("status"));
        acc.setTenant(result.getString("tenant"));
        acc.setDeletionTimestamp(result.getLong("deleted_at"));
        acc.setDeletionNote(result.getString("deleted_note"));
        acc.setBrand(result.getString("brand"));
        return acc;
    }

    public List<ArchivedAccount> getAccounts(Connection connection, List<AccountId> accountIdList) throws SQLException {
        if (accountIdList == null || accountIdList.isEmpty()) {
            return Collections.emptyList();
        }
        PreparedStatement query = null;
        ResultSet resultSet = null;
        ArrayList<ArchivedAccount> result = new ArrayList<ArchivedAccount>();
        try {
            List transform = Lists.transform(accountIdList, (Function)new Function<AccountId, String>(){

                public String apply(AccountId input) {
                    return input.getInternalId();
                }
            });
            String[] identities = transform.toArray(new String[transform.size()]);
            StringBuilder sb = new StringBuilder("SELECT id, name, email, type, regts, status, tenant, deleted_at, deleted_note, brand from account_archive WHERE id IN (");
            int listSize = identities.length;
            int i = 0;
            while (i < listSize) {
                sb.append("'").append(identities[i]).append("'");
                if (i < listSize - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append(")");
            PreparedStatement preparedStatement = query = connection.prepareStatement(sb.toString());
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            AccountArchiveDAO$AjcClosure3 accountArchiveDAO$AjcClosure3 = new AccountArchiveDAO$AjcClosure3(objectArray);
            resultSet = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure3.linkClosureAndJoinPoint(4112));
            while (resultSet.next()) {
                result.add(this.mapArchivedAccount(new AccountId(resultSet.getString("id")), resultSet));
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close(resultSet);
            JDBCUtil.close(query);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)resultSet);
        JDBCUtil.close((Statement)query);
        return result;
    }

    public List<ArchivedAccount> getAllAccounts(Connection connection) throws SQLException {
        PreparedStatement query = null;
        ResultSet resultSet = null;
        ArrayList<ArchivedAccount> result = new ArrayList<ArchivedAccount>();
        try {
            PreparedStatement preparedStatement = query = connection.prepareStatement("SELECT id, name, email, type, regts, status, tenant, deleted_at, deleted_note, brand from account_archive");
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            AccountArchiveDAO$AjcClosure5 accountArchiveDAO$AjcClosure5 = new AccountArchiveDAO$AjcClosure5(objectArray);
            resultSet = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure5.linkClosureAndJoinPoint(4112));
            while (resultSet.next()) {
                result.add(this.mapArchivedAccount(new AccountId(resultSet.getString("id")), resultSet));
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close(resultSet);
            JDBCUtil.close((Statement)query);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)resultSet);
        JDBCUtil.close((Statement)query);
        return result;
    }

    protected boolean createAccount(Connection connection, ArchivedAccount account) throws SQLException {
        try {
            ArchivedAccount found = this.getAccount(connection, account.getId());
            if (found != null) {
                return false;
            }
        }
        catch (DAOException dAOException) {}
        String insert = "INSERT INTO account_archive(id, name, email, type, regts, status, tenant, dao_created,dao_updated,deleted_at,deleted_note,brand) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement query = connection.prepareStatement(insert);
        query.setString(1, account.getId().getInternalId());
        query.setString(2, account.getName());
        query.setString(3, account.getEmail());
        query.setInt(4, account.getType());
        query.setLong(5, account.getRegistrationTimestamp());
        query.setLong(6, account.getStatus());
        query.setString(7, account.getTenant());
        query.setLong(8, System.currentTimeMillis());
        query.setLong(9, 0L);
        query.setLong(10, account.getDeletionTimestamp());
        query.setString(11, account.getDeletionNote());
        query.setString(12, account.getBrand());
        PreparedStatement preparedStatement = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)preparedStatement);
        Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
        AccountArchiveDAO$AjcClosure7 accountArchiveDAO$AjcClosure7 = new AccountArchiveDAO$AjcClosure7(objectArray);
        return Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure7.linkClosureAndJoinPoint(4112))) == 1;
    }

    protected boolean updateAccount(Connection connection, ArchivedAccount account) throws SQLException, DAOException {
        String update = "UPDATE account_archive set name = ?, email = ?, type = ?, regts = ?, status = ?, tenant = ?, deleted_at = ?, deleted_note = ?, dao_updated = ?, brand = ? WHERE id = ?";
        PreparedStatement query = connection.prepareStatement(update);
        query.setString(1, account.getName());
        query.setString(2, account.getEmail());
        query.setInt(3, account.getType());
        query.setLong(4, account.getRegistrationTimestamp());
        query.setLong(5, account.getStatus());
        query.setString(6, account.getTenant());
        query.setLong(7, account.getDeletionTimestamp());
        query.setString(8, account.getDeletionNote());
        query.setLong(9, System.currentTimeMillis());
        query.setString(10, account.getBrand());
        query.setString(11, account.getId().getInternalId());
        PreparedStatement preparedStatement = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)preparedStatement);
        Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
        AccountArchiveDAO$AjcClosure9 accountArchiveDAO$AjcClosure9 = new AccountArchiveDAO$AjcClosure9(objectArray);
        int updated = Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure9.linkClosureAndJoinPoint(4112)));
        if (updated > 1) {
            throw new DAOException("There is more than 1 records update by Query: " + query);
        }
        return updated == 1;
    }

    public void saveAccount(Connection connection, ArchivedAccount account) throws SQLException, DAOException {
        if (!this.updateAccount(connection, account)) {
            this.createAccount(connection, account);
        }
    }

    public void deleteAccount(Connection connection, AccountId id) throws SQLException, DAOException {
        String query = "DELETE FROM account_archive WHERE id = ?";
        PreparedStatement delete = connection.prepareStatement(query);
        delete.setString(1, id.getInternalId());
        PreparedStatement preparedStatement = delete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)preparedStatement);
        Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
        AccountArchiveDAO$AjcClosure11 accountArchiveDAO$AjcClosure11 = new AccountArchiveDAO$AjcClosure11(objectArray);
        int affected = Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure11.linkClosureAndJoinPoint(4112)));
        if (affected != 1) {
            throw new DAOException("There is more than 1 records update by Query: " + query);
        }
    }

    public String getCustomNote(Connection connection, AccountId id) throws SQLException, DAOException {
        String string;
        String sql = "SELECT custom_note FROM account_archive WHERE id = ?";
        PreparedStatement select = null;
        ResultSet result = null;
        try {
            select = connection.prepareStatement(sql);
            select.setString(1, id.getInternalId());
            PreparedStatement preparedStatement = select;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            AccountArchiveDAO$AjcClosure13 accountArchiveDAO$AjcClosure13 = new AccountArchiveDAO$AjcClosure13(objectArray);
            result = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure13.linkClosureAndJoinPoint(4112));
            string = !result.next() ? "" : result.getString(1);
        }
        catch (Throwable throwable) {
            JDBCUtil.close(result);
            JDBCUtil.close((Statement)select);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)result);
        JDBCUtil.close((Statement)select);
        return string;
    }

    public boolean saveCustomNote(Connection connection, AccountId accountId, String customNote) throws SQLException, DAOException {
        String update = "UPDATE account_archive set custom_note = ?, dao_updated = ? WHERE id = ?";
        PreparedStatement query = connection.prepareStatement(update);
        query.setString(1, customNote);
        query.setLong(2, System.currentTimeMillis());
        query.setString(3, accountId.getInternalId());
        PreparedStatement preparedStatement = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)preparedStatement);
        Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
        AccountArchiveDAO$AjcClosure15 accountArchiveDAO$AjcClosure15 = new AccountArchiveDAO$AjcClosure15(objectArray);
        int updated = Conversions.intValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure15.linkClosureAndJoinPoint(4112)));
        if (updated > 1) {
            throw new DAOException("There is more than 1 records update by Query: " + query);
        }
        return updated == 1;
    }

    public AccountId getIdByName(Connection connection, String name) throws SQLException, DAOException {
        return this.getIdByField(connection, "name", name);
    }

    protected AccountId getIdByField(Connection connection, String fieldName, String fieldValue) throws SQLException, DAOException {
        ResultSet result;
        PreparedStatement select;
        block3: {
            String sql = "SELECT id FROM account_archive WHERE " + fieldName + " = ?";
            select = null;
            result = null;
            try {
                select = connection.prepareStatement(sql);
                select.setString(1, fieldValue);
                PreparedStatement preparedStatement = select;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)preparedStatement);
                Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
                AccountArchiveDAO$AjcClosure17 accountArchiveDAO$AjcClosure17 = new AccountArchiveDAO$AjcClosure17(objectArray);
                result = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure17.linkClosureAndJoinPoint(4112));
                if (result.next()) break block3;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(result);
                JDBCUtil.close((Statement)select);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)result);
            JDBCUtil.close((Statement)select);
            return null;
        }
        AccountId accountId = new AccountId(result.getString(1));
        JDBCUtil.close((ResultSet)result);
        JDBCUtil.close((Statement)select);
        return accountId;
    }

    public AccountId getIdByEmail(Connection connection, String email) throws SQLException, DAOException {
        return this.getIdByField(connection, "email", email);
    }

    public Collection<AccountId> getAccountIds(Connection connection) throws SQLException {
        PreparedStatement query;
        ArrayList<AccountId> result = new ArrayList<AccountId>();
        PreparedStatement preparedStatement = query = connection.prepareStatement("select id from account_archive");
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)preparedStatement);
        Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
        AccountArchiveDAO$AjcClosure19 accountArchiveDAO$AjcClosure19 = new AccountArchiveDAO$AjcClosure19(objectArray);
        ResultSet rs = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure19.linkClosureAndJoinPoint(4112));
        try {
            while (rs.next()) {
                result.add(new AccountId(rs.getString(1)));
            }
        }
        finally {
            JDBCUtil.close((ResultSet)rs);
            JDBCUtil.close((Statement)query);
        }
        return result;
    }

    public List<AccountId> getAccountIdsByType(Connection connection, int type) throws SQLException {
        ArrayList<AccountId> arrayList;
        ArrayList<AccountId> result = new ArrayList<AccountId>();
        String sql = "SELECT id FROM account_archive WHERE type = ?";
        PreparedStatement select = null;
        ResultSet rs = null;
        try {
            select = connection.prepareStatement(sql);
            select.setInt(1, type);
            PreparedStatement preparedStatement = select;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)preparedStatement);
            Object[] objectArray = new Object[]{this, preparedStatement, joinPoint};
            AccountArchiveDAO$AjcClosure21 accountArchiveDAO$AjcClosure21 = new AccountArchiveDAO$AjcClosure21(objectArray);
            rs = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure21.linkClosureAndJoinPoint(4112));
            while (rs.next()) {
                result.add(new AccountId(rs.getString("id")));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            JDBCUtil.close(rs);
            JDBCUtil.close((Statement)select);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)rs);
        JDBCUtil.close((Statement)select);
        return arrayList;
    }

    public List<ArchivedAccount> getAccountsByQuery(Connection connection, ArchivedAccountQuery query) throws SQLException {
        String types;
        StringBuilder sqlRawQuery = new StringBuilder("SELECT id, name, email, type, status, regts, deleted_at, deleted_note, tenant, brand FROM account_archive");
        sqlRawQuery.append(" WHERE 1=1");
        if (query.getRegisteredFrom() != null) {
            sqlRawQuery.append(" AND regts >= ").append(query.getRegisteredFrom());
        }
        if (query.getRegisteredTill() != null) {
            sqlRawQuery.append(" AND regts <= ").append(query.getRegisteredTill());
        }
        if (!query.getIds().isEmpty()) {
            String ids = StringUtils.concatenateTokens(query.getIds(), (char)',', (char)'\'', (char)'\'');
            sqlRawQuery.append(" AND id IN (").append(ids).append(")");
        }
        if (!query.getDeletedNotes().isEmpty()) {
            String deletedNode = StringUtils.concatenateTokens(query.getIds(), (char)',', (char)'\'', (char)'\'');
            sqlRawQuery.append(" AND deleted_note IN (").append(deletedNode).append(")");
        }
        if (!StringUtils.isEmpty((String)query.getEmailMask())) {
            sqlRawQuery.append(" AND email LIKE '").append(query.getEmailMask()).append("'");
        }
        if (!StringUtils.isEmpty((String)query.getNameMask())) {
            sqlRawQuery.append(" AND name LIKE '").append(query.getNameMask()).append("'");
        }
        if (!StringUtils.isEmpty((String)query.getIdMask())) {
            sqlRawQuery.append(" AND id LIKE '").append(query.getIdMask()).append("'");
        }
        if (!query.getTypesIncluded().isEmpty()) {
            types = StringUtils.concatenateTokens(query.getTypesIncluded(), (String)",");
            sqlRawQuery.append(" AND type IN (").append(types).append(")");
        }
        if (!query.getTypesExcluded().isEmpty()) {
            types = StringUtils.concatenateTokens(query.getTypesExcluded(), (String)",");
            sqlRawQuery.append(" AND type NOT IN (").append(types).append(")");
        }
        if (query.getDeletedFrom() != null) {
            sqlRawQuery.append(" AND deleted_at >= ").append(query.getDeletedFrom());
        }
        if (query.getDeletedTill() != null) {
            sqlRawQuery.append(" AND deleted_at <= ").append(query.getDeletedTill());
        }
        if (!query.getTenants().isEmpty()) {
            String tenantsStr = StringUtils.concatenateTokens(query.getTenants(), (char)',', (char)'\'', (char)'\'');
            sqlRawQuery.append("AND tenant in (").append(tenantsStr).append(")");
        }
        if (!StringUtils.isEmpty((String)query.getBrand())) {
            sqlRawQuery.append("AND brand = '").append(query.getBrand()).append("'");
        }
        sqlRawQuery.append(" ORDER BY regts DESC");
        String sqlQuery = sqlRawQuery.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAccountsByQuery(Connection, AccountQuery) executing with query[" + sqlQuery + "].");
        }
        ArrayList<ArchivedAccount> rawResult = new ArrayList<ArchivedAccount>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            String string = sqlQuery;
            Statement statement2 = statement;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)statement2, (Object)string);
            Object[] objectArray = new Object[]{this, statement2, string, joinPoint};
            AccountArchiveDAO$AjcClosure23 accountArchiveDAO$AjcClosure23 = new AccountArchiveDAO$AjcClosure23(objectArray);
            rs = (ResultSet)ConnectionCallAspect.aspectOf().doBasicProfiling(accountArchiveDAO$AjcClosure23.linkClosureAndJoinPoint(4112), string);
            while (rs.next()) {
                ArchivedAccount account = new ArchivedAccount(new AccountId(rs.getString("id")));
                account.setName(rs.getString("name"));
                account.setEmail(rs.getString("email"));
                account.setType(rs.getInt("type"));
                account.setStatus(rs.getLong("status"));
                account.setRegistrationTimestamp(rs.getLong("regts"));
                account.setDeletionTimestamp(rs.getLong("deleted_at"));
                account.setDeletionNote(rs.getString("deleted_note"));
                account.setTenant(rs.getString("tenant"));
                account.setBrand(rs.getString("brand"));
                rawResult.add(account);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close(rs);
            JDBCUtil.close((Statement)statement);
            throw throwable;
        }
        JDBCUtil.close((ResultSet)rs);
        JDBCUtil.close((Statement)statement);
        if (rawResult.isEmpty()) {
            return rawResult;
        }
        if (query.getStatusesIncluded().isEmpty() && query.getStatusesExcluded().isEmpty()) {
            return rawResult;
        }
        ArrayList<ArchivedAccount> result = new ArrayList<ArchivedAccount>();
        for (ArchivedAccount account : rawResult) {
            boolean skip = false;
            for (Long status : query.getStatusesIncluded()) {
                if (account.hasStatus(status)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            for (Long status : query.getStatusesExcluded()) {
                if (!account.hasStatus(status)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            result.add(account);
        }
        return result;
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody0(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody2(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody4(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ int executeUpdate_aroundBody6(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    static final /* synthetic */ int executeUpdate_aroundBody8(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    static final /* synthetic */ int executeUpdate_aroundBody10(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody12(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ int executeUpdate_aroundBody14(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeUpdate();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody16(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody18(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody20(AccountArchiveDAO accountArchiveDAO, PreparedStatement preparedStatement, JoinPoint joinPoint) {
        return preparedStatement.executeQuery();
    }

    static final /* synthetic */ ResultSet executeQuery_aroundBody22(AccountArchiveDAO accountArchiveDAO, Statement statement, String string, JoinPoint joinPoint) {
        return statement.executeQuery(string);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccountArchiveDAO.java", AccountArchiveDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 41);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 91);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 259);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.Statement", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.ResultSet"), 334);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 108);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 142);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 160);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 177);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 190);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeUpdate", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "int"), 204);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 222);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "executeQuery", "java.sql.PreparedStatement", "", "", "java.sql.SQLException", "java.sql.ResultSet"), 239);
    }
}

