/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.accountarchive;

import java.io.Serializable;
import net.anotheria.portalkit.services.account.Account;
import net.anotheria.portalkit.services.common.AccountId;

public class ArchivedAccount
extends Account
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7238185562478440815L;
    private long deletionTimestamp;
    private String deletionNote;

    public ArchivedAccount() {
    }

    public ArchivedAccount(AccountId id) {
        super(id);
    }

    public ArchivedAccount(Account account) {
        super(account);
        this.setId(account.getId());
    }

    public long getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    public void setDeletionTimestamp(long deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    public String getDeletionNote() {
        return this.deletionNote;
    }

    public void setDeletionNote(String deletionNote) {
        this.deletionNote = deletionNote;
    }

    protected void copyFrom(Account anotherAccount) {
        super.copyFrom(anotherAccount);
        this.setRegistrationTimestamp(anotherAccount.getRegistrationTimestamp());
        this.setTenant(anotherAccount.getTenant());
        if (anotherAccount instanceof ArchivedAccount) {
            this.deletionTimestamp = ((ArchivedAccount)anotherAccount).getDeletionTimestamp();
            this.deletionNote = ((ArchivedAccount)anotherAccount).getDeletionNote();
        }
    }
}

