/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.accountarchive.event;

import net.anotheria.portalkit.services.accountarchive.event.AccountArchiveServiceOperationType;
import net.anotheria.portalkit.services.accountarchive.event.data.ArchivedAccountEventData;
import net.anotheria.portalkit.services.accountarchive.event.data.ArchivedAccountUpdateEventData;
import net.anotheria.portalkit.services.common.eventing.AbstractServiceEventConsumer;
import net.anotheria.portalkit.services.common.eventing.ServiceEventData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountArchiveServiceEventConsumer
extends AbstractServiceEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountArchiveServiceEventConsumer.class);
    public static final String EVENT_CONSUMER = "AccountArchiveServiceEventConsumer";

    protected AccountArchiveServiceEventConsumer() {
        super(EVENT_CONSUMER, "AccountArchiveServiceEventChannel");
    }

    protected void serviceEvent(ServiceEventData eventData) {
        if (eventData == null) {
            throw new IllegalArgumentException("eventData is null");
        }
        switch (AccountArchiveServiceOperationType.valueOf(eventData.getOperationType())) {
            case ACCOUNT_CREATE: {
                if (eventData instanceof ArchivedAccountEventData) {
                    this.archivedAccountCreated((ArchivedAccountEventData)((Object)ArchivedAccountEventData.class.cast(eventData)));
                    break;
                }
                LOGGER.error("unexpected type of eventData");
                break;
            }
            case ACCOUNT_DELETE: {
                if (eventData instanceof ArchivedAccountEventData) {
                    this.archivedAccountDeleted((ArchivedAccountEventData)((Object)ArchivedAccountEventData.class.cast(eventData)));
                    break;
                }
                LOGGER.error("unexpected type of eventData");
                break;
            }
            case ACCOUNT_UPDATE: {
                if (eventData instanceof ArchivedAccountUpdateEventData) {
                    this.archivedAccountUpdated((ArchivedAccountUpdateEventData)((Object)ArchivedAccountUpdateEventData.class.cast(eventData)));
                    break;
                }
                LOGGER.error("unexpected type of eventData");
            }
        }
    }

    protected abstract void archivedAccountCreated(ArchivedAccountEventData var1);

    protected abstract void archivedAccountUpdated(ArchivedAccountUpdateEventData var1);

    protected abstract void archivedAccountDeleted(ArchivedAccountEventData var1);
}

