/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.accountarchive;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.moskito.aop.annotation.Monitor;
import net.anotheria.moskito.aop.aspect.MonitoringAspect;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveService;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure1;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure11;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure13;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure15;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure17;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure19;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure21;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure23;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure3;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure5;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure7;
import net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl$AjcClosure9;
import net.anotheria.portalkit.services.accountarchive.ArchivedAccount;
import net.anotheria.portalkit.services.accountarchive.ArchivedAccountNotFoundException;
import net.anotheria.portalkit.services.accountarchive.ArchivedAccountQuery;
import net.anotheria.portalkit.services.accountarchive.event.AccountArchiveServiceEventSupplier;
import net.anotheria.portalkit.services.accountarchive.persistence.AccountArchivePersistenceService;
import net.anotheria.portalkit.services.accountarchive.persistence.ArchivedAccountPersistenceServiceException;
import net.anotheria.portalkit.services.common.AccountId;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Monitor(subsystem="portalkit")
public class AccountArchiveServiceImpl
implements AccountArchiveService {
    private AccountArchivePersistenceService persistenceService;
    private AccountArchiveServiceEventSupplier eventSupplier = new AccountArchiveServiceEventSupplier();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    public AccountArchiveServiceImpl() {
        try {
            this.persistenceService = (AccountArchivePersistenceService)MetaFactory.get(AccountArchivePersistenceService.class);
        }
        catch (MetaFactoryException e) {
            throw new IllegalStateException("Can't start without persistence service ", e);
        }
    }

    @Override
    public ArchivedAccount getAccount(AccountId accountId) throws AccountArchiveServiceException {
        AccountId accountId2 = accountId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)accountId2);
        Object[] objectArray = new Object[]{this, accountId2, joinPoint};
        return (ArchivedAccount)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public List<ArchivedAccount> getAccounts(List<AccountId> accountIds) throws AccountArchiveServiceException {
        List<AccountId> list = accountIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        return (List)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void deleteAccount(AccountId accountId) throws AccountArchiveServiceException {
        AccountId accountId2 = accountId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)accountId2);
        Object[] objectArray = new Object[]{this, accountId2, joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void deleteAccountsByEmail(String pattern) throws AccountArchiveServiceException {
        String string = pattern;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void updateAccount(ArchivedAccount toUpdate) throws AccountArchiveServiceException {
        ArchivedAccount archivedAccount = toUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)archivedAccount);
        Object[] objectArray = new Object[]{this, archivedAccount, joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public ArchivedAccount createAccount(ArchivedAccount toUpdate) throws AccountArchiveServiceException {
        ArchivedAccount archivedAccount = toUpdate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)archivedAccount);
        Object[] objectArray = new Object[]{this, archivedAccount, joinPoint};
        return (ArchivedAccount)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public String getCustomNote(AccountId accountId) throws AccountArchiveServiceException {
        AccountId accountId2 = accountId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)accountId2);
        Object[] objectArray = new Object[]{this, accountId2, joinPoint};
        return (String)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public void saveCustomNote(AccountId accountId, String customNote) throws AccountArchiveServiceException {
        AccountId accountId2 = accountId;
        String string = customNote;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)accountId2, (Object)string);
        Object[] objectArray = new Object[]{this, accountId2, string, joinPoint};
        MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public ArchivedAccount getAccountByName(String name) throws AccountArchiveServiceException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (ArchivedAccount)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public ArchivedAccount getAccountByEmail(String email) throws AccountArchiveServiceException {
        String string = email;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (ArchivedAccount)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public List<ArchivedAccount> getAllAccounts() throws AccountArchiveServiceException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    @Override
    public List<ArchivedAccount> getAccountsByQuery(ArchivedAccountQuery query) throws AccountArchiveServiceException {
        ArchivedAccountQuery archivedAccountQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)archivedAccountQuery);
        Object[] objectArray = new Object[]{this, archivedAccountQuery, joinPoint};
        return (List)MonitoringAspect.aspectOf().doProfilingClass(new AccountArchiveServiceImpl$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648), AccountArchiveServiceImpl.class.getAnnotation(Monitor.class));
    }

    static {
        AccountArchiveServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ ArchivedAccount getAccount_aroundBody0(AccountArchiveServiceImpl ajc$this, AccountId accountId, JoinPoint joinPoint) {
        try {
            ArchivedAccount account = ajc$this.persistenceService.getAccount(accountId);
            if (account == null) {
                throw new ArchivedAccountNotFoundException(accountId.getInternalId());
            }
            return account;
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ List getAccounts_aroundBody2(AccountArchiveServiceImpl ajc$this, List accountIds, JoinPoint joinPoint) {
        try {
            return ajc$this.persistenceService.getAccounts(accountIds);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ void deleteAccount_aroundBody4(AccountArchiveServiceImpl ajc$this, AccountId accountId, JoinPoint joinPoint) {
        try {
            ArchivedAccount account = ajc$this.persistenceService.getAccount(accountId);
            ajc$this.persistenceService.deleteAccount(accountId);
            ajc$this.eventSupplier.accountDeleted(account);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ void deleteAccountsByEmail_aroundBody6(AccountArchiveServiceImpl ajc$this, String pattern, JoinPoint joinPoint) {
        List<ArchivedAccount> accounts = ajc$this.getAllAccounts();
        Pattern p = Pattern.compile(pattern);
        for (ArchivedAccount account : accounts) {
            Matcher matcher = p.matcher(account.getEmail());
            if (!matcher.matches()) continue;
            ajc$this.deleteAccount(account.getId());
        }
    }

    static final /* synthetic */ void updateAccount_aroundBody8(AccountArchiveServiceImpl ajc$this, ArchivedAccount toUpdate, JoinPoint joinPoint) {
        try {
            ArchivedAccount beforeUpdate = ajc$this.persistenceService.getAccount(toUpdate.getId());
            ajc$this.persistenceService.saveAccount(toUpdate);
            ajc$this.eventSupplier.accountUpdated(beforeUpdate, toUpdate);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ ArchivedAccount createAccount_aroundBody10(AccountArchiveServiceImpl ajc$this, ArchivedAccount toUpdate, JoinPoint joinPoint) {
        try {
            toUpdate.setDeletionTimestamp(System.currentTimeMillis());
            ajc$this.persistenceService.saveAccount(toUpdate);
            ajc$this.eventSupplier.accountCreated(toUpdate);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
        return ajc$this.getAccount(toUpdate.getId());
    }

    static final /* synthetic */ String getCustomNote_aroundBody12(AccountArchiveServiceImpl ajc$this, AccountId accountId, JoinPoint joinPoint) {
        try {
            return ajc$this.persistenceService.getCustomNote(accountId);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ void saveCustomNote_aroundBody14(AccountArchiveServiceImpl ajc$this, AccountId accountId, String customNote, JoinPoint joinPoint) {
        try {
            ajc$this.persistenceService.saveCustomNote(accountId, customNote);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ ArchivedAccount getAccountByName_aroundBody16(AccountArchiveServiceImpl ajc$this, String name, JoinPoint joinPoint) {
        try {
            AccountId id = ajc$this.persistenceService.getIdByName(name);
            if (id == null) {
                throw new ArchivedAccountNotFoundException(name);
            }
            return ajc$this.getAccount(id);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ ArchivedAccount getAccountByEmail_aroundBody18(AccountArchiveServiceImpl ajc$this, String email, JoinPoint joinPoint) {
        try {
            AccountId id = ajc$this.persistenceService.getIdByEmail(email);
            if (id == null) {
                throw new ArchivedAccountNotFoundException(email);
            }
            return ajc$this.getAccount(id);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ List getAllAccounts_aroundBody20(AccountArchiveServiceImpl ajc$this, JoinPoint joinPoint) {
        try {
            return ajc$this.persistenceService.getAllAccounts();
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    static final /* synthetic */ List getAccountsByQuery_aroundBody22(AccountArchiveServiceImpl ajc$this, ArchivedAccountQuery query, JoinPoint joinPoint) {
        try {
            return ajc$this.persistenceService.getAccountsByQuery(query);
        }
        catch (ArchivedAccountPersistenceServiceException e) {
            throw new AccountArchiveServiceException(e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccountArchiveServiceImpl.java", AccountArchiveServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccount", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.common.AccountId", "accountId", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount"), 34);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccounts", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "java.util.List", "accountIds", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "java.util.List"), 47);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllAccounts", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "", "", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "java.util.List"), 147);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccountsByQuery", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.accountarchive.ArchivedAccountQuery", "query", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "java.util.List"), 156);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAccount", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.common.AccountId", "accountId", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "void"), 56);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAccountsByEmail", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "java.lang.String", "pattern", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "void"), 67);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAccount", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount", "toUpdate", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "void"), 80);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createAccount", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount", "toUpdate", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount"), 91);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustomNote", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.common.AccountId", "accountId", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "java.lang.String"), 103);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveCustomNote", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "net.anotheria.portalkit.services.common.AccountId:java.lang.String", "accountId:customNote", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "void"), 112);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccountByName", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "java.lang.String", "name", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount"), 121);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccountByEmail", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceImpl", "java.lang.String", "email", "net.anotheria.portalkit.services.accountarchive.AccountArchiveServiceException", "net.anotheria.portalkit.services.accountarchive.ArchivedAccount"), 134);
    }
}

