/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.portalkit.services.accountarchive.event;

import net.anotheria.portalkit.services.accountarchive.ArchivedAccount;
import net.anotheria.portalkit.services.accountarchive.event.AccountArchiveServiceOperationType;
import net.anotheria.portalkit.services.accountarchive.event.data.ArchivedAccountEventData;
import net.anotheria.portalkit.services.accountarchive.event.data.ArchivedAccountUpdateEventData;
import net.anotheria.portalkit.services.common.eventing.AbstractServiceEventSupplier;

public class AccountArchiveServiceEventSupplier
extends AbstractServiceEventSupplier {
    public static final String EVENT_CHANNEL = "AccountArchiveServiceEventChannel";
    public static final String EVENT_SUPPLIER = "AccountArchiveServiceEventSupplier";

    public AccountArchiveServiceEventSupplier() {
        super(EVENT_SUPPLIER, EVENT_CHANNEL);
    }

    public void accountCreated(ArchivedAccount archivedAccount) {
        if (archivedAccount == null) {
            throw new IllegalArgumentException("archivedAccount is null");
        }
        this.send(new ArchivedAccountEventData(AccountArchiveServiceOperationType.ACCOUNT_CREATE, archivedAccount));
    }

    public void accountUpdated(ArchivedAccount beforeUpdate, ArchivedAccount afterUpdate) {
        if (beforeUpdate == null) {
            throw new IllegalArgumentException("beforeUpdate is null");
        }
        if (afterUpdate == null) {
            throw new IllegalArgumentException("afterUpdate is null");
        }
        this.send(new ArchivedAccountUpdateEventData(beforeUpdate, afterUpdate));
    }

    public void accountDeleted(ArchivedAccount archivedAccount) {
        if (archivedAccount == null) {
            throw new IllegalArgumentException("archivedAccount is null");
        }
        this.send(new ArchivedAccountEventData(AccountArchiveServiceOperationType.ACCOUNT_DELETE, archivedAccount));
    }
}

