/**
 ********************************************************************************
 *** ShowPdfTemplatesAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.bean.PdfTemplateListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asresourcedata.bean.PdfTemplateListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowPdfTemplatesAction extends BasePdfTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PdfTemplate";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PdfTemplate";
	private static Logger log = LoggerFactory.getLogger(ShowPdfTemplatesAction.class);
	private Sorter<PdfTemplateListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ShowPdfTemplatesAction(){
		sorter = new QuickSorter<PdfTemplateListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = PdfTemplateListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PdfTemplateListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PdfTemplateListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PdfTemplateListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PdfTemplateListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PdfTemplateListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<PdfTemplate> _unfiltered_pdftemplates = getASResourceDataService().getPdfTemplates();
		List<PdfTemplate> pdftemplates = new ArrayList<PdfTemplate>();
		for (int i=0; i<_unfiltered_pdftemplates.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_pdftemplates.get(i), "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass(_unfiltered_pdftemplates.get(i), "Any", filterParameter1));
			if (mayPass)
				pdftemplates.add(_unfiltered_pdftemplates.get(i));
		}
		List<PdfTemplateListItemBean> beans = new ArrayList<PdfTemplateListItemBean>(pdftemplates.size());
		for (PdfTemplate pdftemplate : pdftemplates){
			checkPdfTemplates(pdftemplate, req);
			PdfTemplateListItemBean bean = makePdfTemplateListItemBean(pdftemplate);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "pdftemplates", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer("Any"));
		return mapping.success();
	}

	protected PdfTemplateListItemBean makePdfTemplateListItemBean(PdfTemplate pdftemplate) {
		PdfTemplateListItemBean bean = new PdfTemplateListItemBean();
		bean.setPlainId(pdftemplate.getId());
		bean.setIdForSorting(pdftemplate.getId());
		bean.setId(idDecorator.decorate(pdftemplate, "id", "3"));
		bean.setNameForSorting(pdftemplate.getName());
		bean.setName(nameDecorator.decorate(pdftemplate, "name", "null"));
		bean.setLocked(((LockableObject)pdftemplate).isLocked());
		bean.setLockerId(((LockableObject)pdftemplate).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)pdftemplate).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)pdftemplate).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(pdftemplate.getLastUpdateTimestamp()));
		return bean;
	}
}
