/**
 ********************************************************************************
 *** ShowPermissionsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.PermissionListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.PermissionListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowPermissionsAction extends BasePermissionAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Permission";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Permission";
	private static Logger log = LoggerFactory.getLogger(ShowPermissionsAction.class);
	private Sorter<PermissionListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowPermissionsAction(){
		sorter = new QuickSorter<PermissionListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PermissionListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PermissionListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PermissionListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PermissionListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PermissionListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PermissionListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Permission> _unfiltered_permissions = getAnoAccessConfigurationService().getPermissions();
		List<Permission> permissions = new ArrayList<Permission>();
		for (int i=0; i<_unfiltered_permissions.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_permissions.get(i), "name", filterParameter0));
			if (mayPass)
				permissions.add(_unfiltered_permissions.get(i));
		}
		List<PermissionListItemBean> beans = new ArrayList<PermissionListItemBean>(permissions.size());
		for (Permission permission : permissions){
			checkPermissions(permission, req);
			PermissionListItemBean bean = makePermissionListItemBean(permission);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "permissions", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected PermissionListItemBean makePermissionListItemBean(Permission permission) {
		PermissionListItemBean bean = new PermissionListItemBean();
		bean.setPlainId(permission.getId());
		bean.setIdForSorting(permission.getId());
		bean.setId(idDecorator.decorate(permission, "id", "3"));
		bean.setNameForSorting(permission.getName());
		bean.setName(nameDecorator.decorate(permission, "name", "null"));
		bean.setAccessOperation(permission.getAccessOperation());
		bean.setPriority(permission.getPriority());
		bean.setDeny(permission.getDeny());
		bean.setConstraints(permission.getConstraints());
		bean.setDescription(permission.getDescription());
		bean.setLocked(((LockableObject)permission).isLocked());
		bean.setLockerId(((LockableObject)permission).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)permission).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)permission).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(permission.getLastUpdateTimestamp()));
		return bean;
	}
}
