/**
 ********************************************************************************
 *** ASResourceDataServiceImpl.java                                           ***
 *** The implementation of the IASResourceDataService.                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asresourcedata.data.ModuleASResourceData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.data.TextResourceXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.TextResourceDocument;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleDocument;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplateXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplateDocument;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.data.ImageXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.ImageDocument;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import java.io.File;
import java.io.FileNotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import net.anotheria.anosite.util.staticutil.JerseyClientUtil;
import net.anotheria.anosite.config.DocumentTransferConfig;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkXMLHelper;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkDocument;

public class ASResourceDataServiceImpl extends BasicCMSService implements IASResourceDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASResourceDataServiceImpl instance;

	private ASResourceDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AsResourceListener());
		addModuleListener(ModuleASResourceData.MODULE_ID, this);
	}

	static final ASResourceDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASResourceDataServiceImpl();
		}
		return instance;
	}

	private ModuleASResourceData _getModuleASResourceData(){
		return (ModuleASResourceData) getModule(ModuleASResourceData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<TextResource> getTextResources(){
		List<TextResource> textresources = new ArrayList<>();
		textresources.addAll(_getModuleASResourceData().getTextResources());
		return textresources;
	}

	@Override
	public List<TextResource> getTextResources(SortType sortType){
		return StaticQuickSorter.sort(getTextResources(), sortType);
	}

	/**
	 * Returns the TextResource objects with the specified ids.
	 */
	public List<TextResource> getTextResources(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<TextResource> all = getTextResources();
		List<TextResource> ret = new ArrayList<>();
		for (TextResource textresource : all){
			if(ids.contains(textresource.getId())){
				ret.add(textresource);
			}
		}
		return ret;
	}

	/**
	 * Returns the TextResource objects with the specified ids, sorted by given sorttype.
	 */
	public List<TextResource> getTextResources(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getTextResources(ids), sortType);
	}

	@Override
	public void deleteTextResource(TextResource textresource){
		deleteTextResource(textresource.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(textresource);
		}
	}

	@Override
	public void deleteTextResource(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		TextResource varValue = hasServiceListeners()?module.getTextResource(id):null;
		module.deleteTextResource(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteTextResources(List<TextResource> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (TextResource textresource : list){
			module.deleteTextResource(textresource.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public TextResource getTextResource(String id){
		return _getModuleASResourceData().getTextResource(id);
	}

	@Override
	public TextResource importTextResource(TextResource textresource){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importTextResource((TextResourceDocument)textresource);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(textresource);
		}
		return textresource;
	}

	@Override
	public List<TextResource> importTextResources(List<TextResource> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<TextResource> ret = new ArrayList<>();
		for (TextResource textresource : list){
			TextResource imported = module.importTextResource((TextResourceDocument)textresource);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (TextResource textresource : ret)
				fireObjectImportedEvent(textresource);
		}
		return ret;
	}

	@Override
	public TextResource createTextResource(TextResource textresource){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createTextResource((TextResourceDocument)textresource);
		updateModule(module);
		fireObjectCreatedEvent(textresource);
		return textresource;
	}

	@Override
	/**
	 * Creates multiple new TextResource objects.
	 * Returns the created versions.
	 */
	public List<TextResource> createTextResources(List<TextResource> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<TextResource> ret = new ArrayList<>();
		for (TextResource textresource : list){
			TextResource created = module.createTextResource((TextResourceDocument)textresource);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (TextResource textresource : ret)
				fireObjectCreatedEvent(textresource);
		}
		return ret;
	}

	@Override
	public TextResource updateTextResource(TextResource textresource){
		TextResource oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getTextResource(textresource.getId());
		module.updateTextResource((TextResourceDocument)textresource);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, textresource);
		}
		return textresource;
	}

	@Override
	public List<TextResource> updateTextResources(List<TextResource> list){
		List<TextResource> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (TextResource textresource : list){
			if (oldList!=null)
				oldList.add(module.getTextResource(textresource.getId()));
			module.updateTextResource((TextResourceDocument)textresource);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<TextResource> getTextResourcesByProperty(String propertyName, Object value){
		List<TextResource> allTextResources = getTextResources();
		List<TextResource> ret = new ArrayList<>();
		for (int i=0; i<allTextResources.size(); i++){
			TextResource textresource = allTextResources.get(i);
			try{
				Property property = ((TextResourceDocument)textresource).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(textresource);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(textresource);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(textresource);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<TextResource> getTextResourcesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getTextResourcesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on TextResources
	 */
	public QueryResult executeQueryOnTextResources(DocumentQuery query){
		List<TextResource> allTextResources = getTextResources();
		QueryResult result = new QueryResult();
		for (int i=0; i<allTextResources.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allTextResources.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all TextResource objects, where property matches.
	 */
	public List<TextResource> getTextResourcesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<TextResource> ret = new ArrayList<>();
		List<TextResource> src = getTextResources();
		for ( TextResource textresource : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(textresource.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(textresource);
		}
		return ret;
	}

	/**
	 * Returns all TextResource objects, where property matches, sorted
	 */
	public List<TextResource> getTextResourcesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getTextResourcesByProperty(property), sortType);
	}

	/**
	 * Returns TextResource objects count.
	 */
	public int getTextResourcesCount() {
		return _getModuleASResourceData().getTextResources().size();
	}

	/**
	 * Returns TextResource objects segment.
	 */
	public List<TextResource> getTextResources(Segment aSegment) {
		return Slicer.slice(aSegment, getTextResources()).getSliceData();
	}

	/**
	 * Returns TextResource objects segment, where property matched.
	 */
	public List<TextResource> getTextResourcesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<TextResource> ret = new ArrayList<>();
		List<TextResource> src = getTextResources();
		for (TextResource textresource : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(textresource.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(textresource);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns TextResource objects segment, where property matched, sorted.
	 */
	public List<TextResource> getTextResourcesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getTextResourcesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchTextResource(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("TextResource" + id))
			return;

		try {
			final TextResourceDocument textresource = _getModuleASResourceData().getTextResource(id);
			addedDocuments.add("TextResource" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(textresource);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_TextResource");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this TextResource instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this TextResource instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredTextResource(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			TextResource textresource = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), TextResourceDocument.class);

			try {
				updateTextResource(textresource);
			}catch(Exception e){
				importTextResource(textresource);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json TextResource instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this TextResource instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllTextResources(String sourceLanguage, String targetLanguage){
		List<TextResource> allDocumentsSrc = getTextResources();
		List<TextResource> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (TextResource document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateTextResources(allDocuments);
	}

	@Override
	public List<LocalizationBundle> getLocalizationBundles(){
		List<LocalizationBundle> localizationbundles = new ArrayList<>();
		localizationbundles.addAll(_getModuleASResourceData().getLocalizationBundles());
		return localizationbundles;
	}

	@Override
	public List<LocalizationBundle> getLocalizationBundles(SortType sortType){
		return StaticQuickSorter.sort(getLocalizationBundles(), sortType);
	}

	/**
	 * Returns the LocalizationBundle objects with the specified ids.
	 */
	public List<LocalizationBundle> getLocalizationBundles(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<LocalizationBundle> all = getLocalizationBundles();
		List<LocalizationBundle> ret = new ArrayList<>();
		for (LocalizationBundle localizationbundle : all){
			if(ids.contains(localizationbundle.getId())){
				ret.add(localizationbundle);
			}
		}
		return ret;
	}

	/**
	 * Returns the LocalizationBundle objects with the specified ids, sorted by given sorttype.
	 */
	public List<LocalizationBundle> getLocalizationBundles(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getLocalizationBundles(ids), sortType);
	}

	@Override
	public void deleteLocalizationBundle(LocalizationBundle localizationbundle){
		deleteLocalizationBundle(localizationbundle.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(localizationbundle);
		}
	}

	@Override
	public void deleteLocalizationBundle(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		LocalizationBundle varValue = hasServiceListeners()?module.getLocalizationBundle(id):null;
		module.deleteLocalizationBundle(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteLocalizationBundles(List<LocalizationBundle> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (LocalizationBundle localizationbundle : list){
			module.deleteLocalizationBundle(localizationbundle.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public LocalizationBundle getLocalizationBundle(String id){
		return _getModuleASResourceData().getLocalizationBundle(id);
	}

	@Override
	public LocalizationBundle importLocalizationBundle(LocalizationBundle localizationbundle){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importLocalizationBundle((LocalizationBundleDocument)localizationbundle);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(localizationbundle);
		}
		return localizationbundle;
	}

	@Override
	public List<LocalizationBundle> importLocalizationBundles(List<LocalizationBundle> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<LocalizationBundle> ret = new ArrayList<>();
		for (LocalizationBundle localizationbundle : list){
			LocalizationBundle imported = module.importLocalizationBundle((LocalizationBundleDocument)localizationbundle);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (LocalizationBundle localizationbundle : ret)
				fireObjectImportedEvent(localizationbundle);
		}
		return ret;
	}

	@Override
	public LocalizationBundle createLocalizationBundle(LocalizationBundle localizationbundle){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createLocalizationBundle((LocalizationBundleDocument)localizationbundle);
		updateModule(module);
		fireObjectCreatedEvent(localizationbundle);
		return localizationbundle;
	}

	@Override
	/**
	 * Creates multiple new LocalizationBundle objects.
	 * Returns the created versions.
	 */
	public List<LocalizationBundle> createLocalizationBundles(List<LocalizationBundle> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<LocalizationBundle> ret = new ArrayList<>();
		for (LocalizationBundle localizationbundle : list){
			LocalizationBundle created = module.createLocalizationBundle((LocalizationBundleDocument)localizationbundle);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (LocalizationBundle localizationbundle : ret)
				fireObjectCreatedEvent(localizationbundle);
		}
		return ret;
	}

	@Override
	public LocalizationBundle updateLocalizationBundle(LocalizationBundle localizationbundle){
		LocalizationBundle oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getLocalizationBundle(localizationbundle.getId());
		module.updateLocalizationBundle((LocalizationBundleDocument)localizationbundle);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, localizationbundle);
		}
		return localizationbundle;
	}

	@Override
	public List<LocalizationBundle> updateLocalizationBundles(List<LocalizationBundle> list){
		List<LocalizationBundle> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (LocalizationBundle localizationbundle : list){
			if (oldList!=null)
				oldList.add(module.getLocalizationBundle(localizationbundle.getId()));
			module.updateLocalizationBundle((LocalizationBundleDocument)localizationbundle);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value){
		List<LocalizationBundle> allLocalizationBundles = getLocalizationBundles();
		List<LocalizationBundle> ret = new ArrayList<>();
		for (int i=0; i<allLocalizationBundles.size(); i++){
			LocalizationBundle localizationbundle = allLocalizationBundles.get(i);
			try{
				Property property = ((LocalizationBundleDocument)localizationbundle).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(localizationbundle);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(localizationbundle);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(localizationbundle);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on LocalizationBundles
	 */
	public QueryResult executeQueryOnLocalizationBundles(DocumentQuery query){
		List<LocalizationBundle> allLocalizationBundles = getLocalizationBundles();
		QueryResult result = new QueryResult();
		for (int i=0; i<allLocalizationBundles.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allLocalizationBundles.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all LocalizationBundle objects, where property matches.
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<LocalizationBundle> ret = new ArrayList<>();
		List<LocalizationBundle> src = getLocalizationBundles();
		for ( LocalizationBundle localizationbundle : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(localizationbundle.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(localizationbundle);
		}
		return ret;
	}

	/**
	 * Returns all LocalizationBundle objects, where property matches, sorted
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(property), sortType);
	}

	/**
	 * Returns LocalizationBundle objects count.
	 */
	public int getLocalizationBundlesCount() {
		return _getModuleASResourceData().getLocalizationBundles().size();
	}

	/**
	 * Returns LocalizationBundle objects segment.
	 */
	public List<LocalizationBundle> getLocalizationBundles(Segment aSegment) {
		return Slicer.slice(aSegment, getLocalizationBundles()).getSliceData();
	}

	/**
	 * Returns LocalizationBundle objects segment, where property matched.
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<LocalizationBundle> ret = new ArrayList<>();
		List<LocalizationBundle> src = getLocalizationBundles();
		for (LocalizationBundle localizationbundle : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(localizationbundle.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(localizationbundle);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns LocalizationBundle objects segment, where property matched, sorted.
	 */
	public List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getLocalizationBundlesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchLocalizationBundle(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("LocalizationBundle" + id))
			return;

		try {
			final LocalizationBundleDocument localizationbundle = _getModuleASResourceData().getLocalizationBundle(id);
			addedDocuments.add("LocalizationBundle" + id);

			if (!StringUtils.isEmpty(localizationbundle.getParentBundle()))
				getASResourceDataService().fetchLocalizationBundle(localizationbundle.getParentBundle(), addedDocuments, data);


			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(localizationbundle);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_LocalizationBundle");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASResourceDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this LocalizationBundle instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this LocalizationBundle instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredLocalizationBundle(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			LocalizationBundle localizationbundle = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), LocalizationBundleDocument.class);

			try {
				updateLocalizationBundle(localizationbundle);
			}catch(Exception e){
				importLocalizationBundle(localizationbundle);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json LocalizationBundle instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this LocalizationBundle instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllLocalizationBundles(String sourceLanguage, String targetLanguage){
		List<LocalizationBundle> allDocumentsSrc = getLocalizationBundles();
		List<LocalizationBundle> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (LocalizationBundle document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateLocalizationBundles(allDocuments);
	}

	@Override
	public List<MailTemplate> getMailTemplates(){
		List<MailTemplate> mailtemplates = new ArrayList<>();
		mailtemplates.addAll(_getModuleASResourceData().getMailTemplates());
		return mailtemplates;
	}

	@Override
	public List<MailTemplate> getMailTemplates(SortType sortType){
		return StaticQuickSorter.sort(getMailTemplates(), sortType);
	}

	/**
	 * Returns the MailTemplate objects with the specified ids.
	 */
	public List<MailTemplate> getMailTemplates(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<MailTemplate> all = getMailTemplates();
		List<MailTemplate> ret = new ArrayList<>();
		for (MailTemplate mailtemplate : all){
			if(ids.contains(mailtemplate.getId())){
				ret.add(mailtemplate);
			}
		}
		return ret;
	}

	/**
	 * Returns the MailTemplate objects with the specified ids, sorted by given sorttype.
	 */
	public List<MailTemplate> getMailTemplates(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getMailTemplates(ids), sortType);
	}

	@Override
	public void deleteMailTemplate(MailTemplate mailtemplate){
		deleteMailTemplate(mailtemplate.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(mailtemplate);
		}
	}

	@Override
	public void deleteMailTemplate(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		MailTemplate varValue = hasServiceListeners()?module.getMailTemplate(id):null;
		module.deleteMailTemplate(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteMailTemplates(List<MailTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (MailTemplate mailtemplate : list){
			module.deleteMailTemplate(mailtemplate.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public MailTemplate getMailTemplate(String id){
		return _getModuleASResourceData().getMailTemplate(id);
	}

	@Override
	public MailTemplate importMailTemplate(MailTemplate mailtemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importMailTemplate((MailTemplateDocument)mailtemplate);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(mailtemplate);
		}
		return mailtemplate;
	}

	@Override
	public List<MailTemplate> importMailTemplates(List<MailTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<MailTemplate> ret = new ArrayList<>();
		for (MailTemplate mailtemplate : list){
			MailTemplate imported = module.importMailTemplate((MailTemplateDocument)mailtemplate);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (MailTemplate mailtemplate : ret)
				fireObjectImportedEvent(mailtemplate);
		}
		return ret;
	}

	@Override
	public MailTemplate createMailTemplate(MailTemplate mailtemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createMailTemplate((MailTemplateDocument)mailtemplate);
		updateModule(module);
		fireObjectCreatedEvent(mailtemplate);
		return mailtemplate;
	}

	@Override
	/**
	 * Creates multiple new MailTemplate objects.
	 * Returns the created versions.
	 */
	public List<MailTemplate> createMailTemplates(List<MailTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<MailTemplate> ret = new ArrayList<>();
		for (MailTemplate mailtemplate : list){
			MailTemplate created = module.createMailTemplate((MailTemplateDocument)mailtemplate);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (MailTemplate mailtemplate : ret)
				fireObjectCreatedEvent(mailtemplate);
		}
		return ret;
	}

	@Override
	public MailTemplate updateMailTemplate(MailTemplate mailtemplate){
		MailTemplate oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getMailTemplate(mailtemplate.getId());
		module.updateMailTemplate((MailTemplateDocument)mailtemplate);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, mailtemplate);
		}
		return mailtemplate;
	}

	@Override
	public List<MailTemplate> updateMailTemplates(List<MailTemplate> list){
		List<MailTemplate> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (MailTemplate mailtemplate : list){
			if (oldList!=null)
				oldList.add(module.getMailTemplate(mailtemplate.getId()));
			module.updateMailTemplate((MailTemplateDocument)mailtemplate);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value){
		List<MailTemplate> allMailTemplates = getMailTemplates();
		List<MailTemplate> ret = new ArrayList<>();
		for (int i=0; i<allMailTemplates.size(); i++){
			MailTemplate mailtemplate = allMailTemplates.get(i);
			try{
				Property property = ((MailTemplateDocument)mailtemplate).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(mailtemplate);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(mailtemplate);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(mailtemplate);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getMailTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on MailTemplates
	 */
	public QueryResult executeQueryOnMailTemplates(DocumentQuery query){
		List<MailTemplate> allMailTemplates = getMailTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allMailTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allMailTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all MailTemplate objects, where property matches.
	 */
	public List<MailTemplate> getMailTemplatesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<MailTemplate> ret = new ArrayList<>();
		List<MailTemplate> src = getMailTemplates();
		for ( MailTemplate mailtemplate : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(mailtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(mailtemplate);
		}
		return ret;
	}

	/**
	 * Returns all MailTemplate objects, where property matches, sorted
	 */
	public List<MailTemplate> getMailTemplatesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getMailTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns MailTemplate objects count.
	 */
	public int getMailTemplatesCount() {
		return _getModuleASResourceData().getMailTemplates().size();
	}

	/**
	 * Returns MailTemplate objects segment.
	 */
	public List<MailTemplate> getMailTemplates(Segment aSegment) {
		return Slicer.slice(aSegment, getMailTemplates()).getSliceData();
	}

	/**
	 * Returns MailTemplate objects segment, where property matched.
	 */
	public List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<MailTemplate> ret = new ArrayList<>();
		List<MailTemplate> src = getMailTemplates();
		for (MailTemplate mailtemplate : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(mailtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(mailtemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns MailTemplate objects segment, where property matched, sorted.
	 */
	public List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getMailTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchMailTemplate(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("MailTemplate" + id))
			return;

		try {
			final MailTemplateDocument mailtemplate = _getModuleASResourceData().getMailTemplate(id);
			addedDocuments.add("MailTemplate" + id);


			if (!mailtemplate.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: mailtemplate.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(mailtemplate);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_MailTemplate");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASResourceDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this MailTemplate instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this MailTemplate instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredMailTemplate(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			MailTemplate mailtemplate = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), MailTemplateDocument.class);

			try {
				updateMailTemplate(mailtemplate);
			}catch(Exception e){
				importMailTemplate(mailtemplate);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json MailTemplate instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this MailTemplate instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllMailTemplates(String sourceLanguage, String targetLanguage){
		List<MailTemplate> allDocumentsSrc = getMailTemplates();
		List<MailTemplate> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (MailTemplate document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateMailTemplates(allDocuments);
	}

	@Override
	public List<PdfTemplate> getPdfTemplates(){
		List<PdfTemplate> pdftemplates = new ArrayList<>();
		pdftemplates.addAll(_getModuleASResourceData().getPdfTemplates());
		return pdftemplates;
	}

	@Override
	public List<PdfTemplate> getPdfTemplates(SortType sortType){
		return StaticQuickSorter.sort(getPdfTemplates(), sortType);
	}

	/**
	 * Returns the PdfTemplate objects with the specified ids.
	 */
	public List<PdfTemplate> getPdfTemplates(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<PdfTemplate> all = getPdfTemplates();
		List<PdfTemplate> ret = new ArrayList<>();
		for (PdfTemplate pdftemplate : all){
			if(ids.contains(pdftemplate.getId())){
				ret.add(pdftemplate);
			}
		}
		return ret;
	}

	/**
	 * Returns the PdfTemplate objects with the specified ids, sorted by given sorttype.
	 */
	public List<PdfTemplate> getPdfTemplates(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPdfTemplates(ids), sortType);
	}

	@Override
	public void deletePdfTemplate(PdfTemplate pdftemplate){
		deletePdfTemplate(pdftemplate.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(pdftemplate);
		}
	}

	@Override
	public void deletePdfTemplate(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		PdfTemplate varValue = hasServiceListeners()?module.getPdfTemplate(id):null;
		module.deletePdfTemplate(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePdfTemplates(List<PdfTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (PdfTemplate pdftemplate : list){
			module.deletePdfTemplate(pdftemplate.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public PdfTemplate getPdfTemplate(String id){
		return _getModuleASResourceData().getPdfTemplate(id);
	}

	@Override
	public PdfTemplate importPdfTemplate(PdfTemplate pdftemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importPdfTemplate((PdfTemplateDocument)pdftemplate);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(pdftemplate);
		}
		return pdftemplate;
	}

	@Override
	public List<PdfTemplate> importPdfTemplates(List<PdfTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<PdfTemplate> ret = new ArrayList<>();
		for (PdfTemplate pdftemplate : list){
			PdfTemplate imported = module.importPdfTemplate((PdfTemplateDocument)pdftemplate);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PdfTemplate pdftemplate : ret)
				fireObjectImportedEvent(pdftemplate);
		}
		return ret;
	}

	@Override
	public PdfTemplate createPdfTemplate(PdfTemplate pdftemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createPdfTemplate((PdfTemplateDocument)pdftemplate);
		updateModule(module);
		fireObjectCreatedEvent(pdftemplate);
		return pdftemplate;
	}

	@Override
	/**
	 * Creates multiple new PdfTemplate objects.
	 * Returns the created versions.
	 */
	public List<PdfTemplate> createPdfTemplates(List<PdfTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<PdfTemplate> ret = new ArrayList<>();
		for (PdfTemplate pdftemplate : list){
			PdfTemplate created = module.createPdfTemplate((PdfTemplateDocument)pdftemplate);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PdfTemplate pdftemplate : ret)
				fireObjectCreatedEvent(pdftemplate);
		}
		return ret;
	}

	@Override
	public PdfTemplate updatePdfTemplate(PdfTemplate pdftemplate){
		PdfTemplate oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getPdfTemplate(pdftemplate.getId());
		module.updatePdfTemplate((PdfTemplateDocument)pdftemplate);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, pdftemplate);
		}
		return pdftemplate;
	}

	@Override
	public List<PdfTemplate> updatePdfTemplates(List<PdfTemplate> list){
		List<PdfTemplate> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (PdfTemplate pdftemplate : list){
			if (oldList!=null)
				oldList.add(module.getPdfTemplate(pdftemplate.getId()));
			module.updatePdfTemplate((PdfTemplateDocument)pdftemplate);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value){
		List<PdfTemplate> allPdfTemplates = getPdfTemplates();
		List<PdfTemplate> ret = new ArrayList<>();
		for (int i=0; i<allPdfTemplates.size(); i++){
			PdfTemplate pdftemplate = allPdfTemplates.get(i);
			try{
				Property property = ((PdfTemplateDocument)pdftemplate).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(pdftemplate);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(pdftemplate);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(pdftemplate);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PdfTemplates
	 */
	public QueryResult executeQueryOnPdfTemplates(DocumentQuery query){
		List<PdfTemplate> allPdfTemplates = getPdfTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPdfTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPdfTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PdfTemplate objects, where property matches.
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<PdfTemplate> ret = new ArrayList<>();
		List<PdfTemplate> src = getPdfTemplates();
		for ( PdfTemplate pdftemplate : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(pdftemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pdftemplate);
		}
		return ret;
	}

	/**
	 * Returns all PdfTemplate objects, where property matches, sorted
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns PdfTemplate objects count.
	 */
	public int getPdfTemplatesCount() {
		return _getModuleASResourceData().getPdfTemplates().size();
	}

	/**
	 * Returns PdfTemplate objects segment.
	 */
	public List<PdfTemplate> getPdfTemplates(Segment aSegment) {
		return Slicer.slice(aSegment, getPdfTemplates()).getSliceData();
	}

	/**
	 * Returns PdfTemplate objects segment, where property matched.
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PdfTemplate> ret = new ArrayList<>();
		List<PdfTemplate> src = getPdfTemplates();
		for (PdfTemplate pdftemplate : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(pdftemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pdftemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PdfTemplate objects segment, where property matched, sorted.
	 */
	public List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPdfTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPdfTemplate(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("PdfTemplate" + id))
			return;

		try {
			final PdfTemplateDocument pdftemplate = _getModuleASResourceData().getPdfTemplate(id);
			addedDocuments.add("PdfTemplate" + id);


			if (!pdftemplate.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: pdftemplate.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(pdftemplate);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_PdfTemplate");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASResourceDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this PdfTemplate instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this PdfTemplate instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPdfTemplate(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			PdfTemplate pdftemplate = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PdfTemplateDocument.class);

			try {
				updatePdfTemplate(pdftemplate);
			}catch(Exception e){
				importPdfTemplate(pdftemplate);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json PdfTemplate instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this PdfTemplate instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllPdfTemplates(String sourceLanguage, String targetLanguage){
		List<PdfTemplate> allDocumentsSrc = getPdfTemplates();
		List<PdfTemplate> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (PdfTemplate document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updatePdfTemplates(allDocuments);
	}

	@Override
	public List<PushNotificationTemplate> getPushNotificationTemplates(){
		List<PushNotificationTemplate> pushnotificationtemplates = new ArrayList<>();
		pushnotificationtemplates.addAll(_getModuleASResourceData().getPushNotificationTemplates());
		return pushnotificationtemplates;
	}

	@Override
	public List<PushNotificationTemplate> getPushNotificationTemplates(SortType sortType){
		return StaticQuickSorter.sort(getPushNotificationTemplates(), sortType);
	}

	/**
	 * Returns the PushNotificationTemplate objects with the specified ids.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplates(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<PushNotificationTemplate> all = getPushNotificationTemplates();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		for (PushNotificationTemplate pushnotificationtemplate : all){
			if(ids.contains(pushnotificationtemplate.getId())){
				ret.add(pushnotificationtemplate);
			}
		}
		return ret;
	}

	/**
	 * Returns the PushNotificationTemplate objects with the specified ids, sorted by given sorttype.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplates(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPushNotificationTemplates(ids), sortType);
	}

	@Override
	public void deletePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate){
		deletePushNotificationTemplate(pushnotificationtemplate.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(pushnotificationtemplate);
		}
	}

	@Override
	public void deletePushNotificationTemplate(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		PushNotificationTemplate varValue = hasServiceListeners()?module.getPushNotificationTemplate(id):null;
		module.deletePushNotificationTemplate(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePushNotificationTemplates(List<PushNotificationTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			module.deletePushNotificationTemplate(pushnotificationtemplate.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public PushNotificationTemplate getPushNotificationTemplate(String id){
		return _getModuleASResourceData().getPushNotificationTemplate(id);
	}

	@Override
	public PushNotificationTemplate importPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importPushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(pushnotificationtemplate);
		}
		return pushnotificationtemplate;
	}

	@Override
	public List<PushNotificationTemplate> importPushNotificationTemplates(List<PushNotificationTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			PushNotificationTemplate imported = module.importPushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PushNotificationTemplate pushnotificationtemplate : ret)
				fireObjectImportedEvent(pushnotificationtemplate);
		}
		return ret;
	}

	@Override
	public PushNotificationTemplate createPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createPushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
		updateModule(module);
		fireObjectCreatedEvent(pushnotificationtemplate);
		return pushnotificationtemplate;
	}

	@Override
	/**
	 * Creates multiple new PushNotificationTemplate objects.
	 * Returns the created versions.
	 */
	public List<PushNotificationTemplate> createPushNotificationTemplates(List<PushNotificationTemplate> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			PushNotificationTemplate created = module.createPushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (PushNotificationTemplate pushnotificationtemplate : ret)
				fireObjectCreatedEvent(pushnotificationtemplate);
		}
		return ret;
	}

	@Override
	public PushNotificationTemplate updatePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate){
		PushNotificationTemplate oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getPushNotificationTemplate(pushnotificationtemplate.getId());
		module.updatePushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, pushnotificationtemplate);
		}
		return pushnotificationtemplate;
	}

	@Override
	public List<PushNotificationTemplate> updatePushNotificationTemplates(List<PushNotificationTemplate> list){
		List<PushNotificationTemplate> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (PushNotificationTemplate pushnotificationtemplate : list){
			if (oldList!=null)
				oldList.add(module.getPushNotificationTemplate(pushnotificationtemplate.getId()));
			module.updatePushNotificationTemplate((PushNotificationTemplateDocument)pushnotificationtemplate);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value){
		List<PushNotificationTemplate> allPushNotificationTemplates = getPushNotificationTemplates();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		for (int i=0; i<allPushNotificationTemplates.size(); i++){
			PushNotificationTemplate pushnotificationtemplate = allPushNotificationTemplates.get(i);
			try{
				Property property = ((PushNotificationTemplateDocument)pushnotificationtemplate).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(pushnotificationtemplate);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(pushnotificationtemplate);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(pushnotificationtemplate);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on PushNotificationTemplates
	 */
	public QueryResult executeQueryOnPushNotificationTemplates(DocumentQuery query){
		List<PushNotificationTemplate> allPushNotificationTemplates = getPushNotificationTemplates();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPushNotificationTemplates.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPushNotificationTemplates.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all PushNotificationTemplate objects, where property matches.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<PushNotificationTemplate> ret = new ArrayList<>();
		List<PushNotificationTemplate> src = getPushNotificationTemplates();
		for ( PushNotificationTemplate pushnotificationtemplate : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(pushnotificationtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pushnotificationtemplate);
		}
		return ret;
	}

	/**
	 * Returns all PushNotificationTemplate objects, where property matches, sorted
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(property), sortType);
	}

	/**
	 * Returns PushNotificationTemplate objects count.
	 */
	public int getPushNotificationTemplatesCount() {
		return _getModuleASResourceData().getPushNotificationTemplates().size();
	}

	/**
	 * Returns PushNotificationTemplate objects segment.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplates(Segment aSegment) {
		return Slicer.slice(aSegment, getPushNotificationTemplates()).getSliceData();
	}

	/**
	 * Returns PushNotificationTemplate objects segment, where property matched.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<PushNotificationTemplate> ret = new ArrayList<>();
		List<PushNotificationTemplate> src = getPushNotificationTemplates();
		for (PushNotificationTemplate pushnotificationtemplate : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(pushnotificationtemplate.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pushnotificationtemplate);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns PushNotificationTemplate objects segment, where property matched, sorted.
	 */
	public List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPushNotificationTemplatesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPushNotificationTemplate(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("PushNotificationTemplate" + id))
			return;

		try {
			final PushNotificationTemplateDocument pushnotificationtemplate = _getModuleASResourceData().getPushNotificationTemplate(id);
			addedDocuments.add("PushNotificationTemplate" + id);


			if (!pushnotificationtemplate.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: pushnotificationtemplate.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(pushnotificationtemplate);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_PushNotificationTemplate");

			data.put(dataObject);

		}catch(ASResourceDataServiceException e){
			throw new ASResourceDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this PushNotificationTemplate instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this PushNotificationTemplate instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPushNotificationTemplate(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			PushNotificationTemplate pushnotificationtemplate = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PushNotificationTemplateDocument.class);

			try {
				updatePushNotificationTemplate(pushnotificationtemplate);
			}catch(Exception e){
				importPushNotificationTemplate(pushnotificationtemplate);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json PushNotificationTemplate instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this PushNotificationTemplate instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllPushNotificationTemplates(String sourceLanguage, String targetLanguage){
		List<PushNotificationTemplate> allDocumentsSrc = getPushNotificationTemplates();
		List<PushNotificationTemplate> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (PushNotificationTemplate document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updatePushNotificationTemplates(allDocuments);
	}

	@Override
	public List<Image> getImages(){
		List<Image> images = new ArrayList<>();
		images.addAll(_getModuleASResourceData().getImages());
		return images;
	}

	@Override
	public List<Image> getImages(SortType sortType){
		return StaticQuickSorter.sort(getImages(), sortType);
	}

	/**
	 * Returns the Image objects with the specified ids.
	 */
	public List<Image> getImages(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Image> all = getImages();
		List<Image> ret = new ArrayList<>();
		for (Image image : all){
			if(ids.contains(image.getId())){
				ret.add(image);
			}
		}
		return ret;
	}

	/**
	 * Returns the Image objects with the specified ids, sorted by given sorttype.
	 */
	public List<Image> getImages(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getImages(ids), sortType);
	}

	@Override
	public void deleteImage(Image image){
		deleteImage(image.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(image);
		}
	}

	@Override
	public void deleteImage(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		Image varValue = hasServiceListeners()?module.getImage(id):null;
		module.deleteImage(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteImages(List<Image> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (Image image : list){
			module.deleteImage(image.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Image getImage(String id){
		return _getModuleASResourceData().getImage(id);
	}

	@Override
	public Image importImage(Image image){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importImage((ImageDocument)image);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(image);
		}
		return image;
	}

	@Override
	public List<Image> importImages(List<Image> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<Image> ret = new ArrayList<>();
		for (Image image : list){
			Image imported = module.importImage((ImageDocument)image);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Image image : ret)
				fireObjectImportedEvent(image);
		}
		return ret;
	}

	@Override
	public Image createImage(Image image){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createImage((ImageDocument)image);
		updateModule(module);
		fireObjectCreatedEvent(image);
		return image;
	}

	@Override
	/**
	 * Creates multiple new Image objects.
	 * Returns the created versions.
	 */
	public List<Image> createImages(List<Image> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<Image> ret = new ArrayList<>();
		for (Image image : list){
			Image created = module.createImage((ImageDocument)image);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Image image : ret)
				fireObjectCreatedEvent(image);
		}
		return ret;
	}

	@Override
	public Image updateImage(Image image){
		Image oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getImage(image.getId());
		module.updateImage((ImageDocument)image);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, image);
		}
		return image;
	}

	@Override
	public List<Image> updateImages(List<Image> list){
		List<Image> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (Image image : list){
			if (oldList!=null)
				oldList.add(module.getImage(image.getId()));
			module.updateImage((ImageDocument)image);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Image> getImagesByProperty(String propertyName, Object value){
		List<Image> allImages = getImages();
		List<Image> ret = new ArrayList<>();
		for (int i=0; i<allImages.size(); i++){
			Image image = allImages.get(i);
			try{
				Property property = ((ImageDocument)image).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(image);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(image);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(image);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Image> getImagesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getImagesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Images
	 */
	public QueryResult executeQueryOnImages(DocumentQuery query){
		List<Image> allImages = getImages();
		QueryResult result = new QueryResult();
		for (int i=0; i<allImages.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allImages.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Image objects, where property matches.
	 */
	public List<Image> getImagesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Image> ret = new ArrayList<>();
		List<Image> src = getImages();
		for ( Image image : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(image.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(image);
		}
		return ret;
	}

	/**
	 * Returns all Image objects, where property matches, sorted
	 */
	public List<Image> getImagesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getImagesByProperty(property), sortType);
	}

	/**
	 * Returns Image objects count.
	 */
	public int getImagesCount() {
		return _getModuleASResourceData().getImages().size();
	}

	/**
	 * Returns Image objects segment.
	 */
	public List<Image> getImages(Segment aSegment) {
		return Slicer.slice(aSegment, getImages()).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Image> ret = new ArrayList<>();
		List<Image> src = getImages();
		for (Image image : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(image.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(image);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Image objects segment, where property matched, sorted.
	 */
	public List<Image> getImagesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getImagesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchImage(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Image" + id))
			return;

		try {
			final ImageDocument image = _getModuleASResourceData().getImage(id);
			addedDocuments.add("Image" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(image);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_Image");

			data.put(dataObject);

			File imageFile = FileStorage.getFile(image.getImage());
			Client client = JerseyClientUtil.getClientInstance();
			for (String domain :DocumentTransferConfig.getInstance().getDomains()) {
				final FileDataBodyPart filePart = new FileDataBodyPart("file", imageFile);
				FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
				final FormDataMultiPart multipart = (FormDataMultiPart) formDataMultiPart.bodyPart(filePart);
				final WebTarget target = client.target(domain + "/api/asgimage/upload");
				final Response response = target.request().post(Entity.entity(multipart, multipart.getMediaType()));
				String responseResult = response.readEntity(String.class);
				log.info(responseResult);
				formDataMultiPart.close();
				multipart.close();
			}
		}catch(FileNotFoundException e){
			throw new ASResourceDataServiceException ("Problem with getting image file for Image" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this Image instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this Image instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredImage(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			Image image = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ImageDocument.class);

			try {
				updateImage(image);
			}catch(Exception e){
				importImage(image);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json Image instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this Image instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllImages(String sourceLanguage, String targetLanguage){
		List<Image> allDocumentsSrc = getImages();
		List<Image> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (Image document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateImages(allDocuments);
	}

	@Override
	public List<FileLink> getFileLinks(){
		List<FileLink> filelinks = new ArrayList<>();
		filelinks.addAll(_getModuleASResourceData().getFileLinks());
		return filelinks;
	}

	@Override
	public List<FileLink> getFileLinks(SortType sortType){
		return StaticQuickSorter.sort(getFileLinks(), sortType);
	}

	/**
	 * Returns the FileLink objects with the specified ids.
	 */
	public List<FileLink> getFileLinks(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<FileLink> all = getFileLinks();
		List<FileLink> ret = new ArrayList<>();
		for (FileLink filelink : all){
			if(ids.contains(filelink.getId())){
				ret.add(filelink);
			}
		}
		return ret;
	}

	/**
	 * Returns the FileLink objects with the specified ids, sorted by given sorttype.
	 */
	public List<FileLink> getFileLinks(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getFileLinks(ids), sortType);
	}

	@Override
	public void deleteFileLink(FileLink filelink){
		deleteFileLink(filelink.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(filelink);
		}
	}

	@Override
	public void deleteFileLink(String id){
		ModuleASResourceData module = _getModuleASResourceData();
		FileLink varValue = hasServiceListeners()?module.getFileLink(id):null;
		module.deleteFileLink(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteFileLinks(List<FileLink> list){
		ModuleASResourceData module = _getModuleASResourceData();
		for (FileLink filelink : list){
			module.deleteFileLink(filelink.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public FileLink getFileLink(String id){
		return _getModuleASResourceData().getFileLink(id);
	}

	@Override
	public FileLink importFileLink(FileLink filelink){
		ModuleASResourceData module = _getModuleASResourceData();
		module.importFileLink((FileLinkDocument)filelink);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(filelink);
		}
		return filelink;
	}

	@Override
	public List<FileLink> importFileLinks(List<FileLink> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<FileLink> ret = new ArrayList<>();
		for (FileLink filelink : list){
			FileLink imported = module.importFileLink((FileLinkDocument)filelink);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (FileLink filelink : ret)
				fireObjectImportedEvent(filelink);
		}
		return ret;
	}

	@Override
	public FileLink createFileLink(FileLink filelink){
		ModuleASResourceData module = _getModuleASResourceData();
		module.createFileLink((FileLinkDocument)filelink);
		updateModule(module);
		fireObjectCreatedEvent(filelink);
		return filelink;
	}

	@Override
	/**
	 * Creates multiple new FileLink objects.
	 * Returns the created versions.
	 */
	public List<FileLink> createFileLinks(List<FileLink> list){
		ModuleASResourceData module = _getModuleASResourceData();
		List<FileLink> ret = new ArrayList<>();
		for (FileLink filelink : list){
			FileLink created = module.createFileLink((FileLinkDocument)filelink);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (FileLink filelink : ret)
				fireObjectCreatedEvent(filelink);
		}
		return ret;
	}

	@Override
	public FileLink updateFileLink(FileLink filelink){
		FileLink oldVersion = null;
		ModuleASResourceData module = _getModuleASResourceData();
		if (hasServiceListeners())
			oldVersion = module.getFileLink(filelink.getId());
		module.updateFileLink((FileLinkDocument)filelink);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, filelink);
		}
		return filelink;
	}

	@Override
	public List<FileLink> updateFileLinks(List<FileLink> list){
		List<FileLink> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASResourceData module = _getModuleASResourceData();
		for (FileLink filelink : list){
			if (oldList!=null)
				oldList.add(module.getFileLink(filelink.getId()));
			module.updateFileLink((FileLinkDocument)filelink);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<FileLink> getFileLinksByProperty(String propertyName, Object value){
		List<FileLink> allFileLinks = getFileLinks();
		List<FileLink> ret = new ArrayList<>();
		for (int i=0; i<allFileLinks.size(); i++){
			FileLink filelink = allFileLinks.get(i);
			try{
				Property property = ((FileLinkDocument)filelink).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(filelink);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(filelink);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(filelink);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<FileLink> getFileLinksByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getFileLinksByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on FileLinks
	 */
	public QueryResult executeQueryOnFileLinks(DocumentQuery query){
		List<FileLink> allFileLinks = getFileLinks();
		QueryResult result = new QueryResult();
		for (int i=0; i<allFileLinks.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allFileLinks.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all FileLink objects, where property matches.
	 */
	public List<FileLink> getFileLinksByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<FileLink> ret = new ArrayList<>();
		List<FileLink> src = getFileLinks();
		for ( FileLink filelink : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(filelink.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(filelink);
		}
		return ret;
	}

	/**
	 * Returns all FileLink objects, where property matches, sorted
	 */
	public List<FileLink> getFileLinksByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getFileLinksByProperty(property), sortType);
	}

	/**
	 * Returns FileLink objects count.
	 */
	public int getFileLinksCount() {
		return _getModuleASResourceData().getFileLinks().size();
	}

	/**
	 * Returns FileLink objects segment.
	 */
	public List<FileLink> getFileLinks(Segment aSegment) {
		return Slicer.slice(aSegment, getFileLinks()).getSliceData();
	}

	/**
	 * Returns FileLink objects segment, where property matched.
	 */
	public List<FileLink> getFileLinksByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<FileLink> ret = new ArrayList<>();
		List<FileLink> src = getFileLinks();
		for (FileLink filelink : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(filelink.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(filelink);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns FileLink objects segment, where property matched, sorted.
	 */
	public List<FileLink> getFileLinksByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getFileLinksByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchFileLink(final String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("FileLink" + id))
			return;

		try {
			final FileLinkDocument filelink = _getModuleASResourceData().getFileLink(id);
			addedDocuments.add("FileLink" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(filelink);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASResourceData");
			dataObject.put("document", "ASResourceData_FileLink");

			data.put(dataObject);

			File imageFile = FileStorage.getFile(filelink.getFile());
			Client client = JerseyClientUtil.getClientInstance();
			for (String domain :DocumentTransferConfig.getInstance().getDomains()) {
				final FileDataBodyPart filePart = new FileDataBodyPart("file", imageFile);
				FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
				final FormDataMultiPart multipart = (FormDataMultiPart) formDataMultiPart.bodyPart(filePart);
				final WebTarget target = client.target(domain + "/api/asgimage/upload");
				final Response response = target.request().post(Entity.entity(multipart, multipart.getMediaType()));
				String responseResult = response.readEntity(String.class);
				log.info(responseResult);
				formDataMultiPart.close();
				multipart.close();
			}
		}catch(FileNotFoundException e){
			throw new ASResourceDataServiceException ("Problem with getting image file for FileLink" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this FileLink instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASResourceDataServiceException ("Problem with fetching data for this FileLink instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredFileLink(final JSONObject data) throws ASResourceDataServiceException {
		try {
			String objectData = data.getString("object");
			FileLink filelink = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), FileLinkDocument.class);

			try {
				updateFileLink(filelink);
			}catch(Exception e){
				importFileLink(filelink);
			}
		}catch(JSONException e){
			throw new ASResourceDataServiceException("Problem with getting data from json FileLink instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASResourceDataServiceException("Problem with parsing data for this FileLink instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASResourceDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASRESOURCEDATA_TEXTRESOURCE:
				saveTransferredTextResource(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_LOCALIZATIONBUNDLE:
				saveTransferredLocalizationBundle(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_MAILTEMPLATE:
				saveTransferredMailTemplate(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_PDFTEMPLATE:
				saveTransferredPdfTemplate(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_PUSHNOTIFICATIONTEMPLATE:
				saveTransferredPushNotificationTemplate(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_IMAGE:
				saveTransferredImage(data);
				break;
			case DOCUMENT_ASRESOURCEDATA_FILELINK:
				saveTransferredFileLink(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASResourceDataServiceException("No such document");
		}
	}

	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){
		copyMultilingualAttributesInAllTextResources(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllLocalizationBundles(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllMailTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllPdfTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllPushNotificationTemplates(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllImages(sourceLanguage, targetLanguage);
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnTextResources(query).getEntries());
		ret.add(executeQueryOnLocalizationBundles(query).getEntries());
		ret.add(executeQueryOnMailTemplates(query).getEntries());
		ret.add(executeQueryOnPdfTemplates(query).getEntries());
		ret.add(executeQueryOnPushNotificationTemplates(query).getEntries());
		ret.add(executeQueryOnImages(query).getEntries());
		ret.add(executeQueryOnFileLinks(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportTextResourcesToXML(){
		XMLNode ret = new XMLNode("TextResources");
		List<TextResource> list = getTextResources();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportTextResourcesToXML(List<TextResource> list){
		XMLNode ret = new XMLNode("TextResources");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportTextResourcesToXML(String[] languages){
		XMLNode ret = new XMLNode("TextResources");
		List<TextResource> list = getTextResources();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportTextResourcesToXML(String[] languages, List<TextResource> list){
		XMLNode ret = new XMLNode("TextResources");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (TextResource object : list)
			ret.addChildNode(TextResourceXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportLocalizationBundlesToXML(){
		XMLNode ret = new XMLNode("LocalizationBundles");
		List<LocalizationBundle> list = getLocalizationBundles();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportLocalizationBundlesToXML(List<LocalizationBundle> list){
		XMLNode ret = new XMLNode("LocalizationBundles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportLocalizationBundlesToXML(String[] languages){
		XMLNode ret = new XMLNode("LocalizationBundles");
		List<LocalizationBundle> list = getLocalizationBundles();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportLocalizationBundlesToXML(String[] languages, List<LocalizationBundle> list){
		XMLNode ret = new XMLNode("LocalizationBundles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (LocalizationBundle object : list)
			ret.addChildNode(LocalizationBundleXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportMailTemplatesToXML(){
		XMLNode ret = new XMLNode("MailTemplates");
		List<MailTemplate> list = getMailTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportMailTemplatesToXML(List<MailTemplate> list){
		XMLNode ret = new XMLNode("MailTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportMailTemplatesToXML(String[] languages){
		XMLNode ret = new XMLNode("MailTemplates");
		List<MailTemplate> list = getMailTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportMailTemplatesToXML(String[] languages, List<MailTemplate> list){
		XMLNode ret = new XMLNode("MailTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (MailTemplate object : list)
			ret.addChildNode(MailTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPdfTemplatesToXML(){
		XMLNode ret = new XMLNode("PdfTemplates");
		List<PdfTemplate> list = getPdfTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPdfTemplatesToXML(List<PdfTemplate> list){
		XMLNode ret = new XMLNode("PdfTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPdfTemplatesToXML(String[] languages){
		XMLNode ret = new XMLNode("PdfTemplates");
		List<PdfTemplate> list = getPdfTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPdfTemplatesToXML(String[] languages, List<PdfTemplate> list){
		XMLNode ret = new XMLNode("PdfTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PdfTemplate object : list)
			ret.addChildNode(PdfTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPushNotificationTemplatesToXML(){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		List<PushNotificationTemplate> list = getPushNotificationTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPushNotificationTemplatesToXML(List<PushNotificationTemplate> list){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPushNotificationTemplatesToXML(String[] languages){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		List<PushNotificationTemplate> list = getPushNotificationTemplates();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPushNotificationTemplatesToXML(String[] languages, List<PushNotificationTemplate> list){
		XMLNode ret = new XMLNode("PushNotificationTemplates");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (PushNotificationTemplate object : list)
			ret.addChildNode(PushNotificationTemplateXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportImagesToXML(){
		XMLNode ret = new XMLNode("Images");
		List<Image> list = getImages();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportImagesToXML(List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportImagesToXML(String[] languages){
		XMLNode ret = new XMLNode("Images");
		List<Image> list = getImages();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportImagesToXML(String[] languages, List<Image> list){
		XMLNode ret = new XMLNode("Images");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Image object : list)
			ret.addChildNode(ImageXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportFileLinksToXML(){
		XMLNode ret = new XMLNode("FileLinks");
		List<FileLink> list = getFileLinks();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportFileLinksToXML(List<FileLink> list){
		XMLNode ret = new XMLNode("FileLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportFileLinksToXML(String[] languages){
		XMLNode ret = new XMLNode("FileLinks");
		List<FileLink> list = getFileLinks();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportFileLinksToXML(String[] languages, List<FileLink> list){
		XMLNode ret = new XMLNode("FileLinks");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (FileLink object : list)
			ret.addChildNode(FileLinkXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASResourceData");

		ret.addChildNode(exportTextResourcesToXML());
		ret.addChildNode(exportLocalizationBundlesToXML());
		ret.addChildNode(exportMailTemplatesToXML());
		ret.addChildNode(exportPdfTemplatesToXML());
		ret.addChildNode(exportPushNotificationTemplatesToXML());
		ret.addChildNode(exportImagesToXML());
		ret.addChildNode(exportFileLinksToXML());

		return ret;
	}
	public XMLNode exportToXML(String[] languages){
		XMLNode ret = new XMLNode("ASResourceData");

		ret.addChildNode(exportTextResourcesToXML(languages));
		ret.addChildNode(exportLocalizationBundlesToXML(languages));
		ret.addChildNode(exportMailTemplatesToXML(languages));
		ret.addChildNode(exportPdfTemplatesToXML(languages));
		ret.addChildNode(exportPushNotificationTemplatesToXML(languages));
		ret.addChildNode(exportImagesToXML(languages));
		ret.addChildNode(exportFileLinksToXML(languages));

		return ret;
	}
}
