/**
 ********************************************************************************
 *** IASLayoutDataService.java                                                ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.aslayoutdata.data.PageStyle;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASLayoutDataService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all PageStyles objects stored.
	 */
	List<PageStyle> getPageStyles() throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyles objects sorted by given sortType.
	 */
	List<PageStyle> getPageStyles(SortType sortType) throws ASLayoutDataServiceException;

	/**
	 * Deletes a PageStyle object by id.
	 */
	void deletePageStyle(String id) throws ASLayoutDataServiceException;

	/**
	 * Deletes a PageStyle object.
	 */
	void deletePageStyle(PageStyle pagestyle) throws ASLayoutDataServiceException;

	/**
	 * Deletes multiple PageStyle object.
	 */
	void deletePageStyles(List<PageStyle> list) throws ASLayoutDataServiceException;

	/**
	 * Returns the PageStyle object with the specified id.
	 */
	PageStyle getPageStyle(String id) throws ASLayoutDataServiceException;

	/**
	 * Imports a new PageStyle object.
	 * Returns the created version.
	 */
	PageStyle importPageStyle(PageStyle pagestyle) throws ASLayoutDataServiceException;

	/**
	 * Imports multiple new  PageStyle object.
	 * Returns the created versions.
	 */
	List<PageStyle> importPageStyles(List<PageStyle> list) throws ASLayoutDataServiceException;

	/**
	 * Creates a new PageStyle object.
	 * Returns the created version.
	 */
	PageStyle createPageStyle(PageStyle pagestyle) throws ASLayoutDataServiceException;

	/**
	 * Creates multiple new PageStyle objects.
	 * Returns the created versions.
	 */
	List<PageStyle> createPageStyles(List<PageStyle> list) throws ASLayoutDataServiceException;

	/**
	 * Updates a PageStyle object.
	 * Returns the updated version.
	 */
	PageStyle updatePageStyle(PageStyle pagestyle) throws ASLayoutDataServiceException;

	/**
	 * Updates multiple PageStyle objects.
	 * Returns the updated versions.
	 */
	List<PageStyle> updatePageStyles(List<PageStyle> list) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyle objects, where property with given name equals object.
	 */
	List<PageStyle> getPageStylesByProperty(String propertyName, Object value) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyle objects, where property with given name equals object, sorted.
	 */
	List<PageStyle> getPageStylesByProperty(String propertyName, Object value, SortType sortType) throws ASLayoutDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnPageStyles(DocumentQuery query) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyle objects, where property matches.
	 */
	List<PageStyle> getPageStylesByProperty(QueryProperty... property) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyle objects, where property matches, sorted.
	 */
	List<PageStyle> getPageStylesByProperty(SortType sortType, QueryProperty... property) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageStyles count.
	 */
	int getPageStylesCount() throws ASLayoutDataServiceException;

	/**
	 * Returns PageStyles objects segment.
	 */
	List<PageStyle> getPageStyles(Segment aSegment) throws ASLayoutDataServiceException;

	/**
	 * Returns PageStyle objects segment, where property matches.
	 */
	List<PageStyle> getPageStylesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASLayoutDataServiceException;

	/**
	 * Returns PageStyle objects segment, where property matches, sorted.
	 */
	List<PageStyle> getPageStylesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASLayoutDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportPageStylesToXML(List<PageStyle> listPageStyles)  throws ASLayoutDataServiceException;

	/**
	 * Create json object list dependencies for this PageStyle document.
	 */
	void fetchPageStyle(String id, Set<String> addedDocuments, JSONArray data) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayouts objects stored.
	 */
	List<PageLayout> getPageLayouts() throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayouts objects sorted by given sortType.
	 */
	List<PageLayout> getPageLayouts(SortType sortType) throws ASLayoutDataServiceException;

	/**
	 * Deletes a PageLayout object by id.
	 */
	void deletePageLayout(String id) throws ASLayoutDataServiceException;

	/**
	 * Deletes a PageLayout object.
	 */
	void deletePageLayout(PageLayout pagelayout) throws ASLayoutDataServiceException;

	/**
	 * Deletes multiple PageLayout object.
	 */
	void deletePageLayouts(List<PageLayout> list) throws ASLayoutDataServiceException;

	/**
	 * Returns the PageLayout object with the specified id.
	 */
	PageLayout getPageLayout(String id) throws ASLayoutDataServiceException;

	/**
	 * Imports a new PageLayout object.
	 * Returns the created version.
	 */
	PageLayout importPageLayout(PageLayout pagelayout) throws ASLayoutDataServiceException;

	/**
	 * Imports multiple new  PageLayout object.
	 * Returns the created versions.
	 */
	List<PageLayout> importPageLayouts(List<PageLayout> list) throws ASLayoutDataServiceException;

	/**
	 * Creates a new PageLayout object.
	 * Returns the created version.
	 */
	PageLayout createPageLayout(PageLayout pagelayout) throws ASLayoutDataServiceException;

	/**
	 * Creates multiple new PageLayout objects.
	 * Returns the created versions.
	 */
	List<PageLayout> createPageLayouts(List<PageLayout> list) throws ASLayoutDataServiceException;

	/**
	 * Updates a PageLayout object.
	 * Returns the updated version.
	 */
	PageLayout updatePageLayout(PageLayout pagelayout) throws ASLayoutDataServiceException;

	/**
	 * Updates multiple PageLayout objects.
	 * Returns the updated versions.
	 */
	List<PageLayout> updatePageLayouts(List<PageLayout> list) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayout objects, where property with given name equals object.
	 */
	List<PageLayout> getPageLayoutsByProperty(String propertyName, Object value) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayout objects, where property with given name equals object, sorted.
	 */
	List<PageLayout> getPageLayoutsByProperty(String propertyName, Object value, SortType sortType) throws ASLayoutDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnPageLayouts(DocumentQuery query) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayout objects, where property matches.
	 */
	List<PageLayout> getPageLayoutsByProperty(QueryProperty... property) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayout objects, where property matches, sorted.
	 */
	List<PageLayout> getPageLayoutsByProperty(SortType sortType, QueryProperty... property) throws ASLayoutDataServiceException;

	/**
	 * Returns all PageLayouts count.
	 */
	int getPageLayoutsCount() throws ASLayoutDataServiceException;

	/**
	 * Returns PageLayouts objects segment.
	 */
	List<PageLayout> getPageLayouts(Segment aSegment) throws ASLayoutDataServiceException;

	/**
	 * Returns PageLayout objects segment, where property matches.
	 */
	List<PageLayout> getPageLayoutsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASLayoutDataServiceException;

	/**
	 * Returns PageLayout objects segment, where property matches, sorted.
	 */
	List<PageLayout> getPageLayoutsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASLayoutDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportPageLayoutsToXML(List<PageLayout> listPageLayouts)  throws ASLayoutDataServiceException;

	/**
	 * Create json object list dependencies for this PageLayout document.
	 */
	void fetchPageLayout(String id, Set<String> addedDocuments, JSONArray data) throws ASLayoutDataServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASLayoutDataServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASLayoutDataServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASLayoutDataServiceException;

}
