/**
 ********************************************************************************
 *** ExportGenericBoxHandlerDefsAction.java                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDef;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDefSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asgenericdata.bean.GenericBoxHandlerDefListItemBeanSortType;

public class ExportGenericBoxHandlerDefsAction extends BaseGenericBoxHandlerDefAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"GenericBoxHandlerDef";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"GenericBoxHandlerDef";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportGenericBoxHandlerDefsAction.class);
	private Sorter<GenericBoxHandlerDef> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportGenericBoxHandlerDefsAction(){
		super();
		sorter = new QuickSorter<GenericBoxHandlerDef>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = GenericBoxHandlerDefListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = GenericBoxHandlerDefListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = GenericBoxHandlerDefListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				GenericBoxHandlerDefListItemBeanSortType.ASC : GenericBoxHandlerDefListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		GenericBoxHandlerDefListItemBeanSortType sessionSortType  = null;
		GenericBoxHandlerDefSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new GenericBoxHandlerDefListItemBeanSortType(sortMethod, sortOrder);
			sortType = new GenericBoxHandlerDefSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (GenericBoxHandlerDefListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new GenericBoxHandlerDefSortType(sortMethod, sortOrder) : new GenericBoxHandlerDefSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new GenericBoxHandlerDefListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<GenericBoxHandlerDef> _unfiltered_genericboxhandlerdefs = getASGenericDataService().getGenericBoxHandlerDefs();
		List<GenericBoxHandlerDef> genericboxhandlerdefs = new ArrayList<GenericBoxHandlerDef>();
		for (GenericBoxHandlerDef element : _unfiltered_genericboxhandlerdefs ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				genericboxhandlerdefs.add(element);
		}
		genericboxhandlerdefs = sorter.sort(genericboxhandlerdefs, sortType);

		addBeanToRequest(req, "genericboxhandlerdefs", genericboxhandlerdefs);

		XMLNode beans = getASGenericDataService().exportGenericBoxHandlerDefsToXML(genericboxhandlerdefs);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "genericboxhandlerdefsXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "genericboxhandlerdefsCSV", genericboxhandlerdefs);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
