/**
 ********************************************************************************
 *** AdminapiXMLImporter.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.service;

import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.jdom2.Element;
import org.jdom2.Attribute;
import org.jdom2.Document;
import java.io.StringReader;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLTree;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLWriter;
import net.anotheria.util.Date;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.anosite.gen.asgenericdata.service.ASGenericDataServiceFactory;
import net.anotheria.anosite.gen.ascustomdata.service.ASCustomDataServiceFactory;
import net.anotheria.anosite.gen.asfederateddata.service.ASFederatedDataServiceFactory;
import net.anotheria.anosite.gen.images.service.ImagesServiceFactory;
import net.anotheria.anosite.gen.aslayoutdata.service.ASLayoutDataServiceFactory;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceFactory;
import net.anotheria.anosite.gen.assiteconfig.service.ASSiteConfigServiceFactory;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceFactory;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceFactory;
import net.anotheria.anosite.gen.asgenericaction.service.ASGenericActionServiceFactory;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceFactory;
import net.anotheria.anosite.gen.asaction.service.ASActionServiceFactory;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceFactory;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceFactory;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.AnoAccessApplicationDataServiceFactory;
import net.anotheria.anosite.gen.asfeature.service.ASFeatureServiceFactory;
import net.anotheria.anosite.gen.asexperiment.service.ASExperimentServiceFactory;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceFactory;

public class AdminapiXMLImporter{



	public AdminapiXMLImporter(){
		AnoDocConfigurator.configure();
	}

	public static Document parseDocument(String content) throws JDOMException, IOException{
		SAXBuilder reader = new SAXBuilder();;
		reader.setValidation(false);
		Document doc = reader.build(new StringReader(content));
		return doc;
	}

	/**
	 * Create an XML Document (ano-util) with data from all modules.
	 */
	public XMLTree createCompleteXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
		nodes.add(ASGenericDataServiceFactory.createASGenericDataService().exportToXML());
		nodes.add(ASCustomDataServiceFactory.createASCustomDataService().exportToXML());
		nodes.add(ASFederatedDataServiceFactory.createASFederatedDataService().exportToXML());
		nodes.add(ImagesServiceFactory.createImagesService().exportToXML());
		nodes.add(ASLayoutDataServiceFactory.createASLayoutDataService().exportToXML());
		nodes.add(ASSiteDataServiceFactory.createASSiteDataService().exportToXML());
		nodes.add(ASSiteConfigServiceFactory.createASSiteConfigService().exportToXML());
		nodes.add(ASWebDataServiceFactory.createASWebDataService().exportToXML());
		nodes.add(ASResourceDataServiceFactory.createASResourceDataService().exportToXML());
		nodes.add(ASGenericActionServiceFactory.createASGenericActionService().exportToXML());
		nodes.add(ASCustomActionServiceFactory.createASCustomActionService().exportToXML());
		nodes.add(ASActionServiceFactory.createASActionService().exportToXML());
		nodes.add(ASWizardDataServiceFactory.createASWizardDataService().exportToXML());
		nodes.add(ASUserDataServiceFactory.createASUserDataService().exportToXML());
		nodes.add(AnoAccessConfigurationServiceFactory.createAnoAccessConfigurationService().exportToXML());
		nodes.add(AnoAccessApplicationDataServiceFactory.createAnoAccessApplicationDataService().exportToXML());
		nodes.add(ASFeatureServiceFactory.createASFeatureService().exportToXML());
		nodes.add(ASExperimentServiceFactory.createASExperimentService().exportToXML());
		nodes.add(ASBrandServiceFactory.createASBrandService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write XML data from all modules into given stream.
	 */
	public void writeCompleteXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createCompleteXMLExport(), target);
	}

	/**
	 * Write XML data from all modules into given file.
	 */
	public void writeCompleteXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createCompleteXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASGenericData data for export.
	 */
	public XMLTree createASGenericDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASGenericDataServiceFactory.createASGenericDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASGenericData as XML into given stream.
	 */
	public void writeASGenericDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASGenericDataXMLExport(), target);
	}

	/**
	 * Write ASGenericData as XML into given file.
	 */
	public void writeASGenericDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASGenericDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASCustomData data for export.
	 */
	public XMLTree createASCustomDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASCustomDataServiceFactory.createASCustomDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASCustomData as XML into given stream.
	 */
	public void writeASCustomDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASCustomDataXMLExport(), target);
	}

	/**
	 * Write ASCustomData as XML into given file.
	 */
	public void writeASCustomDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASCustomDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASFederatedData data for export.
	 */
	public XMLTree createASFederatedDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASFederatedDataServiceFactory.createASFederatedDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASFederatedData as XML into given stream.
	 */
	public void writeASFederatedDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASFederatedDataXMLExport(), target);
	}

	/**
	 * Write ASFederatedData as XML into given file.
	 */
	public void writeASFederatedDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASFederatedDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from Images data for export.
	 */
	public XMLTree createImagesXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ImagesServiceFactory.createImagesService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write Images as XML into given stream.
	 */
	public void writeImagesXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createImagesXMLExport(), target);
	}

	/**
	 * Write Images as XML into given file.
	 */
	public void writeImagesXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createImagesXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASLayoutData data for export.
	 */
	public XMLTree createASLayoutDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASLayoutDataServiceFactory.createASLayoutDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASLayoutData as XML into given stream.
	 */
	public void writeASLayoutDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASLayoutDataXMLExport(), target);
	}

	/**
	 * Write ASLayoutData as XML into given file.
	 */
	public void writeASLayoutDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASLayoutDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASSiteData data for export.
	 */
	public XMLTree createASSiteDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASSiteDataServiceFactory.createASSiteDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASSiteData as XML into given stream.
	 */
	public void writeASSiteDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASSiteDataXMLExport(), target);
	}

	/**
	 * Write ASSiteData as XML into given file.
	 */
	public void writeASSiteDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASSiteDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASSiteConfig data for export.
	 */
	public XMLTree createASSiteConfigXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASSiteConfigServiceFactory.createASSiteConfigService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASSiteConfig as XML into given stream.
	 */
	public void writeASSiteConfigXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASSiteConfigXMLExport(), target);
	}

	/**
	 * Write ASSiteConfig as XML into given file.
	 */
	public void writeASSiteConfigXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASSiteConfigXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASWebData data for export.
	 */
	public XMLTree createASWebDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASWebDataServiceFactory.createASWebDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASWebData as XML into given stream.
	 */
	public void writeASWebDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASWebDataXMLExport(), target);
	}

	/**
	 * Write ASWebData as XML into given file.
	 */
	public void writeASWebDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASWebDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASResourceData data for export.
	 */
	public XMLTree createASResourceDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASResourceDataServiceFactory.createASResourceDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASResourceData as XML into given stream.
	 */
	public void writeASResourceDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASResourceDataXMLExport(), target);
	}

	/**
	 * Write ASResourceData as XML into given file.
	 */
	public void writeASResourceDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASResourceDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASGenericAction data for export.
	 */
	public XMLTree createASGenericActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASGenericActionServiceFactory.createASGenericActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASGenericAction as XML into given stream.
	 */
	public void writeASGenericActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASGenericActionXMLExport(), target);
	}

	/**
	 * Write ASGenericAction as XML into given file.
	 */
	public void writeASGenericActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASGenericActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASCustomAction data for export.
	 */
	public XMLTree createASCustomActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASCustomActionServiceFactory.createASCustomActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASCustomAction as XML into given stream.
	 */
	public void writeASCustomActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASCustomActionXMLExport(), target);
	}

	/**
	 * Write ASCustomAction as XML into given file.
	 */
	public void writeASCustomActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASCustomActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASAction data for export.
	 */
	public XMLTree createASActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASActionServiceFactory.createASActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASAction as XML into given stream.
	 */
	public void writeASActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASActionXMLExport(), target);
	}

	/**
	 * Write ASAction as XML into given file.
	 */
	public void writeASActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASWizardData data for export.
	 */
	public XMLTree createASWizardDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASWizardDataServiceFactory.createASWizardDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASWizardData as XML into given stream.
	 */
	public void writeASWizardDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASWizardDataXMLExport(), target);
	}

	/**
	 * Write ASWizardData as XML into given file.
	 */
	public void writeASWizardDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASWizardDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASUserData data for export.
	 */
	public XMLTree createASUserDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASUserDataServiceFactory.createASUserDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASUserData as XML into given stream.
	 */
	public void writeASUserDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASUserDataXMLExport(), target);
	}

	/**
	 * Write ASUserData as XML into given file.
	 */
	public void writeASUserDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASUserDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from AnoAccessConfiguration data for export.
	 */
	public XMLTree createAnoAccessConfigurationXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(AnoAccessConfigurationServiceFactory.createAnoAccessConfigurationService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write AnoAccessConfiguration as XML into given stream.
	 */
	public void writeAnoAccessConfigurationXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createAnoAccessConfigurationXMLExport(), target);
	}

	/**
	 * Write AnoAccessConfiguration as XML into given file.
	 */
	public void writeAnoAccessConfigurationXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createAnoAccessConfigurationXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from AnoAccessApplicationData data for export.
	 */
	public XMLTree createAnoAccessApplicationDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(AnoAccessApplicationDataServiceFactory.createAnoAccessApplicationDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write AnoAccessApplicationData as XML into given stream.
	 */
	public void writeAnoAccessApplicationDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createAnoAccessApplicationDataXMLExport(), target);
	}

	/**
	 * Write AnoAccessApplicationData as XML into given file.
	 */
	public void writeAnoAccessApplicationDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createAnoAccessApplicationDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASFeature data for export.
	 */
	public XMLTree createASFeatureXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASFeatureServiceFactory.createASFeatureService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASFeature as XML into given stream.
	 */
	public void writeASFeatureXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASFeatureXMLExport(), target);
	}

	/**
	 * Write ASFeature as XML into given file.
	 */
	public void writeASFeatureXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASFeatureXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASExperiment data for export.
	 */
	public XMLTree createASExperimentXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASExperimentServiceFactory.createASExperimentService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASExperiment as XML into given stream.
	 */
	public void writeASExperimentXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASExperimentXMLExport(), target);
	}

	/**
	 * Write ASExperiment as XML into given file.
	 */
	public void writeASExperimentXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASExperimentXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASBrand data for export.
	 */
	public XMLTree createASBrandXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASBrandServiceFactory.createASBrandService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASBrand as XML into given stream.
	 */
	public void writeASBrandXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASBrandXMLExport(), target);
	}

	/**
	 * Write ASBrand as XML into given file.
	 */
	public void writeASBrandXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASBrandXMLExport(), target);
	}

	private void writeToFile(XMLTree tree, File target) throws IOException{
		FileOutputStream fOut = null;
		try{
			fOut = new FileOutputStream(target);
			XMLWriter writer = new XMLWriter();
			OutputStreamWriter oWriter = writer.write(tree, fOut);
			oWriter.close();
		}catch(IOException e){;
			if (fOut!=null){
				try{
					fOut.close();
				}catch(IOException ignored){}
			}
			throw e;
		}
	}

	private XMLTree createExport(List<XMLNode> nodes){
		XMLTree tree = new XMLTree();
		tree.setEncoding("UTF-8");
		XMLNode root = new XMLNode("export");
		root.addAttribute(new XMLAttribute("timestamp", ""+System.currentTimeMillis()));
		root.addAttribute(new XMLAttribute("date", Date.currentDate().toString()));
		tree.setRoot(root);
		root.setChildren(nodes);
		return tree;
	}

	public static void main(String[] a) throws IOException,ASGRuntimeException{
		new AdminapiXMLImporter().writeCompleteXMLExportToFile(new File("adminapi_export.xml"));
	}
}
