/**
 ********************************************************************************
 *** MediaLinkDocument.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class MediaLinkDocument extends AbstractASGDocument implements MediaLink, IComparable{

	public MediaLinkDocument() {
		super("");
	}

	public MediaLinkDocument(String id){
		super(id);
	}

	public MediaLinkDocument(MediaLinkDocument toClone){
		super(toClone);
	}

	MediaLinkDocument(MediaLinkBuilder builder){
		super("");
		setName(builder.name);
		setHref(builder.href);
		setType(builder.type);
		setMedia(builder.media);
		setRel(builder.rel);
		setRev(builder.rev);
		setCharset(builder.charset);
		setHreflang(builder.hreflang);
		setBrowserFiltering(builder.browserFiltering);
		setOnload(builder.onload);
		setGuards(builder.guards);
		setFile(builder.file);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getHref(){
		return getString(PROP_HREF);
	}

	public void setHref(String value){
		setString(PROP_HREF, value);
	}

	public String getType(){
		return getString(PROP_TYPE);
	}

	public void setType(String value){
		setString(PROP_TYPE, value);
	}

	public int getMedia(){
		return getInt(PROP_MEDIA);
	}

	public void setMedia(int value){
		setInt(PROP_MEDIA, value);
	}

	public int getRel(){
		return getInt(PROP_REL);
	}

	public void setRel(int value){
		setInt(PROP_REL, value);
	}

	public int getRev(){
		return getInt(PROP_REV);
	}

	public void setRev(int value){
		setInt(PROP_REV, value);
	}

	public String getCharset(){
		return getString(PROP_CHARSET);
	}

	public void setCharset(String value){
		setString(PROP_CHARSET, value);
	}

	public String getHreflang(){
		return getString(PROP_HREFLANG);
	}

	public void setHreflang(String value){
		setString(PROP_HREFLANG, value);
	}

	public String getBrowserFiltering(){
		return getString(PROP_BROWSER_FILTERING);
	}

	public void setBrowserFiltering(String value){
		setString(PROP_BROWSER_FILTERING, value);
	}

	public String getOnload(){
		return getString(PROP_ONLOAD);
	}

	public void setOnload(String value){
		setString(PROP_ONLOAD, value);
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}

	public String getFile(){
		return getString(LINK_PROP_FILE);
	}

	public void setFile(String value){
		setString(LINK_PROP_FILE, value);
	}


	public String toString(){
		String ret = "MediaLink ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "href: "+getHref();
		ret += ", ";
		ret += "type: "+getType();
		ret += ", ";
		ret += "media: "+getMedia();
		ret += ", ";
		ret += "rel: "+getRel();
		ret += ", ";
		ret += "rev: "+getRev();
		ret += ", ";
		ret += "charset: "+getCharset();
		ret += ", ";
		ret += "hreflang: "+getHreflang();
		ret += ", ";
		ret += "browserFiltering: "+getBrowserFiltering();
		ret += ", ";
		ret += "onload: "+getOnload();
		ret += ", ";
		ret += "guards: "+getGuards();
		return ret;
	}

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method


	public int compareTo(MediaLink comparable){
		return compareTo(comparable, MediaLinkSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		MediaLinkDocument anotherDoc = (MediaLinkDocument) anotherComparable;
		switch(method){
			case MediaLinkSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case MediaLinkSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case MediaLinkSortType.SORT_BY_HREF:
				return BasicComparable.compareString(getHref(), anotherDoc.getHref());
			case MediaLinkSortType.SORT_BY_TYPE:
				return BasicComparable.compareString(getType(), anotherDoc.getType());
			case MediaLinkSortType.SORT_BY_MEDIA:
				return BasicComparable.compareInt(getMedia(), anotherDoc.getMedia());
			case MediaLinkSortType.SORT_BY_REL:
				return BasicComparable.compareInt(getRel(), anotherDoc.getRel());
			case MediaLinkSortType.SORT_BY_REV:
				return BasicComparable.compareInt(getRev(), anotherDoc.getRev());
			case MediaLinkSortType.SORT_BY_CHARSET:
				return BasicComparable.compareString(getCharset(), anotherDoc.getCharset());
			case MediaLinkSortType.SORT_BY_HREFLANG:
				return BasicComparable.compareString(getHreflang(), anotherDoc.getHreflang());
			case MediaLinkSortType.SORT_BY_BROWSERFILTERING:
				return BasicComparable.compareString(getBrowserFiltering(), anotherDoc.getBrowserFiltering());
			case MediaLinkSortType.SORT_BY_ONLOAD:
				return BasicComparable.compareString(getOnload(), anotherDoc.getOnload());
			case MediaLinkSortType.SORT_BY_FILE:
				return BasicComparable.compareString(getFile(), anotherDoc.getFile());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "MediaLink";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getHref());
		footprint.append(getType());
		footprint.append(getMedia());
		footprint.append(getRel());
		footprint.append(getRev());
		footprint.append(getCharset());
		footprint.append(getHreflang());
		footprint.append(getBrowserFiltering());
		footprint.append(getOnload());
		footprint.append(getGuards());
		footprint.append(getFile());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof MediaLinkDocument) && ((MediaLinkDocument)o).getId().equals(getId()));
	}
}
