/**
 ********************************************************************************
 *** ExportPermissionsAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.PermissionListItemBeanSortType;

public class ExportPermissionsAction extends BasePermissionAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Permission";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Permission";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportPermissionsAction.class);
	private Sorter<Permission> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportPermissionsAction(){
		super();
		sorter = new QuickSorter<Permission>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PermissionListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = PermissionListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PermissionListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				PermissionListItemBeanSortType.ASC : PermissionListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		PermissionListItemBeanSortType sessionSortType  = null;
		PermissionSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new PermissionListItemBeanSortType(sortMethod, sortOrder);
			sortType = new PermissionSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (PermissionListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new PermissionSortType(sortMethod, sortOrder) : new PermissionSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new PermissionListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<Permission> _unfiltered_permissions = getAnoAccessConfigurationService().getPermissions();
		List<Permission> permissions = new ArrayList<Permission>();
		for (Permission element : _unfiltered_permissions ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				permissions.add(element);
		}
		permissions = sorter.sort(permissions, sortType);

		addBeanToRequest(req, "permissions", permissions);

		XMLNode beans = getAnoAccessConfigurationService().exportPermissionsToXML(permissions);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "permissionsXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "permissionsCSV", permissions);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
