/**
 ********************************************************************************
 *** EditImageAction.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.bean.EditImageFB;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.asg.data.MultilingualObject;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.util.bean.LinkToMeBean;
import net.anotheria.anosite.gen.assitedata.data.Site;
import net.anotheria.asg.data.LockableObject;

public class EditImageAction extends ShowImagesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditImageFB form = new EditImageFB() ;
		Image image = getASResourceDataService().getImage(id);
		checkImages(image, req);
		if(image instanceof LockableObject && !((LockableObject)image).isLocked() && isAutoLockingEnabled())
			lockImages(image, req);
		form.setId(image.getId());
		form.setName(image.getName());
		form.setTitle(image.getTitle());
		form.setAliasEN(image.getAliasEN());
		form.setAltEN(image.getAltEN());
		form.setImage(image.getImage());
		form.setMultilingualInstanceDisabled(((MultilingualObject)image).isMultilingualDisabledInstance());
		form.setLocked(((LockableObject)image).isLocked());
		form.setLockerId(((LockableObject)image).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)image).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)image).getLockingTime() + getLockingTimeout()));

		addBeanToRequest(req, "objectId" , image.getId());
		addBeanToRequest(req, "EditASResourceDataImageForm" , form);
		addBeanToRequest(req, "objectInfoString" , image.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");
		addBeanToRequest(req, "transfer.label.prefix", "Transfer");

		addFieldExplanations(req, image);


		// Generating back link handling...
		List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(image.getId());
		if (linksToMe.size()>0)
			req.setAttribute("linksToMe", linksToMe);
		return mapping.success();
	}

	private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataSiteHeaderBackground(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASSiteDataSiteSiteLogo(documentId));
		}catch(Exception ignored){
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataSiteHeaderBackground(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Site.LINK_PROP_HEADER_BACKGROUND, documentId);
		// temporarly - replacy with query property
		List<Site> list = getASSiteDataService().getSitesByProperty(p.getName(), p.getValue());
		for (Site doc : list ){
			ret.add(new LinkToMeBean(doc, "headerBackground"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASSiteDataSiteSiteLogo(String documentId) throws net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Site.LINK_PROP_SITE_LOGO, documentId);
		// temporarly - replacy with query property
		List<Site> list = getASSiteDataService().getSitesByProperty(p.getName(), p.getValue());
		for (Site doc : list ){
			ret.add(new LinkToMeBean(doc, "siteLogo"));
		}
		return ret;
	}
}
