/**
 ********************************************************************************
 *** MultiOpDialogFeaturesAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asfeature.data.FeatureFactory;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.bean.EditFeatureFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogFeaturesAction extends BaseFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asfeatureFeatureDelete"))
			return asfeatureFeatureDelete(mapping, req, res);
		if (path.equals("asfeatureFeatureDuplicate"))
			return asfeatureFeatureDuplicate(mapping, req, res);
		if (path.equals("asfeatureFeatureUpdate"))
			return asfeatureFeatureUpdate(mapping, req, res);
		if (path.equals("asfeatureFeatureClose"))
			return asfeatureFeatureClose(mapping, req, res);
		if (path.equals("asfeatureFeatureLock"))
			return asfeatureFeatureLock(mapping, req, res);
		if (path.equals("asfeatureFeatureUnLock"))
			return asfeatureFeatureUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asfeatureFeatureDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Feature featureCurr = getASFeatureService().getFeature(id);
			if (featureCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)featureCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASFeatureService().deleteFeature(id);
		}
		res.sendRedirect("asfeatureFeatureShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asfeatureFeatureDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Feature featureSrc = getASFeatureService().getFeature(id);
		Feature featureDest = FeatureFactory.createFeature(featureSrc);



		Feature featureCreated = getASFeatureService().createFeature(featureDest);
		res.sendRedirect("asfeatureFeatureEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+featureCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asfeatureFeatureUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditFeatureFB form = new EditFeatureFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Feature feature = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		feature = (Feature)getASFeatureService().getFeature(form.getId()).clone();
	}else{
		feature = FeatureFactory.createFeature();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	feature.setName(form.getName());
	feature.setEnabled(form.isEnabled());
	feature.setActiveInProduction(form.isActiveInProduction());
	feature.setObsolete(form.isObsolete());
	// skipped container guards
	feature.setAccessOperation(form.getAccessOperation());
	feature.setDescription(form.getDescription());

	Feature updatedCopy = null;
	if (create){
		updatedCopy = getASFeatureService().createFeature(feature);
	}else{
		canUpdateFeatures(feature, req);
		checkFeatures(feature, req);
		updatedCopy = getASFeatureService().updateFeature(feature);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asfeatureFeatureEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(feature, req);
		res.sendRedirect("asfeatureFeatureShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Feature feature, HttpServletRequest req) throws Exception{
	if(((LockableObject)feature).isLocked())
		unLockFeatures(feature, req, false);
}

public ActionCommand asfeatureFeatureLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Feature featureCurr = id != null && !id.equals("") ? getASFeatureService().getFeature(id) : null;
	if(featureCurr != null && featureCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)featureCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockFeatures(featureCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, featureCurr));
	return null;
}

public ActionCommand asfeatureFeatureUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Feature featureCurr = id != null && !id.equals("") ? getASFeatureService().getFeature(id) : null;
	if(featureCurr != null && featureCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)featureCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockFeatures(featureCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, featureCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Feature item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asfeatureFeatureShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asfeatureFeatureEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asfeatureFeatureShow?ts="+System.currentTimeMillis();
}

public ActionCommand asfeatureFeatureClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Feature featureCurr = id != null && !id.equals("") ? getASFeatureService().getFeature(id) : null;
	if(featureCurr != null && featureCurr instanceof LockableObject && ((LockableObject)featureCurr).isLocked()) 
		unLockFeatures(featureCurr, req, false);
	res.sendRedirect("asfeatureFeatureShow?ts="+System.currentTimeMillis());
	return null;
}

}
