/**
 ********************************************************************************
 *** ShowConstraintsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ConstraintListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ConstraintListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowConstraintsAction extends BaseConstraintAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Constraint";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Constraint";
	private static Logger log = LoggerFactory.getLogger(ShowConstraintsAction.class);
	private Sorter<ConstraintListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowConstraintsAction(){
		sorter = new QuickSorter<ConstraintListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = ConstraintListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = ConstraintListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		ConstraintListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new ConstraintListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (ConstraintListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new ConstraintListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<Constraint> _unfiltered_constraints = getAnoAccessConfigurationService().getConstraints();
		List<Constraint> constraints = new ArrayList<Constraint>();
		for (int i=0; i<_unfiltered_constraints.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_constraints.get(i), "name", filterParameter0));
			if (mayPass)
				constraints.add(_unfiltered_constraints.get(i));
		}
		List<ConstraintListItemBean> beans = new ArrayList<ConstraintListItemBean>(constraints.size());
		for (Constraint constraint : constraints){
			checkConstraints(constraint, req);
			ConstraintListItemBean bean = makeConstraintListItemBean(constraint);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "constraints", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected ConstraintListItemBean makeConstraintListItemBean(Constraint constraint) {
		ConstraintListItemBean bean = new ConstraintListItemBean();
		bean.setPlainId(constraint.getId());
		bean.setIdForSorting(constraint.getId());
		bean.setId(idDecorator.decorate(constraint, "id", "3"));
		bean.setNameForSorting(constraint.getName());
		bean.setName(nameDecorator.decorate(constraint, "name", "null"));
		bean.setClassName(constraint.getClassName());
		bean.setContextInitializers(constraint.getContextInitializers());
		bean.setDescription(constraint.getDescription());
		bean.setLocked(((LockableObject)constraint).isLocked());
		bean.setLockerId(((LockableObject)constraint).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)constraint).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)constraint).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(constraint.getLastUpdateTimestamp()));
		return bean;
	}
}
