/**
 ********************************************************************************
 *** IASFeatureService.java                                                   ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASFeatureService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all Features objects stored.
	 */
	List<Feature> getFeatures() throws ASFeatureServiceException;

	/**
	 * Returns all Features objects sorted by given sortType.
	 */
	List<Feature> getFeatures(SortType sortType) throws ASFeatureServiceException;

	/**
	 * Deletes a Feature object by id.
	 */
	void deleteFeature(String id) throws ASFeatureServiceException;

	/**
	 * Deletes a Feature object.
	 */
	void deleteFeature(Feature feature) throws ASFeatureServiceException;

	/**
	 * Deletes multiple Feature object.
	 */
	void deleteFeatures(List<Feature> list) throws ASFeatureServiceException;

	/**
	 * Returns the Feature object with the specified id.
	 */
	Feature getFeature(String id) throws ASFeatureServiceException;

	/**
	 * Imports a new Feature object.
	 * Returns the created version.
	 */
	Feature importFeature(Feature feature) throws ASFeatureServiceException;

	/**
	 * Imports multiple new  Feature object.
	 * Returns the created versions.
	 */
	List<Feature> importFeatures(List<Feature> list) throws ASFeatureServiceException;

	/**
	 * Creates a new Feature object.
	 * Returns the created version.
	 */
	Feature createFeature(Feature feature) throws ASFeatureServiceException;

	/**
	 * Creates multiple new Feature objects.
	 * Returns the created versions.
	 */
	List<Feature> createFeatures(List<Feature> list) throws ASFeatureServiceException;

	/**
	 * Updates a Feature object.
	 * Returns the updated version.
	 */
	Feature updateFeature(Feature feature) throws ASFeatureServiceException;

	/**
	 * Updates multiple Feature objects.
	 * Returns the updated versions.
	 */
	List<Feature> updateFeatures(List<Feature> list) throws ASFeatureServiceException;

	/**
	 * Returns all Feature objects, where property with given name equals object.
	 */
	List<Feature> getFeaturesByProperty(String propertyName, Object value) throws ASFeatureServiceException;

	/**
	 * Returns all Feature objects, where property with given name equals object, sorted.
	 */
	List<Feature> getFeaturesByProperty(String propertyName, Object value, SortType sortType) throws ASFeatureServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnFeatures(DocumentQuery query) throws ASFeatureServiceException;

	/**
	 * Returns all Feature objects, where property matches.
	 */
	List<Feature> getFeaturesByProperty(QueryProperty... property) throws ASFeatureServiceException;

	/**
	 * Returns all Feature objects, where property matches, sorted.
	 */
	List<Feature> getFeaturesByProperty(SortType sortType, QueryProperty... property) throws ASFeatureServiceException;

	/**
	 * Returns all Features count.
	 */
	int getFeaturesCount() throws ASFeatureServiceException;

	/**
	 * Returns Features objects segment.
	 */
	List<Feature> getFeatures(Segment aSegment) throws ASFeatureServiceException;

	/**
	 * Returns Feature objects segment, where property matches.
	 */
	List<Feature> getFeaturesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASFeatureServiceException;

	/**
	 * Returns Feature objects segment, where property matches, sorted.
	 */
	List<Feature> getFeaturesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASFeatureServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportFeaturesToXML(List<Feature> listFeatures)  throws ASFeatureServiceException;

	/**
	 * Create json object list dependencies for this Feature document.
	 */
	void fetchFeature(String id, Set<String> addedDocuments, JSONArray data) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeatures objects stored.
	 */
	List<BrandFeature> getBrandFeatures() throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeatures objects sorted by given sortType.
	 */
	List<BrandFeature> getBrandFeatures(SortType sortType) throws ASFeatureServiceException;

	/**
	 * Deletes a BrandFeature object by id.
	 */
	void deleteBrandFeature(String id) throws ASFeatureServiceException;

	/**
	 * Deletes a BrandFeature object.
	 */
	void deleteBrandFeature(BrandFeature brandfeature) throws ASFeatureServiceException;

	/**
	 * Deletes multiple BrandFeature object.
	 */
	void deleteBrandFeatures(List<BrandFeature> list) throws ASFeatureServiceException;

	/**
	 * Returns the BrandFeature object with the specified id.
	 */
	BrandFeature getBrandFeature(String id) throws ASFeatureServiceException;

	/**
	 * Imports a new BrandFeature object.
	 * Returns the created version.
	 */
	BrandFeature importBrandFeature(BrandFeature brandfeature) throws ASFeatureServiceException;

	/**
	 * Imports multiple new  BrandFeature object.
	 * Returns the created versions.
	 */
	List<BrandFeature> importBrandFeatures(List<BrandFeature> list) throws ASFeatureServiceException;

	/**
	 * Creates a new BrandFeature object.
	 * Returns the created version.
	 */
	BrandFeature createBrandFeature(BrandFeature brandfeature) throws ASFeatureServiceException;

	/**
	 * Creates multiple new BrandFeature objects.
	 * Returns the created versions.
	 */
	List<BrandFeature> createBrandFeatures(List<BrandFeature> list) throws ASFeatureServiceException;

	/**
	 * Updates a BrandFeature object.
	 * Returns the updated version.
	 */
	BrandFeature updateBrandFeature(BrandFeature brandfeature) throws ASFeatureServiceException;

	/**
	 * Updates multiple BrandFeature objects.
	 * Returns the updated versions.
	 */
	List<BrandFeature> updateBrandFeatures(List<BrandFeature> list) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeature objects, where property with given name equals object.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(String propertyName, Object value) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeature objects, where property with given name equals object, sorted.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(String propertyName, Object value, SortType sortType) throws ASFeatureServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnBrandFeatures(DocumentQuery query) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeature objects, where property matches.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(QueryProperty... property) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeature objects, where property matches, sorted.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(SortType sortType, QueryProperty... property) throws ASFeatureServiceException;

	/**
	 * Returns all BrandFeatures count.
	 */
	int getBrandFeaturesCount() throws ASFeatureServiceException;

	/**
	 * Returns BrandFeatures objects segment.
	 */
	List<BrandFeature> getBrandFeatures(Segment aSegment) throws ASFeatureServiceException;

	/**
	 * Returns BrandFeature objects segment, where property matches.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASFeatureServiceException;

	/**
	 * Returns BrandFeature objects segment, where property matches, sorted.
	 */
	List<BrandFeature> getBrandFeaturesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASFeatureServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportBrandFeaturesToXML(List<BrandFeature> listBrandFeatures)  throws ASFeatureServiceException;

	/**
	 * Create json object list dependencies for this BrandFeature document.
	 */
	void fetchBrandFeature(String id, Set<String> addedDocuments, JSONArray data) throws ASFeatureServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASFeatureServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASFeatureServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASFeatureServiceException;

}
