/**
 ********************************************************************************
 *** FeatureDocument.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class FeatureDocument extends AbstractASGDocument implements Feature, IComparable{

	public FeatureDocument() {
		super("");
	}

	public FeatureDocument(String id){
		super(id);
	}

	public FeatureDocument(FeatureDocument toClone){
		super(toClone);
	}

	FeatureDocument(FeatureBuilder builder){
		super("");
		setName(builder.name);
		setEnabled(builder.enabled);
		setActiveInProduction(builder.activeInProduction);
		setObsolete(builder.obsolete);
		setDescription(builder.description);
		setGuards(builder.guards);
		setAccessOperation(builder.accessOperation);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public boolean getEnabled(){
		return getBoolean(PROP_ENABLED);
	}

	public void setEnabled(boolean value){
		setBoolean(PROP_ENABLED, value);
	}

	public boolean getActiveInProduction(){
		return getBoolean(PROP_ACTIVE_IN_PRODUCTION);
	}

	public void setActiveInProduction(boolean value){
		setBoolean(PROP_ACTIVE_IN_PRODUCTION, value);
	}

	public boolean getObsolete(){
		return getBoolean(PROP_OBSOLETE);
	}

	public void setObsolete(boolean value){
		setBoolean(PROP_OBSOLETE, value);
	}

	public String getDescription(){
		return getString(PROP_DESCRIPTION);
	}

	public void setDescription(String value){
		setString(PROP_DESCRIPTION, value);
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}

	public String getAccessOperation(){
		return getString(LINK_PROP_ACCESS_OPERATION);
	}

	public void setAccessOperation(String value){
		setString(LINK_PROP_ACCESS_OPERATION, value);
	}


	public String toString(){
		String ret = "Feature ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "enabled: "+getEnabled();
		ret += ", ";
		ret += "activeInProduction: "+getActiveInProduction();
		ret += ", ";
		ret += "obsolete: "+getObsolete();
		ret += ", ";
		ret += "description: "+getDescription();
		ret += ", ";
		ret += "guards: "+getGuards();
		return ret;
	}

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method


	public int compareTo(Feature comparable){
		return compareTo(comparable, FeatureSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		FeatureDocument anotherDoc = (FeatureDocument) anotherComparable;
		switch(method){
			case FeatureSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case FeatureSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case FeatureSortType.SORT_BY_ENABLED:
				return BasicComparable.compareBoolean(getEnabled(), anotherDoc.getEnabled());
			case FeatureSortType.SORT_BY_ACTIVEINPRODUCTION:
				return BasicComparable.compareBoolean(getActiveInProduction(), anotherDoc.getActiveInProduction());
			case FeatureSortType.SORT_BY_OBSOLETE:
				return BasicComparable.compareBoolean(getObsolete(), anotherDoc.getObsolete());
			case FeatureSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			case FeatureSortType.SORT_BY_ACCESSOPERATION:
				return BasicComparable.compareString(getAccessOperation(), anotherDoc.getAccessOperation());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Feature";
	}

	public String getDefinedParentName(){
		return "ASFeature";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getEnabled());
		footprint.append(getActiveInProduction());
		footprint.append(getObsolete());
		footprint.append(getDescription());
		footprint.append(getGuards());
		footprint.append(getAccessOperation());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof FeatureDocument) && ((FeatureDocument)o).getId().equals(getId()));
	}
}
