/**
 ********************************************************************************
 *** IASExperimentService.java                                                ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.asexperiment.data.Experiment;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASExperimentService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all Experiments objects stored.
	 */
	List<Experiment> getExperiments() throws ASExperimentServiceException;

	/**
	 * Returns all Experiments objects sorted by given sortType.
	 */
	List<Experiment> getExperiments(SortType sortType) throws ASExperimentServiceException;

	/**
	 * Deletes a Experiment object by id.
	 */
	void deleteExperiment(String id) throws ASExperimentServiceException;

	/**
	 * Deletes a Experiment object.
	 */
	void deleteExperiment(Experiment experiment) throws ASExperimentServiceException;

	/**
	 * Deletes multiple Experiment object.
	 */
	void deleteExperiments(List<Experiment> list) throws ASExperimentServiceException;

	/**
	 * Returns the Experiment object with the specified id.
	 */
	Experiment getExperiment(String id) throws ASExperimentServiceException;

	/**
	 * Imports a new Experiment object.
	 * Returns the created version.
	 */
	Experiment importExperiment(Experiment experiment) throws ASExperimentServiceException;

	/**
	 * Imports multiple new  Experiment object.
	 * Returns the created versions.
	 */
	List<Experiment> importExperiments(List<Experiment> list) throws ASExperimentServiceException;

	/**
	 * Creates a new Experiment object.
	 * Returns the created version.
	 */
	Experiment createExperiment(Experiment experiment) throws ASExperimentServiceException;

	/**
	 * Creates multiple new Experiment objects.
	 * Returns the created versions.
	 */
	List<Experiment> createExperiments(List<Experiment> list) throws ASExperimentServiceException;

	/**
	 * Updates a Experiment object.
	 * Returns the updated version.
	 */
	Experiment updateExperiment(Experiment experiment) throws ASExperimentServiceException;

	/**
	 * Updates multiple Experiment objects.
	 * Returns the updated versions.
	 */
	List<Experiment> updateExperiments(List<Experiment> list) throws ASExperimentServiceException;

	/**
	 * Returns all Experiment objects, where property with given name equals object.
	 */
	List<Experiment> getExperimentsByProperty(String propertyName, Object value) throws ASExperimentServiceException;

	/**
	 * Returns all Experiment objects, where property with given name equals object, sorted.
	 */
	List<Experiment> getExperimentsByProperty(String propertyName, Object value, SortType sortType) throws ASExperimentServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnExperiments(DocumentQuery query) throws ASExperimentServiceException;

	/**
	 * Returns all Experiment objects, where property matches.
	 */
	List<Experiment> getExperimentsByProperty(QueryProperty... property) throws ASExperimentServiceException;

	/**
	 * Returns all Experiment objects, where property matches, sorted.
	 */
	List<Experiment> getExperimentsByProperty(SortType sortType, QueryProperty... property) throws ASExperimentServiceException;

	/**
	 * Returns all Experiments count.
	 */
	int getExperimentsCount() throws ASExperimentServiceException;

	/**
	 * Returns Experiments objects segment.
	 */
	List<Experiment> getExperiments(Segment aSegment) throws ASExperimentServiceException;

	/**
	 * Returns Experiment objects segment, where property matches.
	 */
	List<Experiment> getExperimentsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASExperimentServiceException;

	/**
	 * Returns Experiment objects segment, where property matches, sorted.
	 */
	List<Experiment> getExperimentsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASExperimentServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportExperimentsToXML(List<Experiment> listExperiments)  throws ASExperimentServiceException;

	/**
	 * Create json object list dependencies for this Experiment document.
	 */
	void fetchExperiment(String id, Set<String> addedDocuments, JSONArray data) throws ASExperimentServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASExperimentServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASExperimentServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASExperimentServiceException;

}
