/**
 ********************************************************************************
 *** MultiOpBrandsLocalizationsAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asbrand.data.BrandFactory;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.bean.LocalizationsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asbrand.bean.LocalizationsQuickAddFB;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandsLocalizationsAction extends BaseBrandAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asbrandBrandLocalizationsShow"))
			return asbrandBrandLocalizationsShow(mapping, req, res);
		if (path.equals("asbrandBrandLocalizationsAdd"))
			return asbrandBrandLocalizationsAdd(mapping, req, res);
		if (path.equals("asbrandBrandLocalizationsDelete"))
			return asbrandBrandLocalizationsDelete(mapping, req, res);
		if (path.equals("asbrandBrandLocalizationsMove"))
			return asbrandBrandLocalizationsMove(mapping, req, res);
		if (path.equals("asbrandBrandLocalizationsQuickAdd"))
			return asbrandBrandLocalizationsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asbrandBrandLocalizationsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brand = getASBrandService().getBrand(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrands(brand, req);

		LocalizationsElementFB form = new LocalizationsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandLocalizationsElementForm", form);

		LocalizationsQuickAddFB quickAddForm = new LocalizationsQuickAddFB() ;
		quickAddForm.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandLocalizationsQuickAddForm", quickAddForm);


		//link localization to ASResourceData.LocalizationBundle
		List<LocalizationBundle> localizationbundles = getASResourceDataService().getLocalizationBundles(new LocalizationBundleSortType(LocalizationBundleSortType.SORT_BY_NAME));
		List<LabelValueBean> localizationbundlesValues = new ArrayList<LabelValueBean>(localizationbundles.size());
		for (int i=0; i<localizationbundles.size(); i++){
			net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle tmp_localizationbundle = (net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle) localizationbundles.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_localizationbundle.getId(), tmp_localizationbundle.getName()+" ["+tmp_localizationbundle.getId()+"]" );
			localizationbundlesValues.add(bean);
		}
		addBeanToRequest(req, "localizationValuesCollection", localizationbundlesValues);
		// generate list ...
		int size = brand.getLocalizationsSize();
		List<LocalizationsElementFB> beans = new ArrayList<LocalizationsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brand.getLocalizationsElement(i);
			LocalizationsElementFB bean = new LocalizationsElementFB();
			bean.setOwnerId(brand.getId());
			bean.setPosition(i);
			bean.setLocalization(value);
			try{
				LocalizationBundle tmp_localizationbundle = getASResourceDataService().getLocalizationBundle(value);
				bean.setDescription(tmp_localizationbundle.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asbrandBrandLocalizationsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brandCurr = getASBrandService().getBrand(id);
		canUpdateBrands(brandCurr, req);
		checkBrands(brandCurr, req);
		int position = getIntParameter(req, "pPosition");
		Brand brand = getASBrandService().getBrand(id);
		brand.removeLocalizationsElement(position);
		getASBrandService().updateBrand(brand);
		return asbrandBrandLocalizationsShow(mapping, req, res);
	}

	public ActionCommand asbrandBrandLocalizationsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Brand brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brand, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brand, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brand, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brand, position);
		return asbrandBrandLocalizationsShow(mapping, req, res);
	}

	private void moveUp(Brand brand, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brand.swapLocalizationsElement(position, position-1);
		getASBrandService().updateBrand(brand);
	}

	private void moveTop(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brand.setLocalizations(targetList);
		getASBrandService().updateBrand(brand);
	}

	private void moveDown(Brand brand, int position) throws ASGRuntimeException {
		if (position<brand.getLocalizationsSize()-1){
			brand.swapLocalizationsElement(position, position+1);
			getASBrandService().updateBrand(brand);
		}
	}

	private void moveBottom(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brand.setLocalizations(targetList);
		getASBrandService().updateBrand(brand);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asbrandBrandLocalizationsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsElementFB form = new LocalizationsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		brand.addLocalizationsElement(form.getLocalization());
		getASBrandService().updateBrand(brand);
		return asbrandBrandLocalizationsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asbrandBrandLocalizationsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsQuickAddFB form = new LocalizationsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				brand.addLocalizationsElement(""+i);
			}
		}
		getASBrandService().updateBrand(brand);
		return asbrandBrandLocalizationsShow(mapping, req, res);
	}

}
