/**
 ********************************************************************************
 *** MultiOpConstraintsContextInitializersAction.java                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ContextInitializersElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.ContextInitializersQuickAddFB;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpConstraintsContextInitializersAction extends BaseConstraintAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationConstraintContextInitializersShow"))
			return anoaccessconfigurationConstraintContextInitializersShow(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintContextInitializersAdd"))
			return anoaccessconfigurationConstraintContextInitializersAdd(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintContextInitializersDelete"))
			return anoaccessconfigurationConstraintContextInitializersDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintContextInitializersMove"))
			return anoaccessconfigurationConstraintContextInitializersMove(mapping, req, res);
		if (path.equals("anoaccessconfigurationConstraintContextInitializersQuickAdd"))
			return anoaccessconfigurationConstraintContextInitializersQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand anoaccessconfigurationConstraintContextInitializersShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Constraint constraint = getAnoAccessConfigurationService().getConstraint(id);
		addBeanToRequest(req, "ownerId", id);
		checkConstraints(constraint, req);

		ContextInitializersElementFB form = new ContextInitializersElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(constraint.getId());
		addBeanToRequest(req, "anoaccessconfigurationConstraintContextInitializersElementForm", form);

		ContextInitializersQuickAddFB quickAddForm = new ContextInitializersQuickAddFB() ;
		quickAddForm.setOwnerId(constraint.getId());
		addBeanToRequest(req, "anoaccessconfigurationConstraintContextInitializersQuickAddForm", quickAddForm);


		//link contextInitializer to AnoAccessConfiguration.ContextInitializer
		List<ContextInitializer> contextinitializers = getAnoAccessConfigurationService().getContextInitializers(new ContextInitializerSortType(ContextInitializerSortType.SORT_BY_NAME));
		List<LabelValueBean> contextinitializersValues = new ArrayList<LabelValueBean>(contextinitializers.size());
		for (int i=0; i<contextinitializers.size(); i++){
			net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer tmp_contextinitializer = (net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer) contextinitializers.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_contextinitializer.getId(), tmp_contextinitializer.getName()+" ["+tmp_contextinitializer.getId()+"]" );
			contextinitializersValues.add(bean);
		}
		addBeanToRequest(req, "contextinitializerValuesCollection", contextinitializersValues);
		// generate list ...
		int size = constraint.getContextInitializersSize();
		List<ContextInitializersElementFB> beans = new ArrayList<ContextInitializersElementFB>(size);
		for (int i=0; i<size; i++){
			String value = constraint.getContextInitializersElement(i);
			ContextInitializersElementFB bean = new ContextInitializersElementFB();
			bean.setOwnerId(constraint.getId());
			bean.setPosition(i);
			bean.setContextInitializer(value);
			try{
				ContextInitializer tmp_contextinitializer = getAnoAccessConfigurationService().getContextInitializer(value);
				bean.setDescription(tmp_contextinitializer.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand anoaccessconfigurationConstraintContextInitializersDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Constraint constraintCurr = getAnoAccessConfigurationService().getConstraint(id);
		canUpdateConstraints(constraintCurr, req);
		checkConstraints(constraintCurr, req);
		int position = getIntParameter(req, "pPosition");
		Constraint constraint = getAnoAccessConfigurationService().getConstraint(id);
		constraint.removeContextInitializersElement(position);
		getAnoAccessConfigurationService().updateConstraint(constraint);
		return anoaccessconfigurationConstraintContextInitializersShow(mapping, req, res);
	}

	public ActionCommand anoaccessconfigurationConstraintContextInitializersMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Constraint constraint = getAnoAccessConfigurationService().getConstraint(id);
		canUpdateConstraints(constraint, req);
		checkConstraints(constraint, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(constraint, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(constraint, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(constraint, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(constraint, position);
		return anoaccessconfigurationConstraintContextInitializersShow(mapping, req, res);
	}

	private void moveUp(Constraint constraint, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		constraint.swapContextInitializersElement(position, position-1);
		getAnoAccessConfigurationService().updateConstraint(constraint);
	}

	private void moveTop(Constraint constraint, int position) throws ASGRuntimeException {
		List<String> targetList = constraint.getContextInitializers();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		constraint.setContextInitializers(targetList);
		getAnoAccessConfigurationService().updateConstraint(constraint);
	}

	private void moveDown(Constraint constraint, int position) throws ASGRuntimeException {
		if (position<constraint.getContextInitializersSize()-1){
			constraint.swapContextInitializersElement(position, position+1);
			getAnoAccessConfigurationService().updateConstraint(constraint);
		}
	}

	private void moveBottom(Constraint constraint, int position) throws ASGRuntimeException {
		List<String> targetList = constraint.getContextInitializers();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		constraint.setContextInitializers(targetList);
		getAnoAccessConfigurationService().updateConstraint(constraint);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand anoaccessconfigurationConstraintContextInitializersAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ContextInitializersElementFB form = new ContextInitializersElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Constraint constraint;
		constraint = getAnoAccessConfigurationService().getConstraint(id);
		canUpdateConstraints(constraint, req);
		checkConstraints(constraint, req);
		constraint.addContextInitializersElement(form.getContextInitializer());
		getAnoAccessConfigurationService().updateConstraint(constraint);
		return anoaccessconfigurationConstraintContextInitializersShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand anoaccessconfigurationConstraintContextInitializersQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ContextInitializersQuickAddFB form = new ContextInitializersQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Constraint constraint;
		constraint = getAnoAccessConfigurationService().getConstraint(id);
		canUpdateConstraints(constraint, req);
		checkConstraints(constraint, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				constraint.addContextInitializersElement(""+i);
			}
		}
		getAnoAccessConfigurationService().updateConstraint(constraint);
		return anoaccessconfigurationConstraintContextInitializersShow(mapping, req, res);
	}

}
