/**
 ********************************************************************************
 *** ASWebDataServiceImpl.java                                                ***
 *** The implementation of the IASWebDataService.                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.aswebdata.data.ModuleASWebData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.data.PagexXMLHelper;
import net.anotheria.anosite.gen.aswebdata.data.PagexDocument;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.gen.asfeature.service.ASFeatureServiceException;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceException;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.data.BoxXMLHelper;
import net.anotheria.anosite.gen.aswebdata.data.BoxDocument;
import net.anotheria.anosite.gen.asfederateddata.service.ASFederatedDataServiceException;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.AttributeXMLHelper;
import net.anotheria.anosite.gen.aswebdata.data.AttributeDocument;

public class ASWebDataServiceImpl extends BasicCMSService implements IASWebDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASWebDataServiceImpl instance;

	private ASWebDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAsWebDataListener());
		addModuleListener(ModuleASWebData.MODULE_ID, this);
	}

	static final ASWebDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASWebDataServiceImpl();
		}
		return instance;
	}

	private ModuleASWebData _getModuleASWebData(){
		return (ModuleASWebData) getModule(ModuleASWebData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<Pagex> getPagexs(){
		List<Pagex> pagexs = new ArrayList<>();
		pagexs.addAll(_getModuleASWebData().getPagexs());
		return pagexs;
	}

	@Override
	public List<Pagex> getPagexs(SortType sortType){
		return StaticQuickSorter.sort(getPagexs(), sortType);
	}

	/**
	 * Returns the Pagex objects with the specified ids.
	 */
	public List<Pagex> getPagexs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Pagex> all = getPagexs();
		List<Pagex> ret = new ArrayList<>();
		for (Pagex pagex : all){
			if(ids.contains(pagex.getId())){
				ret.add(pagex);
			}
		}
		return ret;
	}

	/**
	 * Returns the Pagex objects with the specified ids, sorted by given sorttype.
	 */
	public List<Pagex> getPagexs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPagexs(ids), sortType);
	}

	@Override
	public void deletePagex(Pagex pagex){
		deletePagex(pagex.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(pagex);
		}
	}

	@Override
	public void deletePagex(String id){
		ModuleASWebData module = _getModuleASWebData();
		Pagex varValue = hasServiceListeners()?module.getPagex(id):null;
		module.deletePagex(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePagexs(List<Pagex> list){
		ModuleASWebData module = _getModuleASWebData();
		for (Pagex pagex : list){
			module.deletePagex(pagex.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Pagex getPagex(String id){
		return _getModuleASWebData().getPagex(id);
	}

	@Override
	public Pagex importPagex(Pagex pagex){
		ModuleASWebData module = _getModuleASWebData();
		module.importPagex((PagexDocument)pagex);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(pagex);
		}
		return pagex;
	}

	@Override
	public List<Pagex> importPagexs(List<Pagex> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Pagex> ret = new ArrayList<>();
		for (Pagex pagex : list){
			Pagex imported = module.importPagex((PagexDocument)pagex);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Pagex pagex : ret)
				fireObjectImportedEvent(pagex);
		}
		return ret;
	}

	@Override
	public Pagex createPagex(Pagex pagex){
		ModuleASWebData module = _getModuleASWebData();
		module.createPagex((PagexDocument)pagex);
		updateModule(module);
		fireObjectCreatedEvent(pagex);
		return pagex;
	}

	@Override
	/**
	 * Creates multiple new Pagex objects.
	 * Returns the created versions.
	 */
	public List<Pagex> createPagexs(List<Pagex> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Pagex> ret = new ArrayList<>();
		for (Pagex pagex : list){
			Pagex created = module.createPagex((PagexDocument)pagex);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Pagex pagex : ret)
				fireObjectCreatedEvent(pagex);
		}
		return ret;
	}

	@Override
	public Pagex updatePagex(Pagex pagex){
		Pagex oldVersion = null;
		ModuleASWebData module = _getModuleASWebData();
		if (hasServiceListeners())
			oldVersion = module.getPagex(pagex.getId());
		module.updatePagex((PagexDocument)pagex);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, pagex);
		}
		return pagex;
	}

	@Override
	public List<Pagex> updatePagexs(List<Pagex> list){
		List<Pagex> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASWebData module = _getModuleASWebData();
		for (Pagex pagex : list){
			if (oldList!=null)
				oldList.add(module.getPagex(pagex.getId()));
			module.updatePagex((PagexDocument)pagex);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Pagex> getPagexsByProperty(String propertyName, Object value){
		List<Pagex> allPagexs = getPagexs();
		List<Pagex> ret = new ArrayList<>();
		for (int i=0; i<allPagexs.size(); i++){
			Pagex pagex = allPagexs.get(i);
			try{
				Property property = ((PagexDocument)pagex).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(pagex);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(pagex);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(pagex);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Pagex> getPagexsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPagexsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Pagexs
	 */
	public QueryResult executeQueryOnPagexs(DocumentQuery query){
		List<Pagex> allPagexs = getPagexs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPagexs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPagexs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Pagex objects, where property matches.
	 */
	public List<Pagex> getPagexsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Pagex> ret = new ArrayList<>();
		List<Pagex> src = getPagexs();
		for ( Pagex pagex : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(pagex.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagex);
		}
		return ret;
	}

	/**
	 * Returns all Pagex objects, where property matches, sorted
	 */
	public List<Pagex> getPagexsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPagexsByProperty(property), sortType);
	}

	/**
	 * Returns Pagex objects count.
	 */
	public int getPagexsCount() {
		return _getModuleASWebData().getPagexs().size();
	}

	/**
	 * Returns Pagex objects segment.
	 */
	public List<Pagex> getPagexs(Segment aSegment) {
		return Slicer.slice(aSegment, getPagexs()).getSliceData();
	}

	/**
	 * Returns Pagex objects segment, where property matched.
	 */
	public List<Pagex> getPagexsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Pagex> ret = new ArrayList<>();
		List<Pagex> src = getPagexs();
		for (Pagex pagex : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(pagex.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(pagex);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Pagex objects segment, where property matched, sorted.
	 */
	public List<Pagex> getPagexsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPagexsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPagex(final String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Pagex" + id))
			return;

		try {
			final PagexDocument pagex = _getModuleASWebData().getPagex(id);
			addedDocuments.add("Pagex" + id);

			if (!StringUtils.isEmpty(pagex.getTemplate()))
				getASSiteDataService().fetchPageTemplate(pagex.getTemplate(), addedDocuments, data);
			if (!StringUtils.isEmpty(pagex.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(pagex.getAccessOperation(), addedDocuments, data);
			if (!StringUtils.isEmpty(pagex.getFeature()))
				getASFeatureService().fetchFeature(pagex.getFeature(), addedDocuments, data);

			if (!pagex.getMediaLinks().isEmpty()) {
				for (String aMediaLinksId: pagex.getMediaLinks()) {
					getASSiteDataService().fetchMediaLink(aMediaLinksId, addedDocuments, data);
				}
			}
			if (!pagex.getScripts().isEmpty()) {
				for (String aScriptsId: pagex.getScripts()) {
					getASSiteDataService().fetchScript(aScriptsId, addedDocuments, data);
				}
			}
			if (!pagex.getAttributes().isEmpty()) {
				for (String aAttributesId: pagex.getAttributes()) {
					getASWebDataService().fetchAttribute(aAttributesId, addedDocuments, data);
				}
			}
			if (!pagex.getC1().isEmpty()) {
				for (String aC1Id: pagex.getC1()) {
					getASWebDataService().fetchBox(aC1Id, addedDocuments, data);
				}
			}
			if (!pagex.getC2().isEmpty()) {
				for (String aC2Id: pagex.getC2()) {
					getASWebDataService().fetchBox(aC2Id, addedDocuments, data);
				}
			}
			if (!pagex.getC3().isEmpty()) {
				for (String aC3Id: pagex.getC3()) {
					getASWebDataService().fetchBox(aC3Id, addedDocuments, data);
				}
			}
			if (!pagex.getHeader().isEmpty()) {
				for (String aHeaderId: pagex.getHeader()) {
					getASWebDataService().fetchBox(aHeaderId, addedDocuments, data);
				}
			}
			if (!pagex.getFooter().isEmpty()) {
				for (String aFooterId: pagex.getFooter()) {
					getASWebDataService().fetchBox(aFooterId, addedDocuments, data);
				}
			}
			if (!pagex.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: pagex.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(pagex);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASWebData");
			dataObject.put("document", "ASWebData_Pagex");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(ASFeatureServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASFeature" + e.getMessage());
		}catch(AnoAccessConfigurationServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASResourceDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Pagex instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Pagex instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPagex(final JSONObject data) throws ASWebDataServiceException {
		try {
			String objectData = data.getString("object");
			Pagex pagex = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PagexDocument.class);

			try {
				updatePagex(pagex);
			}catch(Exception e){
				importPagex(pagex);
			}
		}catch(JSONException e){
			throw new ASWebDataServiceException("Problem with getting data from json Pagex instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException("Problem with parsing data for this Pagex instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllPagexs(String sourceLanguage, String targetLanguage){
		List<Pagex> allDocumentsSrc = getPagexs();
		List<Pagex> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (Pagex document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updatePagexs(allDocuments);
	}

	@Override
	public List<Box> getBoxs(){
		List<Box> boxs = new ArrayList<>();
		boxs.addAll(_getModuleASWebData().getBoxs());
		return boxs;
	}

	@Override
	public List<Box> getBoxs(SortType sortType){
		return StaticQuickSorter.sort(getBoxs(), sortType);
	}

	/**
	 * Returns the Box objects with the specified ids.
	 */
	public List<Box> getBoxs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Box> all = getBoxs();
		List<Box> ret = new ArrayList<>();
		for (Box box : all){
			if(ids.contains(box.getId())){
				ret.add(box);
			}
		}
		return ret;
	}

	/**
	 * Returns the Box objects with the specified ids, sorted by given sorttype.
	 */
	public List<Box> getBoxs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getBoxs(ids), sortType);
	}

	@Override
	public void deleteBox(Box box){
		deleteBox(box.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(box);
		}
	}

	@Override
	public void deleteBox(String id){
		ModuleASWebData module = _getModuleASWebData();
		Box varValue = hasServiceListeners()?module.getBox(id):null;
		module.deleteBox(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteBoxs(List<Box> list){
		ModuleASWebData module = _getModuleASWebData();
		for (Box box : list){
			module.deleteBox(box.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Box getBox(String id){
		return _getModuleASWebData().getBox(id);
	}

	@Override
	public Box importBox(Box box){
		ModuleASWebData module = _getModuleASWebData();
		module.importBox((BoxDocument)box);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(box);
		}
		return box;
	}

	@Override
	public List<Box> importBoxs(List<Box> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Box> ret = new ArrayList<>();
		for (Box box : list){
			Box imported = module.importBox((BoxDocument)box);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Box box : ret)
				fireObjectImportedEvent(box);
		}
		return ret;
	}

	@Override
	public Box createBox(Box box){
		ModuleASWebData module = _getModuleASWebData();
		module.createBox((BoxDocument)box);
		updateModule(module);
		fireObjectCreatedEvent(box);
		return box;
	}

	@Override
	/**
	 * Creates multiple new Box objects.
	 * Returns the created versions.
	 */
	public List<Box> createBoxs(List<Box> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Box> ret = new ArrayList<>();
		for (Box box : list){
			Box created = module.createBox((BoxDocument)box);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Box box : ret)
				fireObjectCreatedEvent(box);
		}
		return ret;
	}

	@Override
	public Box updateBox(Box box){
		Box oldVersion = null;
		ModuleASWebData module = _getModuleASWebData();
		if (hasServiceListeners())
			oldVersion = module.getBox(box.getId());
		module.updateBox((BoxDocument)box);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, box);
		}
		return box;
	}

	@Override
	public List<Box> updateBoxs(List<Box> list){
		List<Box> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASWebData module = _getModuleASWebData();
		for (Box box : list){
			if (oldList!=null)
				oldList.add(module.getBox(box.getId()));
			module.updateBox((BoxDocument)box);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Box> getBoxsByProperty(String propertyName, Object value){
		List<Box> allBoxs = getBoxs();
		List<Box> ret = new ArrayList<>();
		for (int i=0; i<allBoxs.size(); i++){
			Box box = allBoxs.get(i);
			try{
				Property property = ((BoxDocument)box).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(box);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(box);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(box);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Box> getBoxsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getBoxsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Boxs
	 */
	public QueryResult executeQueryOnBoxs(DocumentQuery query){
		List<Box> allBoxs = getBoxs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allBoxs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allBoxs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Box objects, where property matches.
	 */
	public List<Box> getBoxsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Box> ret = new ArrayList<>();
		List<Box> src = getBoxs();
		for ( Box box : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(box.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(box);
		}
		return ret;
	}

	/**
	 * Returns all Box objects, where property matches, sorted
	 */
	public List<Box> getBoxsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getBoxsByProperty(property), sortType);
	}

	/**
	 * Returns Box objects count.
	 */
	public int getBoxsCount() {
		return _getModuleASWebData().getBoxs().size();
	}

	/**
	 * Returns Box objects segment.
	 */
	public List<Box> getBoxs(Segment aSegment) {
		return Slicer.slice(aSegment, getBoxs()).getSliceData();
	}

	/**
	 * Returns Box objects segment, where property matched.
	 */
	public List<Box> getBoxsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Box> ret = new ArrayList<>();
		List<Box> src = getBoxs();
		for (Box box : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(box.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(box);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Box objects segment, where property matched, sorted.
	 */
	public List<Box> getBoxsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getBoxsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchBox(final String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Box" + id))
			return;

		try {
			final BoxDocument box = _getModuleASWebData().getBox(id);
			addedDocuments.add("Box" + id);

			if (!StringUtils.isEmpty(box.getType()))
				getASFederatedDataService().fetchBoxType(box.getType(), addedDocuments, data);
			if (!StringUtils.isEmpty(box.getHandler()))
				getASFederatedDataService().fetchBoxHandlerDef(box.getHandler(), addedDocuments, data);
			if (!StringUtils.isEmpty(box.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(box.getAccessOperation(), addedDocuments, data);
			if (!StringUtils.isEmpty(box.getFeature()))
				getASFeatureService().fetchFeature(box.getFeature(), addedDocuments, data);

			if (!box.getMediaLinks().isEmpty()) {
				for (String aMediaLinksId: box.getMediaLinks()) {
					getASSiteDataService().fetchMediaLink(aMediaLinksId, addedDocuments, data);
				}
			}
			if (!box.getScripts().isEmpty()) {
				for (String aScriptsId: box.getScripts()) {
					getASSiteDataService().fetchScript(aScriptsId, addedDocuments, data);
				}
			}
			if (!box.getLocalizations().isEmpty()) {
				for (String aLocalizationsId: box.getLocalizations()) {
					getASResourceDataService().fetchLocalizationBundle(aLocalizationsId, addedDocuments, data);
				}
			}
			if (!box.getSubboxes().isEmpty()) {
				for (String aSubboxesId: box.getSubboxes()) {
					getASWebDataService().fetchBox(aSubboxesId, addedDocuments, data);
				}
			}
			if (!box.getGuards().isEmpty()) {
				for (String aGuardsId: box.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}
			if (!box.getAttributes().isEmpty()) {
				for (String aAttributesId: box.getAttributes()) {
					getASWebDataService().fetchAttribute(aAttributesId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(box);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASWebData");
			dataObject.put("document", "ASWebData_Box");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASSiteDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASSiteData" + e.getMessage());
		}catch(ASFeatureServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASFeature" + e.getMessage());
		}catch(AnoAccessConfigurationServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(ASResourceDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASResourceData" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Box instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Box instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredBox(final JSONObject data) throws ASWebDataServiceException {
		try {
			String objectData = data.getString("object");
			Box box = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), BoxDocument.class);

			try {
				updateBox(box);
			}catch(Exception e){
				importBox(box);
			}
		}catch(JSONException e){
			throw new ASWebDataServiceException("Problem with getting data from json Box instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException("Problem with parsing data for this Box instance :" + e.getMessage());
		}
	}

	// This method is not very fast, since it makes an update (eff. save) after each doc.
	public void copyMultilingualAttributesInAllBoxs(String sourceLanguage, String targetLanguage){
		List<Box> allDocumentsSrc = getBoxs();
		List<Box> allDocuments = new ArrayList<>(allDocumentsSrc.size());
		allDocuments.addAll(allDocumentsSrc);
		for (Box document : allDocuments){
			document.copyLANG2LANG(sourceLanguage, targetLanguage);
		}
		updateBoxs(allDocuments);
	}

	@Override
	public List<Attribute> getAttributes(){
		List<Attribute> attributes = new ArrayList<>();
		attributes.addAll(_getModuleASWebData().getAttributes());
		return attributes;
	}

	@Override
	public List<Attribute> getAttributes(SortType sortType){
		return StaticQuickSorter.sort(getAttributes(), sortType);
	}

	/**
	 * Returns the Attribute objects with the specified ids.
	 */
	public List<Attribute> getAttributes(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Attribute> all = getAttributes();
		List<Attribute> ret = new ArrayList<>();
		for (Attribute attribute : all){
			if(ids.contains(attribute.getId())){
				ret.add(attribute);
			}
		}
		return ret;
	}

	/**
	 * Returns the Attribute objects with the specified ids, sorted by given sorttype.
	 */
	public List<Attribute> getAttributes(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getAttributes(ids), sortType);
	}

	@Override
	public void deleteAttribute(Attribute attribute){
		deleteAttribute(attribute.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(attribute);
		}
	}

	@Override
	public void deleteAttribute(String id){
		ModuleASWebData module = _getModuleASWebData();
		Attribute varValue = hasServiceListeners()?module.getAttribute(id):null;
		module.deleteAttribute(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteAttributes(List<Attribute> list){
		ModuleASWebData module = _getModuleASWebData();
		for (Attribute attribute : list){
			module.deleteAttribute(attribute.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Attribute getAttribute(String id){
		return _getModuleASWebData().getAttribute(id);
	}

	@Override
	public Attribute importAttribute(Attribute attribute){
		ModuleASWebData module = _getModuleASWebData();
		module.importAttribute((AttributeDocument)attribute);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(attribute);
		}
		return attribute;
	}

	@Override
	public List<Attribute> importAttributes(List<Attribute> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Attribute> ret = new ArrayList<>();
		for (Attribute attribute : list){
			Attribute imported = module.importAttribute((AttributeDocument)attribute);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Attribute attribute : ret)
				fireObjectImportedEvent(attribute);
		}
		return ret;
	}

	@Override
	public Attribute createAttribute(Attribute attribute){
		ModuleASWebData module = _getModuleASWebData();
		module.createAttribute((AttributeDocument)attribute);
		updateModule(module);
		fireObjectCreatedEvent(attribute);
		return attribute;
	}

	@Override
	/**
	 * Creates multiple new Attribute objects.
	 * Returns the created versions.
	 */
	public List<Attribute> createAttributes(List<Attribute> list){
		ModuleASWebData module = _getModuleASWebData();
		List<Attribute> ret = new ArrayList<>();
		for (Attribute attribute : list){
			Attribute created = module.createAttribute((AttributeDocument)attribute);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Attribute attribute : ret)
				fireObjectCreatedEvent(attribute);
		}
		return ret;
	}

	@Override
	public Attribute updateAttribute(Attribute attribute){
		Attribute oldVersion = null;
		ModuleASWebData module = _getModuleASWebData();
		if (hasServiceListeners())
			oldVersion = module.getAttribute(attribute.getId());
		module.updateAttribute((AttributeDocument)attribute);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, attribute);
		}
		return attribute;
	}

	@Override
	public List<Attribute> updateAttributes(List<Attribute> list){
		List<Attribute> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASWebData module = _getModuleASWebData();
		for (Attribute attribute : list){
			if (oldList!=null)
				oldList.add(module.getAttribute(attribute.getId()));
			module.updateAttribute((AttributeDocument)attribute);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Attribute> getAttributesByProperty(String propertyName, Object value){
		List<Attribute> allAttributes = getAttributes();
		List<Attribute> ret = new ArrayList<>();
		for (int i=0; i<allAttributes.size(); i++){
			Attribute attribute = allAttributes.get(i);
			try{
				Property property = ((AttributeDocument)attribute).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(attribute);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(attribute);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(attribute);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Attribute> getAttributesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getAttributesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Attributes
	 */
	public QueryResult executeQueryOnAttributes(DocumentQuery query){
		List<Attribute> allAttributes = getAttributes();
		QueryResult result = new QueryResult();
		for (int i=0; i<allAttributes.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allAttributes.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Attribute objects, where property matches.
	 */
	public List<Attribute> getAttributesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Attribute> ret = new ArrayList<>();
		List<Attribute> src = getAttributes();
		for ( Attribute attribute : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(attribute.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(attribute);
		}
		return ret;
	}

	/**
	 * Returns all Attribute objects, where property matches, sorted
	 */
	public List<Attribute> getAttributesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getAttributesByProperty(property), sortType);
	}

	/**
	 * Returns Attribute objects count.
	 */
	public int getAttributesCount() {
		return _getModuleASWebData().getAttributes().size();
	}

	/**
	 * Returns Attribute objects segment.
	 */
	public List<Attribute> getAttributes(Segment aSegment) {
		return Slicer.slice(aSegment, getAttributes()).getSliceData();
	}

	/**
	 * Returns Attribute objects segment, where property matched.
	 */
	public List<Attribute> getAttributesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Attribute> ret = new ArrayList<>();
		List<Attribute> src = getAttributes();
		for (Attribute attribute : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(attribute.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(attribute);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Attribute objects segment, where property matched, sorted.
	 */
	public List<Attribute> getAttributesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getAttributesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchAttribute(final String id, Set<String> addedDocuments, JSONArray data) throws ASWebDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("Attribute" + id))
			return;

		try {
			final AttributeDocument attribute = _getModuleASWebData().getAttribute(id);
			addedDocuments.add("Attribute" + id);


			if (!attribute.getSubattributes().isEmpty()) {
				for (String aSubattributesId: attribute.getSubattributes()) {
					getASWebDataService().fetchAttribute(aSubattributesId, addedDocuments, data);
				}
			}
			if (!attribute.getGuards().isEmpty()) {
				for (String aGuardsId: attribute.getGuards()) {
					getASFederatedDataService().fetchGuardDef(aGuardsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(attribute);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASWebData");
			dataObject.put("document", "ASWebData_Attribute");

			data.put(dataObject);

		}catch(ASWebDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASWebData" + e.getMessage());
		}catch(ASFederatedDataServiceException e){
			throw new ASWebDataServiceException("Problem with getting document from ASFederatedData" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Attribute instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASWebDataServiceException ("Problem with fetching data for this Attribute instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredAttribute(final JSONObject data) throws ASWebDataServiceException {
		try {
			String objectData = data.getString("object");
			Attribute attribute = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), AttributeDocument.class);

			try {
				updateAttribute(attribute);
			}catch(Exception e){
				importAttribute(attribute);
			}
		}catch(JSONException e){
			throw new ASWebDataServiceException("Problem with getting data from json Attribute instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASWebDataServiceException("Problem with parsing data for this Attribute instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASWebDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASWEBDATA_PAGEX:
				saveTransferredPagex(data);
				break;
			case DOCUMENT_ASWEBDATA_BOX:
				saveTransferredBox(data);
				break;
			case DOCUMENT_ASWEBDATA_ATTRIBUTE:
				saveTransferredAttribute(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASWebDataServiceException("No such document");
		}
	}

	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage){
		copyMultilingualAttributesInAllPagexs(sourceLanguage, targetLanguage);
		copyMultilingualAttributesInAllBoxs(sourceLanguage, targetLanguage);
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnPagexs(query).getEntries());
		ret.add(executeQueryOnBoxs(query).getEntries());
		ret.add(executeQueryOnAttributes(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportPagexsToXML(){
		XMLNode ret = new XMLNode("Pagexs");
		List<Pagex> list = getPagexs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Pagex object : list)
			ret.addChildNode(PagexXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPagexsToXML(List<Pagex> list){
		XMLNode ret = new XMLNode("Pagexs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Pagex object : list)
			ret.addChildNode(PagexXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPagexsToXML(String[] languages){
		XMLNode ret = new XMLNode("Pagexs");
		List<Pagex> list = getPagexs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Pagex object : list)
			ret.addChildNode(PagexXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportPagexsToXML(String[] languages, List<Pagex> list){
		XMLNode ret = new XMLNode("Pagexs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Pagex object : list)
			ret.addChildNode(PagexXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportBoxsToXML(){
		XMLNode ret = new XMLNode("Boxs");
		List<Box> list = getBoxs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Box object : list)
			ret.addChildNode(BoxXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportBoxsToXML(List<Box> list){
		XMLNode ret = new XMLNode("Boxs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Box object : list)
			ret.addChildNode(BoxXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportBoxsToXML(String[] languages){
		XMLNode ret = new XMLNode("Boxs");
		List<Box> list = getBoxs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Box object : list)
			ret.addChildNode(BoxXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportBoxsToXML(String[] languages, List<Box> list){
		XMLNode ret = new XMLNode("Boxs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Box object : list)
			ret.addChildNode(BoxXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportAttributesToXML(){
		XMLNode ret = new XMLNode("Attributes");
		List<Attribute> list = getAttributes();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Attribute object : list)
			ret.addChildNode(AttributeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportAttributesToXML(List<Attribute> list){
		XMLNode ret = new XMLNode("Attributes");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Attribute object : list)
			ret.addChildNode(AttributeXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportAttributesToXML(String[] languages){
		XMLNode ret = new XMLNode("Attributes");
		List<Attribute> list = getAttributes();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Attribute object : list)
			ret.addChildNode(AttributeXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportAttributesToXML(String[] languages, List<Attribute> list){
		XMLNode ret = new XMLNode("Attributes");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Attribute object : list)
			ret.addChildNode(AttributeXMLHelper.toXML(object, languages));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASWebData");

		ret.addChildNode(exportPagexsToXML());
		ret.addChildNode(exportBoxsToXML());
		ret.addChildNode(exportAttributesToXML());

		return ret;
	}
	public XMLNode exportToXML(String[] languages){
		XMLNode ret = new XMLNode("ASWebData");

		ret.addChildNode(exportPagexsToXML(languages));
		ret.addChildNode(exportBoxsToXML(languages));
		ret.addChildNode(exportAttributesToXML(languages));

		return ret;
	}
}
