/**
 ********************************************************************************
 *** ShowPageAliassAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.PageAlias;
import net.anotheria.anosite.gen.assitedata.bean.PageAliasListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.shared.data.PageAliasTypeEnum;
import net.anotheria.anosite.gen.assitedata.bean.PageAliasListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class ShowPageAliassAction extends BasePageAliasAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PageAlias";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PageAlias";
	private static Logger log = LoggerFactory.getLogger(ShowPageAliassAction.class);
	private Sorter<PageAliasListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator targetPageDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowPageAliassAction(){
		sorter = new QuickSorter<PageAliasListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			targetPageDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PageAliasListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PageAliasListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PageAliasListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PageAliasListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PageAliasListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PageAliasListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<PageAlias> _unfiltered_pagealiass = getASSiteDataService().getPageAliass();
		List<PageAlias> pagealiass = new ArrayList<PageAlias>();
		for (int i=0; i<_unfiltered_pagealiass.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_pagealiass.get(i), "name", filterParameter0));
			if (mayPass)
				pagealiass.add(_unfiltered_pagealiass.get(i));
		}
		List<PageAliasListItemBean> beans = new ArrayList<PageAliasListItemBean>(pagealiass.size());
		for (PageAlias pagealias : pagealiass){
			checkPageAliass(pagealias, req);
			PageAliasListItemBean bean = makePageAliasListItemBean(pagealias);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "pagealiass", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected PageAliasListItemBean makePageAliasListItemBean(PageAlias pagealias) {
		PageAliasListItemBean bean = new PageAliasListItemBean();
		bean.setPlainId(pagealias.getId());
		bean.setIdForSorting(pagealias.getId());
		bean.setId(idDecorator.decorate(pagealias, "id", "3"));
		bean.setNameForSorting(pagealias.getName());
		bean.setName(nameDecorator.decorate(pagealias, "name", "null"));
		bean.setTargetPageForSorting(pagealias.getTargetPage());
		bean.setTargetPage(targetPageDecorator.decorate(pagealias, "targetPage", "null"));
		bean.setParameters(pagealias.getParameters());
		try {
			bean.setType(PageAliasTypeEnum.getConstantByValue(pagealias.getType()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setType("-----");
		} //try
		bean.setPathes(pagealias.getPathes());
		bean.setLocked(((LockableObject)pagealias).isLocked());
		bean.setLockerId(((LockableObject)pagealias).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)pagealias).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)pagealias).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(pagealias.getLastUpdateTimestamp()));
		return bean;
	}
}
