/**
 ********************************************************************************
 *** AdminapiXMLExporter.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.service;

import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLTree;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLWriter;
import net.anotheria.util.Date;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.anosite.gen.asgenericdata.service.ASGenericDataServiceFactory;
import net.anotheria.anosite.gen.ascustomdata.service.ASCustomDataServiceFactory;
import net.anotheria.anosite.gen.asfederateddata.service.ASFederatedDataServiceFactory;
import net.anotheria.anosite.gen.images.service.ImagesServiceFactory;
import net.anotheria.anosite.gen.aslayoutdata.service.ASLayoutDataServiceFactory;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceFactory;
import net.anotheria.anosite.gen.assiteconfig.service.ASSiteConfigServiceFactory;
import net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceFactory;
import net.anotheria.anosite.gen.asresourcedata.service.ASResourceDataServiceFactory;
import net.anotheria.anosite.gen.asgenericaction.service.ASGenericActionServiceFactory;
import net.anotheria.anosite.gen.ascustomaction.service.ASCustomActionServiceFactory;
import net.anotheria.anosite.gen.asaction.service.ASActionServiceFactory;
import net.anotheria.anosite.gen.aswizarddata.service.ASWizardDataServiceFactory;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceFactory;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.AnoAccessApplicationDataServiceFactory;
import net.anotheria.anosite.gen.asfeature.service.ASFeatureServiceFactory;
import net.anotheria.anosite.gen.asexperiment.service.ASExperimentServiceFactory;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceFactory;

public class AdminapiXMLExporter{

	private static AtomicLong exp = new AtomicLong();
	private static String[] LANGUAGES = null;
	static {
		AnoDocConfigurator.configure();
		String expLanguages = System.getProperty("anosite.export.languages");
		if (expLanguages!=null && expLanguages.length()>0)
			LANGUAGES = StringUtils.tokenize(expLanguages, ',');
	}

	/**
	 * Create an XML Document (ano-util) with data from all modules.
	 */
	public static XMLTree createCompleteXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
		nodes.add(ASGenericDataServiceFactory.createASGenericDataService().exportToXML());
		nodes.add(ASCustomDataServiceFactory.createASCustomDataService().exportToXML());
		nodes.add(ASFederatedDataServiceFactory.createASFederatedDataService().exportToXML());
		nodes.add(ImagesServiceFactory.createImagesService().exportToXML(LANGUAGES));
		nodes.add(ASLayoutDataServiceFactory.createASLayoutDataService().exportToXML());
		nodes.add(ASSiteDataServiceFactory.createASSiteDataService().exportToXML(LANGUAGES));
		nodes.add(ASSiteConfigServiceFactory.createASSiteConfigService().exportToXML());
		nodes.add(ASWebDataServiceFactory.createASWebDataService().exportToXML(LANGUAGES));
		nodes.add(ASResourceDataServiceFactory.createASResourceDataService().exportToXML(LANGUAGES));
		nodes.add(ASGenericActionServiceFactory.createASGenericActionService().exportToXML());
		nodes.add(ASCustomActionServiceFactory.createASCustomActionService().exportToXML());
		nodes.add(ASActionServiceFactory.createASActionService().exportToXML());
		nodes.add(ASWizardDataServiceFactory.createASWizardDataService().exportToXML());
		nodes.add(ASUserDataServiceFactory.createASUserDataService().exportToXML());
		nodes.add(AnoAccessConfigurationServiceFactory.createAnoAccessConfigurationService().exportToXML());
		nodes.add(AnoAccessApplicationDataServiceFactory.createAnoAccessApplicationDataService().exportToXML());
		nodes.add(ASFeatureServiceFactory.createASFeatureService().exportToXML());
		nodes.add(ASExperimentServiceFactory.createASExperimentService().exportToXML());
		nodes.add(ASBrandServiceFactory.createASBrandService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write XML data from all modules into given stream.
	 */
	public static void writeCompleteXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createCompleteXMLExport(), target).close();
	}

	/**
	 * Write XML data from all modules into given file.
	 */
	public static void writeCompleteXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createCompleteXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASGenericData data for export.
	 */
	public static XMLTree createASGenericDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASGenericDataServiceFactory.createASGenericDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASGenericData as XML into given stream.
	 */
	public static void writeASGenericDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASGenericDataXMLExport(), target);
	}

	/**
	 * Write ASGenericData as XML into given file.
	 */
	public static void writeASGenericDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASGenericDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASCustomData data for export.
	 */
	public static XMLTree createASCustomDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASCustomDataServiceFactory.createASCustomDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASCustomData as XML into given stream.
	 */
	public static void writeASCustomDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASCustomDataXMLExport(), target);
	}

	/**
	 * Write ASCustomData as XML into given file.
	 */
	public static void writeASCustomDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASCustomDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASFederatedData data for export.
	 */
	public static XMLTree createASFederatedDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASFederatedDataServiceFactory.createASFederatedDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASFederatedData as XML into given stream.
	 */
	public static void writeASFederatedDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASFederatedDataXMLExport(), target);
	}

	/**
	 * Write ASFederatedData as XML into given file.
	 */
	public static void writeASFederatedDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASFederatedDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from Images data for export.
	 */
	public static XMLTree createImagesXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ImagesServiceFactory.createImagesService().exportToXML(LANGUAGES));
		return createExport(nodes);
	}

	/**
	 * Write Images as XML into given stream.
	 */
	public static void writeImagesXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createImagesXMLExport(), target);
	}

	/**
	 * Write Images as XML into given file.
	 */
	public static void writeImagesXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createImagesXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASLayoutData data for export.
	 */
	public static XMLTree createASLayoutDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASLayoutDataServiceFactory.createASLayoutDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASLayoutData as XML into given stream.
	 */
	public static void writeASLayoutDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASLayoutDataXMLExport(), target);
	}

	/**
	 * Write ASLayoutData as XML into given file.
	 */
	public static void writeASLayoutDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASLayoutDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASSiteData data for export.
	 */
	public static XMLTree createASSiteDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASSiteDataServiceFactory.createASSiteDataService().exportToXML(LANGUAGES));
		return createExport(nodes);
	}

	/**
	 * Write ASSiteData as XML into given stream.
	 */
	public static void writeASSiteDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASSiteDataXMLExport(), target);
	}

	/**
	 * Write ASSiteData as XML into given file.
	 */
	public static void writeASSiteDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASSiteDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASSiteConfig data for export.
	 */
	public static XMLTree createASSiteConfigXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASSiteConfigServiceFactory.createASSiteConfigService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASSiteConfig as XML into given stream.
	 */
	public static void writeASSiteConfigXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASSiteConfigXMLExport(), target);
	}

	/**
	 * Write ASSiteConfig as XML into given file.
	 */
	public static void writeASSiteConfigXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASSiteConfigXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASWebData data for export.
	 */
	public static XMLTree createASWebDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASWebDataServiceFactory.createASWebDataService().exportToXML(LANGUAGES));
		return createExport(nodes);
	}

	/**
	 * Write ASWebData as XML into given stream.
	 */
	public static void writeASWebDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASWebDataXMLExport(), target);
	}

	/**
	 * Write ASWebData as XML into given file.
	 */
	public static void writeASWebDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASWebDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASResourceData data for export.
	 */
	public static XMLTree createASResourceDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASResourceDataServiceFactory.createASResourceDataService().exportToXML(LANGUAGES));
		return createExport(nodes);
	}

	/**
	 * Write ASResourceData as XML into given stream.
	 */
	public static void writeASResourceDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASResourceDataXMLExport(), target);
	}

	/**
	 * Write ASResourceData as XML into given file.
	 */
	public static void writeASResourceDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASResourceDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASGenericAction data for export.
	 */
	public static XMLTree createASGenericActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASGenericActionServiceFactory.createASGenericActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASGenericAction as XML into given stream.
	 */
	public static void writeASGenericActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASGenericActionXMLExport(), target);
	}

	/**
	 * Write ASGenericAction as XML into given file.
	 */
	public static void writeASGenericActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASGenericActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASCustomAction data for export.
	 */
	public static XMLTree createASCustomActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASCustomActionServiceFactory.createASCustomActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASCustomAction as XML into given stream.
	 */
	public static void writeASCustomActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASCustomActionXMLExport(), target);
	}

	/**
	 * Write ASCustomAction as XML into given file.
	 */
	public static void writeASCustomActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASCustomActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASAction data for export.
	 */
	public static XMLTree createASActionXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASActionServiceFactory.createASActionService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASAction as XML into given stream.
	 */
	public static void writeASActionXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASActionXMLExport(), target);
	}

	/**
	 * Write ASAction as XML into given file.
	 */
	public static void writeASActionXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASActionXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASWizardData data for export.
	 */
	public static XMLTree createASWizardDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASWizardDataServiceFactory.createASWizardDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASWizardData as XML into given stream.
	 */
	public static void writeASWizardDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASWizardDataXMLExport(), target);
	}

	/**
	 * Write ASWizardData as XML into given file.
	 */
	public static void writeASWizardDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASWizardDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASUserData data for export.
	 */
	public static XMLTree createASUserDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASUserDataServiceFactory.createASUserDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASUserData as XML into given stream.
	 */
	public static void writeASUserDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASUserDataXMLExport(), target);
	}

	/**
	 * Write ASUserData as XML into given file.
	 */
	public static void writeASUserDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASUserDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from AnoAccessConfiguration data for export.
	 */
	public static XMLTree createAnoAccessConfigurationXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(AnoAccessConfigurationServiceFactory.createAnoAccessConfigurationService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write AnoAccessConfiguration as XML into given stream.
	 */
	public static void writeAnoAccessConfigurationXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createAnoAccessConfigurationXMLExport(), target);
	}

	/**
	 * Write AnoAccessConfiguration as XML into given file.
	 */
	public static void writeAnoAccessConfigurationXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createAnoAccessConfigurationXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from AnoAccessApplicationData data for export.
	 */
	public static XMLTree createAnoAccessApplicationDataXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(AnoAccessApplicationDataServiceFactory.createAnoAccessApplicationDataService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write AnoAccessApplicationData as XML into given stream.
	 */
	public static void writeAnoAccessApplicationDataXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createAnoAccessApplicationDataXMLExport(), target);
	}

	/**
	 * Write AnoAccessApplicationData as XML into given file.
	 */
	public static void writeAnoAccessApplicationDataXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createAnoAccessApplicationDataXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASFeature data for export.
	 */
	public static XMLTree createASFeatureXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASFeatureServiceFactory.createASFeatureService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASFeature as XML into given stream.
	 */
	public static void writeASFeatureXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASFeatureXMLExport(), target);
	}

	/**
	 * Write ASFeature as XML into given file.
	 */
	public static void writeASFeatureXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASFeatureXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASExperiment data for export.
	 */
	public static XMLTree createASExperimentXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASExperimentServiceFactory.createASExperimentService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASExperiment as XML into given stream.
	 */
	public static void writeASExperimentXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASExperimentXMLExport(), target);
	}

	/**
	 * Write ASExperiment as XML into given file.
	 */
	public static void writeASExperimentXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASExperimentXMLExport(), target);
	}

	/**
	 * Create an XML Document (jdom) from ASBrand data for export.
	 */
	public static XMLTree createASBrandXMLExport() throws ASGRuntimeException{
		ArrayList<XMLNode> nodes = new ArrayList<XMLNode>(1);
		nodes.add(ASBrandServiceFactory.createASBrandService().exportToXML());
		return createExport(nodes);
	}

	/**
	 * Write ASBrand as XML into given stream.
	 */
	public static void writeASBrandXMLExportToStream(OutputStream target) throws IOException, ASGRuntimeException{
		new XMLWriter().write(createASBrandXMLExport(), target);
	}

	/**
	 * Write ASBrand as XML into given file.
	 */
	public static void writeASBrandXMLExportToFile(File target) throws IOException, ASGRuntimeException{
		writeToFile(createASBrandXMLExport(), target);
	}

	private static void writeToFile(XMLTree tree, File target) throws IOException{
		FileOutputStream fOut = null;
		try{
			fOut = new FileOutputStream(target);
			XMLWriter writer = new XMLWriter();
			OutputStreamWriter oWriter = writer.write(tree, fOut);
			oWriter.close();
		}catch(IOException e){;
			if (fOut!=null){
				try{
					fOut.close();
				}catch(IOException ignored){}
			}
			throw e;
		}
	}

	private static XMLTree createExport(List<XMLNode> nodes){
		XMLTree tree = new XMLTree();
		tree.setEncoding("UTF-8");
		XMLNode root = new XMLNode("export");
		root.addAttribute(new XMLAttribute("timestamp", ""+System.currentTimeMillis()));
		root.addAttribute(new XMLAttribute("date", Date.currentDate().toString()));
		tree.setRoot(root);
		root.setChildren(nodes);
		return tree;
	}

	public static void main(String[] a) throws IOException,ASGRuntimeException{
		if (a.length==0)
			interactiveMode(a);
		else
			automaticMode(a);
	}

	public static void interactiveMode(String a[]) throws IOException,ASGRuntimeException{
		while(true){
			System.out.println("Please make your choice:");
			System.out.println("0 - Quit");
			System.out.println("1 - Complete export");
			System.out.println("2 - Export ASGenericData [CMS]");
			System.out.println("3 - Export ASCustomData [CMS]");
			System.out.println("4 - Export ASFederatedData [FEDERATION]");
			System.out.println("5 - Export Images [CMS]");
			System.out.println("6 - Export ASLayoutData [CMS]");
			System.out.println("7 - Export ASSiteData [CMS]");
			System.out.println("8 - Export ASSiteConfig [CMS]");
			System.out.println("9 - Export ASWebData [CMS]");
			System.out.println("10 - Export ASResourceData [CMS]");
			System.out.println("11 - Export ASGenericAction [CMS]");
			System.out.println("12 - Export ASCustomAction [CMS]");
			System.out.println("13 - Export ASAction [FEDERATION]");
			System.out.println("14 - Export ASWizardData [CMS]");
			System.out.println("15 - Export ASUserData [CMS]");
			System.out.println("16 - Export AnoAccessConfiguration [CMS]");
			System.out.println("17 - Export AnoAccessApplicationData [CMS]");
			System.out.println("18 - Export ASFeature [CMS]");
			System.out.println("19 - Export ASExperiment [CMS]");
			System.out.println("20 - Export ASBrand [CMS]");
			String myInput = IOUtils.readlineFromStdIn();
			XMLTree tree = createExportForInput(myInput);
			if (tree==null)
				System.exit(0);
			FileOutputStream fOut = new FileOutputStream(new File("export-"+exp.incrementAndGet()+".xml"));
			OutputStreamWriter writer = new OutputStreamWriter(fOut, Charset.forName("UTF-8"));
			tree.write(writer);
			writer.flush();
			writer.close();
		}
	}

	public static void automaticMode(String a[]) throws IOException,ASGRuntimeException{
		new AdminapiXMLExporter().writeCompleteXMLExportToFile(new File("adminapi_export.xml"));
	}

	public static final XMLTree createExportForInput(String input) throws ASGRuntimeException{
		if ("0".equals(input))
			return null;
		if ("1".equals(input))
			return createCompleteXMLExport();
		if ("2".equals(input))
			return createASGenericDataXMLExport();
		if ("3".equals(input))
			return createASCustomDataXMLExport();
		if ("4".equals(input))
			return createASFederatedDataXMLExport();
		if ("5".equals(input))
			return createImagesXMLExport();
		if ("6".equals(input))
			return createASLayoutDataXMLExport();
		if ("7".equals(input))
			return createASSiteDataXMLExport();
		if ("8".equals(input))
			return createASSiteConfigXMLExport();
		if ("9".equals(input))
			return createASWebDataXMLExport();
		if ("10".equals(input))
			return createASResourceDataXMLExport();
		if ("11".equals(input))
			return createASGenericActionXMLExport();
		if ("12".equals(input))
			return createASCustomActionXMLExport();
		if ("13".equals(input))
			return createASActionXMLExport();
		if ("14".equals(input))
			return createASWizardDataXMLExport();
		if ("15".equals(input))
			return createASUserDataXMLExport();
		if ("16".equals(input))
			return createAnoAccessConfigurationXMLExport();
		if ("17".equals(input))
			return createAnoAccessApplicationDataXMLExport();
		if ("18".equals(input))
			return createASFeatureXMLExport();
		if ("19".equals(input))
			return createASExperimentXMLExport();
		if ("20".equals(input))
			return createASBrandXMLExport();
		throw new RuntimeException("Unrecognized input: " +input);
	}
}
