/**
 ********************************************************************************
 *** ASUserDataServiceImpl.java                                               ***
 *** The implementation of the IASUserDataService.                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asuserdata.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asuserdata.data.ModuleASUserData;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asuserdata.data.UserDef;
import net.anotheria.anosite.gen.asuserdata.data.UserDefXMLHelper;
import net.anotheria.anosite.gen.asuserdata.data.UserDefDocument;
import net.anotheria.anosite.gen.asuserdata.service.ASUserDataServiceException;
import net.anotheria.anosite.gen.asuserdata.data.RoleDef;
import net.anotheria.anosite.gen.asuserdata.data.RoleDefXMLHelper;
import net.anotheria.anosite.gen.asuserdata.data.RoleDefDocument;

public class ASUserDataServiceImpl extends BasicCMSService implements IASUserDataService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASUserDataServiceImpl instance;

	private ASUserDataServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.UserListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferUserDataListener());
		addModuleListener(ModuleASUserData.MODULE_ID, this);
	}

	static final ASUserDataServiceImpl getInstance(){
		if (instance==null){
			instance = new ASUserDataServiceImpl();
		}
		return instance;
	}

	private ModuleASUserData _getModuleASUserData(){
		return (ModuleASUserData) getModule(ModuleASUserData.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<UserDef> getUserDefs(){
		List<UserDef> userdefs = new ArrayList<>();
		userdefs.addAll(_getModuleASUserData().getUserDefs());
		return userdefs;
	}

	@Override
	public List<UserDef> getUserDefs(SortType sortType){
		return StaticQuickSorter.sort(getUserDefs(), sortType);
	}

	/**
	 * Returns the UserDef objects with the specified ids.
	 */
	public List<UserDef> getUserDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<UserDef> all = getUserDefs();
		List<UserDef> ret = new ArrayList<>();
		for (UserDef userdef : all){
			if(ids.contains(userdef.getId())){
				ret.add(userdef);
			}
		}
		return ret;
	}

	/**
	 * Returns the UserDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<UserDef> getUserDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getUserDefs(ids), sortType);
	}

	@Override
	public void deleteUserDef(UserDef userdef){
		deleteUserDef(userdef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(userdef);
		}
	}

	@Override
	public void deleteUserDef(String id){
		ModuleASUserData module = _getModuleASUserData();
		UserDef varValue = hasServiceListeners()?module.getUserDef(id):null;
		module.deleteUserDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteUserDefs(List<UserDef> list){
		ModuleASUserData module = _getModuleASUserData();
		for (UserDef userdef : list){
			module.deleteUserDef(userdef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public UserDef getUserDef(String id){
		return _getModuleASUserData().getUserDef(id);
	}

	@Override
	public UserDef importUserDef(UserDef userdef){
		ModuleASUserData module = _getModuleASUserData();
		module.importUserDef((UserDefDocument)userdef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(userdef);
		}
		return userdef;
	}

	@Override
	public List<UserDef> importUserDefs(List<UserDef> list){
		ModuleASUserData module = _getModuleASUserData();
		List<UserDef> ret = new ArrayList<>();
		for (UserDef userdef : list){
			UserDef imported = module.importUserDef((UserDefDocument)userdef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (UserDef userdef : ret)
				fireObjectImportedEvent(userdef);
		}
		return ret;
	}

	@Override
	public UserDef createUserDef(UserDef userdef){
		ModuleASUserData module = _getModuleASUserData();
		module.createUserDef((UserDefDocument)userdef);
		updateModule(module);
		fireObjectCreatedEvent(userdef);
		return userdef;
	}

	@Override
	/**
	 * Creates multiple new UserDef objects.
	 * Returns the created versions.
	 */
	public List<UserDef> createUserDefs(List<UserDef> list){
		ModuleASUserData module = _getModuleASUserData();
		List<UserDef> ret = new ArrayList<>();
		for (UserDef userdef : list){
			UserDef created = module.createUserDef((UserDefDocument)userdef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (UserDef userdef : ret)
				fireObjectCreatedEvent(userdef);
		}
		return ret;
	}

	@Override
	public UserDef updateUserDef(UserDef userdef){
		UserDef oldVersion = null;
		ModuleASUserData module = _getModuleASUserData();
		if (hasServiceListeners())
			oldVersion = module.getUserDef(userdef.getId());
		module.updateUserDef((UserDefDocument)userdef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, userdef);
		}
		return userdef;
	}

	@Override
	public List<UserDef> updateUserDefs(List<UserDef> list){
		List<UserDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASUserData module = _getModuleASUserData();
		for (UserDef userdef : list){
			if (oldList!=null)
				oldList.add(module.getUserDef(userdef.getId()));
			module.updateUserDef((UserDefDocument)userdef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<UserDef> getUserDefsByProperty(String propertyName, Object value){
		List<UserDef> allUserDefs = getUserDefs();
		List<UserDef> ret = new ArrayList<>();
		for (int i=0; i<allUserDefs.size(); i++){
			UserDef userdef = allUserDefs.get(i);
			try{
				Property property = ((UserDefDocument)userdef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(userdef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(userdef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(userdef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<UserDef> getUserDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getUserDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on UserDefs
	 */
	public QueryResult executeQueryOnUserDefs(DocumentQuery query){
		List<UserDef> allUserDefs = getUserDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allUserDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allUserDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all UserDef objects, where property matches.
	 */
	public List<UserDef> getUserDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<UserDef> ret = new ArrayList<>();
		List<UserDef> src = getUserDefs();
		for ( UserDef userdef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(userdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(userdef);
		}
		return ret;
	}

	/**
	 * Returns all UserDef objects, where property matches, sorted
	 */
	public List<UserDef> getUserDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getUserDefsByProperty(property), sortType);
	}

	/**
	 * Returns UserDef objects count.
	 */
	public int getUserDefsCount() {
		return _getModuleASUserData().getUserDefs().size();
	}

	/**
	 * Returns UserDef objects segment.
	 */
	public List<UserDef> getUserDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getUserDefs()).getSliceData();
	}

	/**
	 * Returns UserDef objects segment, where property matched.
	 */
	public List<UserDef> getUserDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<UserDef> ret = new ArrayList<>();
		List<UserDef> src = getUserDefs();
		for (UserDef userdef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(userdef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(userdef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns UserDef objects segment, where property matched, sorted.
	 */
	public List<UserDef> getUserDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getUserDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchUserDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASUserDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("UserDef" + id))
			return;

		try {
			final UserDefDocument userdef = _getModuleASUserData().getUserDef(id);
			addedDocuments.add("UserDef" + id);


			if (!userdef.getStatus().isEmpty()) {
				for (String aStatusId: userdef.getStatus()) {
					getASUserDataService().fetchRoleDef(aStatusId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(userdef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASUserData");
			dataObject.put("document", "ASUserData_UserDef");

			data.put(dataObject);

		}catch(ASUserDataServiceException e){
			throw new ASUserDataServiceException("Problem with getting document from ASUserData" + e.getMessage());
		}catch(IOException e){
			throw new ASUserDataServiceException ("Problem with fetching data for this UserDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASUserDataServiceException ("Problem with fetching data for this UserDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredUserDef(final JSONObject data) throws ASUserDataServiceException {
		try {
			String objectData = data.getString("object");
			UserDef userdef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), UserDefDocument.class);

			try {
				updateUserDef(userdef);
			}catch(Exception e){
				importUserDef(userdef);
			}
		}catch(JSONException e){
			throw new ASUserDataServiceException("Problem with getting data from json UserDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASUserDataServiceException("Problem with parsing data for this UserDef instance :" + e.getMessage());
		}
	}

	@Override
	public List<RoleDef> getRoleDefs(){
		List<RoleDef> roledefs = new ArrayList<>();
		roledefs.addAll(_getModuleASUserData().getRoleDefs());
		return roledefs;
	}

	@Override
	public List<RoleDef> getRoleDefs(SortType sortType){
		return StaticQuickSorter.sort(getRoleDefs(), sortType);
	}

	/**
	 * Returns the RoleDef objects with the specified ids.
	 */
	public List<RoleDef> getRoleDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<RoleDef> all = getRoleDefs();
		List<RoleDef> ret = new ArrayList<>();
		for (RoleDef roledef : all){
			if(ids.contains(roledef.getId())){
				ret.add(roledef);
			}
		}
		return ret;
	}

	/**
	 * Returns the RoleDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<RoleDef> getRoleDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getRoleDefs(ids), sortType);
	}

	@Override
	public void deleteRoleDef(RoleDef roledef){
		deleteRoleDef(roledef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(roledef);
		}
	}

	@Override
	public void deleteRoleDef(String id){
		ModuleASUserData module = _getModuleASUserData();
		RoleDef varValue = hasServiceListeners()?module.getRoleDef(id):null;
		module.deleteRoleDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteRoleDefs(List<RoleDef> list){
		ModuleASUserData module = _getModuleASUserData();
		for (RoleDef roledef : list){
			module.deleteRoleDef(roledef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public RoleDef getRoleDef(String id){
		return _getModuleASUserData().getRoleDef(id);
	}

	@Override
	public RoleDef importRoleDef(RoleDef roledef){
		ModuleASUserData module = _getModuleASUserData();
		module.importRoleDef((RoleDefDocument)roledef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(roledef);
		}
		return roledef;
	}

	@Override
	public List<RoleDef> importRoleDefs(List<RoleDef> list){
		ModuleASUserData module = _getModuleASUserData();
		List<RoleDef> ret = new ArrayList<>();
		for (RoleDef roledef : list){
			RoleDef imported = module.importRoleDef((RoleDefDocument)roledef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (RoleDef roledef : ret)
				fireObjectImportedEvent(roledef);
		}
		return ret;
	}

	@Override
	public RoleDef createRoleDef(RoleDef roledef){
		ModuleASUserData module = _getModuleASUserData();
		module.createRoleDef((RoleDefDocument)roledef);
		updateModule(module);
		fireObjectCreatedEvent(roledef);
		return roledef;
	}

	@Override
	/**
	 * Creates multiple new RoleDef objects.
	 * Returns the created versions.
	 */
	public List<RoleDef> createRoleDefs(List<RoleDef> list){
		ModuleASUserData module = _getModuleASUserData();
		List<RoleDef> ret = new ArrayList<>();
		for (RoleDef roledef : list){
			RoleDef created = module.createRoleDef((RoleDefDocument)roledef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (RoleDef roledef : ret)
				fireObjectCreatedEvent(roledef);
		}
		return ret;
	}

	@Override
	public RoleDef updateRoleDef(RoleDef roledef){
		RoleDef oldVersion = null;
		ModuleASUserData module = _getModuleASUserData();
		if (hasServiceListeners())
			oldVersion = module.getRoleDef(roledef.getId());
		module.updateRoleDef((RoleDefDocument)roledef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, roledef);
		}
		return roledef;
	}

	@Override
	public List<RoleDef> updateRoleDefs(List<RoleDef> list){
		List<RoleDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASUserData module = _getModuleASUserData();
		for (RoleDef roledef : list){
			if (oldList!=null)
				oldList.add(module.getRoleDef(roledef.getId()));
			module.updateRoleDef((RoleDefDocument)roledef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<RoleDef> getRoleDefsByProperty(String propertyName, Object value){
		List<RoleDef> allRoleDefs = getRoleDefs();
		List<RoleDef> ret = new ArrayList<>();
		for (int i=0; i<allRoleDefs.size(); i++){
			RoleDef roledef = allRoleDefs.get(i);
			try{
				Property property = ((RoleDefDocument)roledef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(roledef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(roledef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(roledef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<RoleDef> getRoleDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getRoleDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on RoleDefs
	 */
	public QueryResult executeQueryOnRoleDefs(DocumentQuery query){
		List<RoleDef> allRoleDefs = getRoleDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allRoleDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allRoleDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all RoleDef objects, where property matches.
	 */
	public List<RoleDef> getRoleDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<RoleDef> ret = new ArrayList<>();
		List<RoleDef> src = getRoleDefs();
		for ( RoleDef roledef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(roledef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(roledef);
		}
		return ret;
	}

	/**
	 * Returns all RoleDef objects, where property matches, sorted
	 */
	public List<RoleDef> getRoleDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getRoleDefsByProperty(property), sortType);
	}

	/**
	 * Returns RoleDef objects count.
	 */
	public int getRoleDefsCount() {
		return _getModuleASUserData().getRoleDefs().size();
	}

	/**
	 * Returns RoleDef objects segment.
	 */
	public List<RoleDef> getRoleDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getRoleDefs()).getSliceData();
	}

	/**
	 * Returns RoleDef objects segment, where property matched.
	 */
	public List<RoleDef> getRoleDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<RoleDef> ret = new ArrayList<>();
		List<RoleDef> src = getRoleDefs();
		for (RoleDef roledef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(roledef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(roledef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns RoleDef objects segment, where property matched, sorted.
	 */
	public List<RoleDef> getRoleDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getRoleDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchRoleDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASUserDataServiceException {
		if (id.isEmpty() || addedDocuments.contains("RoleDef" + id))
			return;

		try {
			final RoleDefDocument roledef = _getModuleASUserData().getRoleDef(id);
			addedDocuments.add("RoleDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(roledef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASUserData");
			dataObject.put("document", "ASUserData_RoleDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASUserDataServiceException ("Problem with fetching data for this RoleDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASUserDataServiceException ("Problem with fetching data for this RoleDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredRoleDef(final JSONObject data) throws ASUserDataServiceException {
		try {
			String objectData = data.getString("object");
			RoleDef roledef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), RoleDefDocument.class);

			try {
				updateRoleDef(roledef);
			}catch(Exception e){
				importRoleDef(roledef);
			}
		}catch(JSONException e){
			throw new ASUserDataServiceException("Problem with getting data from json RoleDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASUserDataServiceException("Problem with parsing data for this RoleDef instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASUserDataServiceException {
		switch(documentName) {
			case DOCUMENT_ASUSERDATA_USERDEF:
				saveTransferredUserDef(data);
				break;
			case DOCUMENT_ASUSERDATA_ROLEDEF:
				saveTransferredRoleDef(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASUserDataServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnUserDefs(query).getEntries());
		ret.add(executeQueryOnRoleDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportUserDefsToXML(){
		XMLNode ret = new XMLNode("UserDefs");
		List<UserDef> list = getUserDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserDef object : list)
			ret.addChildNode(UserDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportUserDefsToXML(List<UserDef> list){
		XMLNode ret = new XMLNode("UserDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserDef object : list)
			ret.addChildNode(UserDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRoleDefsToXML(){
		XMLNode ret = new XMLNode("RoleDefs");
		List<RoleDef> list = getRoleDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RoleDef object : list)
			ret.addChildNode(RoleDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRoleDefsToXML(List<RoleDef> list){
		XMLNode ret = new XMLNode("RoleDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (RoleDef object : list)
			ret.addChildNode(RoleDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASUserData");

		ret.addChildNode(exportUserDefsToXML());
		ret.addChildNode(exportRoleDefsToXML());

		return ret;
	}
}
