/**
 ********************************************************************************
 *** PageAliasDocument.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class PageAliasDocument extends AbstractASGDocument implements PageAlias, IComparable{

	public PageAliasDocument() {
		super("");
	}

	public PageAliasDocument(String id){
		super(id);
	}

	public PageAliasDocument(PageAliasDocument toClone){
		super(toClone);
	}

	PageAliasDocument(PageAliasBuilder builder){
		super("");
		setName(builder.name);
		setParameters(builder.parameters);
		setType(builder.type);
		setPathes(builder.pathes);
		setTargetPage(builder.targetPage);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getParameters(){
		return getString(PROP_PARAMETERS);
	}

	public void setParameters(String value){
		setString(PROP_PARAMETERS, value);
	}

	public int getType(){
		return getInt(PROP_TYPE);
	}

	public void setType(int value){
		setInt(PROP_TYPE, value);
	}

	public List<String> getPathes(){
		return copyToStringList(getList(PROP_PATHES));
	}

	public void setPathes(List<String> value){
		setList(PROP_PATHES, copyFromStringList(value));
	}

	public String getTargetPage(){
		return getString(LINK_PROP_TARGET_PAGE);
	}

	public void setTargetPage(String value){
		setString(LINK_PROP_TARGET_PAGE, value);
	}


	public String toString(){
		String ret = "PageAlias ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "parameters: "+getParameters();
		ret += ", ";
		ret += "type: "+getType();
		ret += ", ";
		ret += "pathes: "+getPathes();
		return ret;
	}

	public int getPathesSize(){
		return getList(PROP_PATHES).size();
	}

	public void addPathesElement(String path){
		getListPropertyAnyCase(PROP_PATHES).add(new StringProperty("" + path, path));
	} //method

	public void removePathesElement(int index){
		getListProperty(PROP_PATHES).remove(index);
	} //method

	public void swapPathesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_PATHES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_PATHES).get(index2)).getString();
		((StringProperty)getList(PROP_PATHES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_PATHES).get(index2)).setString(tmp1);
	} //method

	public String getPathesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_PATHES).get(index);
		return p.getString();
	} //method


	public int compareTo(PageAlias comparable){
		return compareTo(comparable, PageAliasSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		PageAliasDocument anotherDoc = (PageAliasDocument) anotherComparable;
		switch(method){
			case PageAliasSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case PageAliasSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case PageAliasSortType.SORT_BY_PARAMETERS:
				return BasicComparable.compareString(getParameters(), anotherDoc.getParameters());
			case PageAliasSortType.SORT_BY_TYPE:
				return BasicComparable.compareInt(getType(), anotherDoc.getType());
			case PageAliasSortType.SORT_BY_TARGETPAGE:
				return BasicComparable.compareString(getTargetPage(), anotherDoc.getTargetPage());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "PageAlias";
	}

	public String getDefinedParentName(){
		return "ASSiteData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getParameters());
		footprint.append(getType());
		footprint.append(getPathes());
		footprint.append(getTargetPage());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof PageAliasDocument) && ((PageAliasDocument)o).getId().equals(getId()));
	}
}
