/**
 ********************************************************************************
 *** ShowFilteredIPsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import net.anotheria.anosite.gen.assiteconfig.bean.FilteredIPListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.shared.data.AllowanceEnum;
import net.anotheria.anosite.gen.assiteconfig.bean.FilteredIPListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.asg.exception.ConstantNotFoundException;

public class ShowFilteredIPsAction extends BaseFilteredIPAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"FilteredIP";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"FilteredIP";
	private static Logger log = LoggerFactory.getLogger(ShowFilteredIPsAction.class);
	private Sorter<FilteredIPListItemBean> sorter;

	private IAttributeDecorator idDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowFilteredIPsAction(){
		sorter = new QuickSorter<FilteredIPListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = FilteredIPListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = FilteredIPListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		FilteredIPListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new FilteredIPListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (FilteredIPListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new FilteredIPListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<FilteredIP> _unfiltered_filteredips = getASSiteConfigService().getFilteredIPs();
		List<FilteredIP> filteredips = new ArrayList<FilteredIP>();
		for (int i=0; i<_unfiltered_filteredips.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_filteredips.get(i), "name", filterParameter0));
			if (mayPass)
				filteredips.add(_unfiltered_filteredips.get(i));
		}
		List<FilteredIPListItemBean> beans = new ArrayList<FilteredIPListItemBean>(filteredips.size());
		for (FilteredIP filteredip : filteredips){
			checkFilteredIPs(filteredip, req);
			FilteredIPListItemBean bean = makeFilteredIPListItemBean(filteredip);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "filteredips", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected FilteredIPListItemBean makeFilteredIPListItemBean(FilteredIP filteredip) {
		FilteredIPListItemBean bean = new FilteredIPListItemBean();
		bean.setPlainId(filteredip.getId());
		bean.setIdForSorting(filteredip.getId());
		bean.setId(idDecorator.decorate(filteredip, "id", "3"));
		bean.setIpAddress(filteredip.getIpAddress());
		bean.setMask(filteredip.getMask());
		try {
			bean.setAllowance(AllowanceEnum.getConstantByValue(filteredip.getAllowance()).name());
		}catch(net.anotheria.asg.exception.ConstantNotFoundException e){
			bean.setAllowance("-----");
		} //try
		bean.setLocked(((LockableObject)filteredip).isLocked());
		bean.setLockerId(((LockableObject)filteredip).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)filteredip).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)filteredip).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(filteredip.getLastUpdateTimestamp()));
		return bean;
	}
}
