/**
 ********************************************************************************
 *** IASResourceDataService.java                                              ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PushNotificationTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASResourceDataService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all TextResources objects stored.
	 */
	List<TextResource> getTextResources() throws ASResourceDataServiceException;

	/**
	 * Returns all TextResources objects sorted by given sortType.
	 */
	List<TextResource> getTextResources(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a TextResource object by id.
	 */
	void deleteTextResource(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a TextResource object.
	 */
	void deleteTextResource(TextResource textresource) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple TextResource object.
	 */
	void deleteTextResources(List<TextResource> list) throws ASResourceDataServiceException;

	/**
	 * Returns the TextResource object with the specified id.
	 */
	TextResource getTextResource(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new TextResource object.
	 * Returns the created version.
	 */
	TextResource importTextResource(TextResource textresource) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  TextResource object.
	 * Returns the created versions.
	 */
	List<TextResource> importTextResources(List<TextResource> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new TextResource object.
	 * Returns the created version.
	 */
	TextResource createTextResource(TextResource textresource) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new TextResource objects.
	 * Returns the created versions.
	 */
	List<TextResource> createTextResources(List<TextResource> list) throws ASResourceDataServiceException;

	/**
	 * Updates a TextResource object.
	 * Returns the updated version.
	 */
	TextResource updateTextResource(TextResource textresource) throws ASResourceDataServiceException;

	/**
	 * Updates multiple TextResource objects.
	 * Returns the updated versions.
	 */
	List<TextResource> updateTextResources(List<TextResource> list) throws ASResourceDataServiceException;

	/**
	 * Returns all TextResource objects, where property with given name equals object.
	 */
	List<TextResource> getTextResourcesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all TextResource objects, where property with given name equals object, sorted.
	 */
	List<TextResource> getTextResourcesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnTextResources(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all TextResource objects, where property matches.
	 */
	List<TextResource> getTextResourcesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all TextResource objects, where property matches, sorted.
	 */
	List<TextResource> getTextResourcesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all TextResources count.
	 */
	int getTextResourcesCount() throws ASResourceDataServiceException;

	/**
	 * Returns TextResources objects segment.
	 */
	List<TextResource> getTextResources(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns TextResource objects segment, where property matches.
	 */
	List<TextResource> getTextResourcesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns TextResource objects segment, where property matches, sorted.
	 */
	List<TextResource> getTextResourcesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type TextResource copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllTextResources(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportTextResourcesToXML(List<TextResource> listTextResources)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportTextResourcesToXML(String[] languages,List<TextResource> listTextResources) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this TextResource document.
	 */
	void fetchTextResource(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundles objects stored.
	 */
	List<LocalizationBundle> getLocalizationBundles() throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundles objects sorted by given sortType.
	 */
	List<LocalizationBundle> getLocalizationBundles(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a LocalizationBundle object by id.
	 */
	void deleteLocalizationBundle(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a LocalizationBundle object.
	 */
	void deleteLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple LocalizationBundle object.
	 */
	void deleteLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException;

	/**
	 * Returns the LocalizationBundle object with the specified id.
	 */
	LocalizationBundle getLocalizationBundle(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new LocalizationBundle object.
	 * Returns the created version.
	 */
	LocalizationBundle importLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  LocalizationBundle object.
	 * Returns the created versions.
	 */
	List<LocalizationBundle> importLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new LocalizationBundle object.
	 * Returns the created version.
	 */
	LocalizationBundle createLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new LocalizationBundle objects.
	 * Returns the created versions.
	 */
	List<LocalizationBundle> createLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException;

	/**
	 * Updates a LocalizationBundle object.
	 * Returns the updated version.
	 */
	LocalizationBundle updateLocalizationBundle(LocalizationBundle localizationbundle) throws ASResourceDataServiceException;

	/**
	 * Updates multiple LocalizationBundle objects.
	 * Returns the updated versions.
	 */
	List<LocalizationBundle> updateLocalizationBundles(List<LocalizationBundle> list) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundle objects, where property with given name equals object.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundle objects, where property with given name equals object, sorted.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnLocalizationBundles(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundle objects, where property matches.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundle objects, where property matches, sorted.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all LocalizationBundles count.
	 */
	int getLocalizationBundlesCount() throws ASResourceDataServiceException;

	/**
	 * Returns LocalizationBundles objects segment.
	 */
	List<LocalizationBundle> getLocalizationBundles(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns LocalizationBundle objects segment, where property matches.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns LocalizationBundle objects segment, where property matches, sorted.
	 */
	List<LocalizationBundle> getLocalizationBundlesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type LocalizationBundle copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllLocalizationBundles(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportLocalizationBundlesToXML(List<LocalizationBundle> listLocalizationBundles)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportLocalizationBundlesToXML(String[] languages,List<LocalizationBundle> listLocalizationBundles) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this LocalizationBundle document.
	 */
	void fetchLocalizationBundle(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplates objects stored.
	 */
	List<MailTemplate> getMailTemplates() throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplates objects sorted by given sortType.
	 */
	List<MailTemplate> getMailTemplates(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a MailTemplate object by id.
	 */
	void deleteMailTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a MailTemplate object.
	 */
	void deleteMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple MailTemplate object.
	 */
	void deleteMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns the MailTemplate object with the specified id.
	 */
	MailTemplate getMailTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new MailTemplate object.
	 * Returns the created version.
	 */
	MailTemplate importMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  MailTemplate object.
	 * Returns the created versions.
	 */
	List<MailTemplate> importMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new MailTemplate object.
	 * Returns the created version.
	 */
	MailTemplate createMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new MailTemplate objects.
	 * Returns the created versions.
	 */
	List<MailTemplate> createMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Updates a MailTemplate object.
	 * Returns the updated version.
	 */
	MailTemplate updateMailTemplate(MailTemplate mailtemplate) throws ASResourceDataServiceException;

	/**
	 * Updates multiple MailTemplate objects.
	 * Returns the updated versions.
	 */
	List<MailTemplate> updateMailTemplates(List<MailTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplate objects, where property with given name equals object.
	 */
	List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplate objects, where property with given name equals object, sorted.
	 */
	List<MailTemplate> getMailTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnMailTemplates(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplate objects, where property matches.
	 */
	List<MailTemplate> getMailTemplatesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplate objects, where property matches, sorted.
	 */
	List<MailTemplate> getMailTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all MailTemplates count.
	 */
	int getMailTemplatesCount() throws ASResourceDataServiceException;

	/**
	 * Returns MailTemplates objects segment.
	 */
	List<MailTemplate> getMailTemplates(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns MailTemplate objects segment, where property matches.
	 */
	List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns MailTemplate objects segment, where property matches, sorted.
	 */
	List<MailTemplate> getMailTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type MailTemplate copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllMailTemplates(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportMailTemplatesToXML(List<MailTemplate> listMailTemplates)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportMailTemplatesToXML(String[] languages,List<MailTemplate> listMailTemplates) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this MailTemplate document.
	 */
	void fetchMailTemplate(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplates objects stored.
	 */
	List<PdfTemplate> getPdfTemplates() throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplates objects sorted by given sortType.
	 */
	List<PdfTemplate> getPdfTemplates(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a PdfTemplate object by id.
	 */
	void deletePdfTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a PdfTemplate object.
	 */
	void deletePdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple PdfTemplate object.
	 */
	void deletePdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns the PdfTemplate object with the specified id.
	 */
	PdfTemplate getPdfTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new PdfTemplate object.
	 * Returns the created version.
	 */
	PdfTemplate importPdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  PdfTemplate object.
	 * Returns the created versions.
	 */
	List<PdfTemplate> importPdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new PdfTemplate object.
	 * Returns the created version.
	 */
	PdfTemplate createPdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new PdfTemplate objects.
	 * Returns the created versions.
	 */
	List<PdfTemplate> createPdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Updates a PdfTemplate object.
	 * Returns the updated version.
	 */
	PdfTemplate updatePdfTemplate(PdfTemplate pdftemplate) throws ASResourceDataServiceException;

	/**
	 * Updates multiple PdfTemplate objects.
	 * Returns the updated versions.
	 */
	List<PdfTemplate> updatePdfTemplates(List<PdfTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplate objects, where property with given name equals object.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplate objects, where property with given name equals object, sorted.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnPdfTemplates(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplate objects, where property matches.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplate objects, where property matches, sorted.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all PdfTemplates count.
	 */
	int getPdfTemplatesCount() throws ASResourceDataServiceException;

	/**
	 * Returns PdfTemplates objects segment.
	 */
	List<PdfTemplate> getPdfTemplates(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns PdfTemplate objects segment, where property matches.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns PdfTemplate objects segment, where property matches, sorted.
	 */
	List<PdfTemplate> getPdfTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type PdfTemplate copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllPdfTemplates(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportPdfTemplatesToXML(List<PdfTemplate> listPdfTemplates)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportPdfTemplatesToXML(String[] languages,List<PdfTemplate> listPdfTemplates) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this PdfTemplate document.
	 */
	void fetchPdfTemplate(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplates objects stored.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplates() throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplates objects sorted by given sortType.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplates(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a PushNotificationTemplate object by id.
	 */
	void deletePushNotificationTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a PushNotificationTemplate object.
	 */
	void deletePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple PushNotificationTemplate object.
	 */
	void deletePushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns the PushNotificationTemplate object with the specified id.
	 */
	PushNotificationTemplate getPushNotificationTemplate(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new PushNotificationTemplate object.
	 * Returns the created version.
	 */
	PushNotificationTemplate importPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  PushNotificationTemplate object.
	 * Returns the created versions.
	 */
	List<PushNotificationTemplate> importPushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new PushNotificationTemplate object.
	 * Returns the created version.
	 */
	PushNotificationTemplate createPushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new PushNotificationTemplate objects.
	 * Returns the created versions.
	 */
	List<PushNotificationTemplate> createPushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Updates a PushNotificationTemplate object.
	 * Returns the updated version.
	 */
	PushNotificationTemplate updatePushNotificationTemplate(PushNotificationTemplate pushnotificationtemplate) throws ASResourceDataServiceException;

	/**
	 * Updates multiple PushNotificationTemplate objects.
	 * Returns the updated versions.
	 */
	List<PushNotificationTemplate> updatePushNotificationTemplates(List<PushNotificationTemplate> list) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplate objects, where property with given name equals object.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplate objects, where property with given name equals object, sorted.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnPushNotificationTemplates(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplate objects, where property matches.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplate objects, where property matches, sorted.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all PushNotificationTemplates count.
	 */
	int getPushNotificationTemplatesCount() throws ASResourceDataServiceException;

	/**
	 * Returns PushNotificationTemplates objects segment.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplates(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns PushNotificationTemplate objects segment, where property matches.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns PushNotificationTemplate objects segment, where property matches, sorted.
	 */
	List<PushNotificationTemplate> getPushNotificationTemplatesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type PushNotificationTemplate copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllPushNotificationTemplates(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportPushNotificationTemplatesToXML(List<PushNotificationTemplate> listPushNotificationTemplates)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportPushNotificationTemplatesToXML(String[] languages,List<PushNotificationTemplate> listPushNotificationTemplates) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this PushNotificationTemplate document.
	 */
	void fetchPushNotificationTemplate(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all Images objects stored.
	 */
	List<Image> getImages() throws ASResourceDataServiceException;

	/**
	 * Returns all Images objects sorted by given sortType.
	 */
	List<Image> getImages(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a Image object by id.
	 */
	void deleteImage(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a Image object.
	 */
	void deleteImage(Image image) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple Image object.
	 */
	void deleteImages(List<Image> list) throws ASResourceDataServiceException;

	/**
	 * Returns the Image object with the specified id.
	 */
	Image getImage(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new Image object.
	 * Returns the created version.
	 */
	Image importImage(Image image) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  Image object.
	 * Returns the created versions.
	 */
	List<Image> importImages(List<Image> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new Image object.
	 * Returns the created version.
	 */
	Image createImage(Image image) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new Image objects.
	 * Returns the created versions.
	 */
	List<Image> createImages(List<Image> list) throws ASResourceDataServiceException;

	/**
	 * Updates a Image object.
	 * Returns the updated version.
	 */
	Image updateImage(Image image) throws ASResourceDataServiceException;

	/**
	 * Updates multiple Image objects.
	 * Returns the updated versions.
	 */
	List<Image> updateImages(List<Image> list) throws ASResourceDataServiceException;

	/**
	 * Returns all Image objects, where property with given name equals object.
	 */
	List<Image> getImagesByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all Image objects, where property with given name equals object, sorted.
	 */
	List<Image> getImagesByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnImages(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all Image objects, where property matches.
	 */
	List<Image> getImagesByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all Image objects, where property matches, sorted.
	 */
	List<Image> getImagesByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all Images count.
	 */
	int getImagesCount() throws ASResourceDataServiceException;

	/**
	 * Returns Images objects segment.
	 */
	List<Image> getImages(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns Image objects segment, where property matches.
	 */
	List<Image> getImagesByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns Image objects segment, where property matches, sorted.
	 */
	List<Image> getImagesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * In all documents of type Image copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllImages(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportImagesToXML(List<Image> listImages)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportImagesToXML(String[] languages,List<Image> listImages) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this Image document.
	 */
	void fetchImage(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLinks objects stored.
	 */
	List<FileLink> getFileLinks() throws ASResourceDataServiceException;

	/**
	 * Returns all FileLinks objects sorted by given sortType.
	 */
	List<FileLink> getFileLinks(SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Deletes a FileLink object by id.
	 */
	void deleteFileLink(String id) throws ASResourceDataServiceException;

	/**
	 * Deletes a FileLink object.
	 */
	void deleteFileLink(FileLink filelink) throws ASResourceDataServiceException;

	/**
	 * Deletes multiple FileLink object.
	 */
	void deleteFileLinks(List<FileLink> list) throws ASResourceDataServiceException;

	/**
	 * Returns the FileLink object with the specified id.
	 */
	FileLink getFileLink(String id) throws ASResourceDataServiceException;

	/**
	 * Imports a new FileLink object.
	 * Returns the created version.
	 */
	FileLink importFileLink(FileLink filelink) throws ASResourceDataServiceException;

	/**
	 * Imports multiple new  FileLink object.
	 * Returns the created versions.
	 */
	List<FileLink> importFileLinks(List<FileLink> list) throws ASResourceDataServiceException;

	/**
	 * Creates a new FileLink object.
	 * Returns the created version.
	 */
	FileLink createFileLink(FileLink filelink) throws ASResourceDataServiceException;

	/**
	 * Creates multiple new FileLink objects.
	 * Returns the created versions.
	 */
	List<FileLink> createFileLinks(List<FileLink> list) throws ASResourceDataServiceException;

	/**
	 * Updates a FileLink object.
	 * Returns the updated version.
	 */
	FileLink updateFileLink(FileLink filelink) throws ASResourceDataServiceException;

	/**
	 * Updates multiple FileLink objects.
	 * Returns the updated versions.
	 */
	List<FileLink> updateFileLinks(List<FileLink> list) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLink objects, where property with given name equals object.
	 */
	List<FileLink> getFileLinksByProperty(String propertyName, Object value) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLink objects, where property with given name equals object, sorted.
	 */
	List<FileLink> getFileLinksByProperty(String propertyName, Object value, SortType sortType) throws ASResourceDataServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnFileLinks(DocumentQuery query) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLink objects, where property matches.
	 */
	List<FileLink> getFileLinksByProperty(QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLink objects, where property matches, sorted.
	 */
	List<FileLink> getFileLinksByProperty(SortType sortType, QueryProperty... property) throws ASResourceDataServiceException;

	/**
	 * Returns all FileLinks count.
	 */
	int getFileLinksCount() throws ASResourceDataServiceException;

	/**
	 * Returns FileLinks objects segment.
	 */
	List<FileLink> getFileLinks(Segment aSegment) throws ASResourceDataServiceException;

	/**
	 * Returns FileLink objects segment, where property matches.
	 */
	List<FileLink> getFileLinksByProperty(Segment aSegment, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Returns FileLink objects segment, where property matches, sorted.
	 */
	List<FileLink> getFileLinksByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASResourceDataServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportFileLinksToXML(List<FileLink> listFileLinks)  throws ASResourceDataServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportFileLinksToXML(String[] languages,List<FileLink> listFileLinks) throws ASResourceDataServiceException;

	/**
	 * Create json object list dependencies for this FileLink document.
	 */
	void fetchFileLink(String id, Set<String> addedDocuments, JSONArray data) throws ASResourceDataServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASResourceDataServiceException;
	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	 void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage) throws ASResourceDataServiceException;

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASResourceDataServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASResourceDataServiceException;

	/**
	 * creates an xml element with all contained data but only selected languages in multilingual attributes.
	 */
	XMLNode exportToXML(String[] languages) throws ASResourceDataServiceException;
}
