/**
 ********************************************************************************
 *** ParserUtilService.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.shared.util;

import net.anotheria.anosite.gen.shared.service.BasicService;
import net.anotheria.asg.exception.ASGRuntimeException;
import net.anotheria.util.queue.IQueueWorker;
import net.anotheria.util.queue.QueuedProcessor;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

/**
 * Util service for processing transferred documents.
 */
public class ParserUtilService extends BasicService{

// Generated by: class net.anotheria.asg.generator.apputil.BasicServiceUtilGenerator.generateParsingUtilService

	/**
	 * Constructed instance.
	 */
	private static final ParserUtilService instance = new ParserUtilService();
	/**
	 * Process parse documents in own worker. {@link QueuedProcessor} instance.
	 */
	private final QueuedProcessor<JSONArray> documentExecutor;

	/**
	 * Default constructor.
	 */
	private ParserUtilService() {
		documentExecutor = new QueuedProcessor<>("DocumentTransferExecutorQueuedProcessor", new DocumentExecutor(), 10, log);
		documentExecutor.start();
	}

	/**
	 * Get configured {@link ParserUtilService} instance.
	 * 
	 * @return {@link ParserUtilService} instance
	 */
	public static ParserUtilService getInstance() {
		return instance;
	}

	/**
	 * Add transferred objects to processing queue.
	 * 
	 * @param data {@link JSONArray} of documents
	 * @throws Exception if any errors occurs
	 */
	public void addToQueueParsingDocuments(final JSONArray data) throws Exception {
		documentExecutor.addToQueue(data);
		log.info("Document added to work. Total document size:" + data.length());
	}

	private void executeParsingDocuments (final JSONArray data) throws ASGRuntimeException, JSONException {
		for (int i = 0; i < data.length(); i++) {
			executeParsingDocument(data.getJSONObject(i));
		}
		log.info("Finished parsing documents. Total document size:" + data.length());
	}

	private void executeParsingDocument(final JSONObject data) throws ASGRuntimeException {
		final ModuleName moduleName;
		final DocumentName documentName;
		try {
			moduleName = ModuleName.byValue(data.getString("service"));
			documentName = DocumentName.byValue(data.getString("document"));
		}catch(JSONException e){
			throw new ASGRuntimeException("Occurred problems with getting document metadata from json:", e);
		}
		executeParsingInServiceByName(moduleName, documentName, data);
	}

	protected void executeParsingInServiceByName(final ModuleName moduleName, final DocumentName documentName, final JSONObject dataObject) throws ASGRuntimeException {
		switch (moduleName) {
			case SERVICE_ASGENERICDATA:
				getASGenericDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASCUSTOMDATA:
				getASCustomDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASFEDERATEDDATA:
				getASFederatedDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_IMAGES:
				getImagesService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASLAYOUTDATA:
				getASLayoutDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASSITEDATA:
				getASSiteDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASSITECONFIG:
				getASSiteConfigService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASWEBDATA:
				getASWebDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASRESOURCEDATA:
				getASResourceDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASGENERICACTION:
				getASGenericActionService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASCUSTOMACTION:
				getASCustomActionService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASACTION:
				getASActionService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASWIZARDDATA:
				getASWizardDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASUSERDATA:
				getASUserDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ANOACCESSCONFIGURATION:
				getAnoAccessConfigurationService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ANOACCESSAPPLICATIONDATA:
				getAnoAccessApplicationDataService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASFEATURE:
				getASFeatureService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASEXPERIMENT:
				getASExperimentService().executeParsingForDocument(documentName, dataObject);
				break;
			case SERVICE_ASBRAND:
				getASBrandService().executeParsingForDocument(documentName, dataObject);
				break;
			default:
				log.error("There is no needed module");
				throw new ASGRuntimeException("No such module");
		}
	}

	private class DocumentExecutor implements IQueueWorker<JSONArray> {
		@Override
		public void doWork(JSONArray jsonArray) throws Exception {
			executeParsingDocuments(jsonArray);
		}
	}
}
