/**
 ********************************************************************************
 *** IImagesService.java                                                      ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.images.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.images.data.Image;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IImagesService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all Images objects stored.
	 */
	List<Image> getImages() throws ImagesServiceException;

	/**
	 * Returns all Images objects sorted by given sortType.
	 */
	List<Image> getImages(SortType sortType) throws ImagesServiceException;

	/**
	 * Deletes a Image object by id.
	 */
	void deleteImage(String id) throws ImagesServiceException;

	/**
	 * Deletes a Image object.
	 */
	void deleteImage(Image image) throws ImagesServiceException;

	/**
	 * Deletes multiple Image object.
	 */
	void deleteImages(List<Image> list) throws ImagesServiceException;

	/**
	 * Returns the Image object with the specified id.
	 */
	Image getImage(String id) throws ImagesServiceException;

	/**
	 * Imports a new Image object.
	 * Returns the created version.
	 */
	Image importImage(Image image) throws ImagesServiceException;

	/**
	 * Imports multiple new  Image object.
	 * Returns the created versions.
	 */
	List<Image> importImages(List<Image> list) throws ImagesServiceException;

	/**
	 * Creates a new Image object.
	 * Returns the created version.
	 */
	Image createImage(Image image) throws ImagesServiceException;

	/**
	 * Creates multiple new Image objects.
	 * Returns the created versions.
	 */
	List<Image> createImages(List<Image> list) throws ImagesServiceException;

	/**
	 * Updates a Image object.
	 * Returns the updated version.
	 */
	Image updateImage(Image image) throws ImagesServiceException;

	/**
	 * Updates multiple Image objects.
	 * Returns the updated versions.
	 */
	List<Image> updateImages(List<Image> list) throws ImagesServiceException;

	/**
	 * Returns all Image objects, where property with given name equals object.
	 */
	List<Image> getImagesByProperty(String propertyName, Object value) throws ImagesServiceException;

	/**
	 * Returns all Image objects, where property with given name equals object, sorted.
	 */
	List<Image> getImagesByProperty(String propertyName, Object value, SortType sortType) throws ImagesServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnImages(DocumentQuery query) throws ImagesServiceException;

	/**
	 * Returns all Image objects, where property matches.
	 */
	List<Image> getImagesByProperty(QueryProperty... property) throws ImagesServiceException;

	/**
	 * Returns all Image objects, where property matches, sorted.
	 */
	List<Image> getImagesByProperty(SortType sortType, QueryProperty... property) throws ImagesServiceException;

	/**
	 * Returns all Images count.
	 */
	int getImagesCount() throws ImagesServiceException;

	/**
	 * Returns Images objects segment.
	 */
	List<Image> getImages(Segment aSegment) throws ImagesServiceException;

	/**
	 * Returns Image objects segment, where property matches.
	 */
	List<Image> getImagesByProperty(Segment aSegment, QueryProperty... aProperty) throws ImagesServiceException;

	/**
	 * Returns Image objects segment, where property matches, sorted.
	 */
	List<Image> getImagesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ImagesServiceException;

	/**
	 * In all documents of type Image copies all multilingual fields from sourceLanguage to targetLanguage.
	 */
	void copyMultilingualAttributesInAllImages(String sourceLanguage, String targetLanguage) throws ImagesServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportImagesToXML(List<Image> listImages)  throws ImagesServiceException;
	/**
	 * creates an xml element with selected contained data but only selected languages in multilingual attributes
	 */
	XMLNode exportImagesToXML(String[] languages,List<Image> listImages) throws ImagesServiceException;

	/**
	 * Create json object list dependencies for this Image document.
	 */
	void fetchImage(String id, Set<String> addedDocuments, JSONArray data) throws ImagesServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ImagesServiceException;
	/**
	 * Copies all multilingual fields from sourceLanguage to targetLanguage in all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	 void copyMultilingualAttributesInAllObjects(String sourceLanguage, String targetLanguage) throws ImagesServiceException;

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ImagesServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ImagesServiceException;

	/**
	 * creates an xml element with all contained data but only selected languages in multilingual attributes.
	 */
	XMLNode exportToXML(String[] languages) throws ImagesServiceException;
}
