/**
 ********************************************************************************
 *** BaseWizardHandlerDefAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswizarddata.action;

import net.anotheria.anosite.gen.shared.action.BaseWizardAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aswizarddata.data.WizardHandlerDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseWizardHandlerDefAction extends BaseWizardAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "WizardHandlerDef";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASWizardData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "WizardHandlerDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, WizardHandlerDef wizardhandlerdef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASWizardData.WizardHandlerDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardHandlerDef", wizardhandlerdef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWizardData.WizardHandlerDef", wizardhandlerdef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockWizardHandlerDefs(WizardHandlerDef wizardhandlerdef, HttpServletRequest req) throws Exception{
		if(wizardhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)wizardhandlerdef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASWizardDataService().updateWizardHandlerDef( wizardhandlerdef);
			logger.info("Lock-OPERATION, document with id : ["+wizardhandlerdef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockWizardHandlerDefs(WizardHandlerDef wizardhandlerdef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(wizardhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)wizardhandlerdef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASWizardDataService().updateWizardHandlerDef( wizardhandlerdef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+wizardhandlerdef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+wizardhandlerdef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkWizardHandlerDefs(WizardHandlerDef wizardhandlerdef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = wizardhandlerdef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)wizardhandlerdef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)wizardhandlerdef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockWizardHandlerDefs(wizardhandlerdef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateWizardHandlerDefs(WizardHandlerDef wizardhandlerdef, HttpServletRequest req) throws Exception{
		if(wizardhandlerdef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)wizardhandlerdef, false, getUserId(req));
		}
		if (isTimeoutReached(wizardhandlerdef)) {
			checkWizardHandlerDefs(wizardhandlerdef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(wizardhandlerdef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(WizardHandlerDef wizardhandlerdef){
		if (wizardhandlerdef instanceof LockableObject) {
			LockableObject lock = (LockableObject)wizardhandlerdef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(WizardHandlerDef wizardhandlerdef, HttpServletRequest req){
		if (wizardhandlerdef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)wizardhandlerdef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
