/**
 ********************************************************************************
 *** PagexDocument.java                                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.data.BooleanProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;
import net.anotheria.asg.data.MultilingualObject;

public class PagexDocument extends AbstractASGDocument implements Pagex, IComparable, MultilingualObject{

	public PagexDocument() {
		super("");
	}

	public PagexDocument(String id){
		super(id);
	}

	public PagexDocument(PagexDocument toClone){
		super(toClone);
	}

	PagexDocument(PagexBuilder builder){
		super("");
		setName(builder.name);
		setLocalizedName(builder.localizedName);
		setTitle(builder.title);
		setKeywords(builder.keywords);
		setDescription(builder.description);
		setMediaLinks(builder.mediaLinks);
		setScripts(builder.scripts);
		setAttributes(builder.attributes);
		setC1(builder.c1);
		setC2(builder.c2);
		setC3(builder.c3);
		setHeader(builder.header);
		setFooter(builder.footer);
		setLocalizations(builder.localizations);
		setHttpsonly(builder.httpsonly);
		setTemplate(builder.template);
		setAccessOperation(builder.accessOperation);
		setFeature(builder.feature);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getLocalizedNameEN(){
		return getString(PROP_LOCALIZED_NAME_EN);
	}

	public String getLocalizedName(){
		return getString("localizedName_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setLocalizedNameEN(String value){
		setString(PROP_LOCALIZED_NAME_EN, value);
	}

	public void setLocalizedName(String value){
		setString(("localizedName_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getTitleEN(){
		return getString(PROP_TITLE_EN);
	}

	public String getTitle(){
		return getString("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setTitleEN(String value){
		setString(PROP_TITLE_EN, value);
	}

	public void setTitle(String value){
		setString(("title_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getKeywordsEN(){
		return getString(PROP_KEYWORDS_EN);
	}

	public String getKeywords(){
		return getString("keywords_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setKeywordsEN(String value){
		setString(PROP_KEYWORDS_EN, value);
	}

	public void setKeywords(String value){
		setString(("keywords_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public String getDescriptionEN(){
		return getString(PROP_DESCRIPTION_EN);
	}

	public String getDescription(){
		return getString("description_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage()));
	}


	public void setDescriptionEN(String value){
		setString(PROP_DESCRIPTION_EN, value);
	}

	public void setDescription(String value){
		setString(("description_"+(isMultilingualDisabledInstance() ? ContextManager.getCallContext().getDefaultLanguage() : ContextManager.getCallContext().getCurrentLanguage())), value);
	}


	public List<String> getMediaLinks(){
		return copyToStringList(getList(PROP_MEDIA_LINKS));
	}

	public void setMediaLinks(List<String> value){
		setList(PROP_MEDIA_LINKS, copyFromStringList(value));
	}

	public List<String> getScripts(){
		return copyToStringList(getList(PROP_SCRIPTS));
	}

	public void setScripts(List<String> value){
		setList(PROP_SCRIPTS, copyFromStringList(value));
	}

	public List<String> getAttributes(){
		return copyToStringList(getList(PROP_ATTRIBUTES));
	}

	public void setAttributes(List<String> value){
		setList(PROP_ATTRIBUTES, copyFromStringList(value));
	}

	public List<String> getC1(){
		return copyToStringList(getList(PROP_C1));
	}

	public void setC1(List<String> value){
		setList(PROP_C1, copyFromStringList(value));
	}

	public List<String> getC2(){
		return copyToStringList(getList(PROP_C2));
	}

	public void setC2(List<String> value){
		setList(PROP_C2, copyFromStringList(value));
	}

	public List<String> getC3(){
		return copyToStringList(getList(PROP_C3));
	}

	public void setC3(List<String> value){
		setList(PROP_C3, copyFromStringList(value));
	}

	public List<String> getHeader(){
		return copyToStringList(getList(PROP_HEADER));
	}

	public void setHeader(List<String> value){
		setList(PROP_HEADER, copyFromStringList(value));
	}

	public List<String> getFooter(){
		return copyToStringList(getList(PROP_FOOTER));
	}

	public void setFooter(List<String> value){
		setList(PROP_FOOTER, copyFromStringList(value));
	}

	public List<String> getLocalizations(){
		return copyToStringList(getList(PROP_LOCALIZATIONS));
	}

	public void setLocalizations(List<String> value){
		setList(PROP_LOCALIZATIONS, copyFromStringList(value));
	}

	public boolean getHttpsonly(){
		return getBoolean(PROP_HTTPSONLY);
	}

	public void setHttpsonly(boolean value){
		setBoolean(PROP_HTTPSONLY, value);
	}

	public String getTemplate(){
		return getString(LINK_PROP_TEMPLATE);
	}

	public void setTemplate(String value){
		setString(LINK_PROP_TEMPLATE, value);
	}

	public String getAccessOperation(){
		return getString(LINK_PROP_ACCESS_OPERATION);
	}

	public void setAccessOperation(String value){
		setString(LINK_PROP_ACCESS_OPERATION, value);
	}

	public String getFeature(){
		return getString(LINK_PROP_FEATURE);
	}

	public void setFeature(String value){
		setString(LINK_PROP_FEATURE, value);
	}


	public String toString(){
		String ret = "Pagex ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "localizedName: "+getLocalizedName();
		ret += ", ";
		ret += "title: "+getTitle();
		ret += ", ";
		ret += "keywords: "+getKeywords();
		ret += ", ";
		ret += "description: "+getDescription();
		ret += ", ";
		ret += "mediaLinks: "+getMediaLinks();
		ret += ", ";
		ret += "scripts: "+getScripts();
		ret += ", ";
		ret += "attributes: "+getAttributes();
		ret += ", ";
		ret += "c1: "+getC1();
		ret += ", ";
		ret += "c2: "+getC2();
		ret += ", ";
		ret += "c3: "+getC3();
		ret += ", ";
		ret += "header: "+getHeader();
		ret += ", ";
		ret += "footer: "+getFooter();
		ret += ", ";
		ret += "localizations: "+getLocalizations();
		ret += ", ";
		ret += "httpsonly: "+getHttpsonly();
		return ret;
	}

	public int getMediaLinksSize(){
		return getList(PROP_MEDIA_LINKS).size();
	}

	public void addMediaLinksElement(String mediaLink){
		getListPropertyAnyCase(PROP_MEDIA_LINKS).add(new StringProperty("" + mediaLink, mediaLink));
	} //method

	public void removeMediaLinksElement(int index){
		getListProperty(PROP_MEDIA_LINKS).remove(index);
	} //method

	public void swapMediaLinksElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).getString();
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_MEDIA_LINKS).get(index2)).setString(tmp1);
	} //method

	public String getMediaLinksElement(int index){
		StringProperty p = (StringProperty)getList(PROP_MEDIA_LINKS).get(index);
		return p.getString();
	} //method

	public int getScriptsSize(){
		return getList(PROP_SCRIPTS).size();
	}

	public void addScriptsElement(String script){
		getListPropertyAnyCase(PROP_SCRIPTS).add(new StringProperty("" + script, script));
	} //method

	public void removeScriptsElement(int index){
		getListProperty(PROP_SCRIPTS).remove(index);
	} //method

	public void swapScriptsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_SCRIPTS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_SCRIPTS).get(index2)).getString();
		((StringProperty)getList(PROP_SCRIPTS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_SCRIPTS).get(index2)).setString(tmp1);
	} //method

	public String getScriptsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_SCRIPTS).get(index);
		return p.getString();
	} //method

	public int getAttributesSize(){
		return getList(PROP_ATTRIBUTES).size();
	}

	public void addAttributesElement(String attribute){
		getListPropertyAnyCase(PROP_ATTRIBUTES).add(new StringProperty("" + attribute, attribute));
	} //method

	public void removeAttributesElement(int index){
		getListProperty(PROP_ATTRIBUTES).remove(index);
	} //method

	public void swapAttributesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).getString();
		((StringProperty)getList(PROP_ATTRIBUTES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_ATTRIBUTES).get(index2)).setString(tmp1);
	} //method

	public String getAttributesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_ATTRIBUTES).get(index);
		return p.getString();
	} //method

	public int getC1Size(){
		return getList(PROP_C1).size();
	}

	public void addC1Element(String box){
		getListPropertyAnyCase(PROP_C1).add(new StringProperty("" + box, box));
	} //method

	public void removeC1Element(int index){
		getListProperty(PROP_C1).remove(index);
	} //method

	public void swapC1Element(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_C1).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_C1).get(index2)).getString();
		((StringProperty)getList(PROP_C1).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_C1).get(index2)).setString(tmp1);
	} //method

	public String getC1Element(int index){
		StringProperty p = (StringProperty)getList(PROP_C1).get(index);
		return p.getString();
	} //method

	public int getC2Size(){
		return getList(PROP_C2).size();
	}

	public void addC2Element(String box){
		getListPropertyAnyCase(PROP_C2).add(new StringProperty("" + box, box));
	} //method

	public void removeC2Element(int index){
		getListProperty(PROP_C2).remove(index);
	} //method

	public void swapC2Element(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_C2).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_C2).get(index2)).getString();
		((StringProperty)getList(PROP_C2).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_C2).get(index2)).setString(tmp1);
	} //method

	public String getC2Element(int index){
		StringProperty p = (StringProperty)getList(PROP_C2).get(index);
		return p.getString();
	} //method

	public int getC3Size(){
		return getList(PROP_C3).size();
	}

	public void addC3Element(String box){
		getListPropertyAnyCase(PROP_C3).add(new StringProperty("" + box, box));
	} //method

	public void removeC3Element(int index){
		getListProperty(PROP_C3).remove(index);
	} //method

	public void swapC3Element(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_C3).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_C3).get(index2)).getString();
		((StringProperty)getList(PROP_C3).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_C3).get(index2)).setString(tmp1);
	} //method

	public String getC3Element(int index){
		StringProperty p = (StringProperty)getList(PROP_C3).get(index);
		return p.getString();
	} //method

	public int getHeaderSize(){
		return getList(PROP_HEADER).size();
	}

	public void addHeaderElement(String box){
		getListPropertyAnyCase(PROP_HEADER).add(new StringProperty("" + box, box));
	} //method

	public void removeHeaderElement(int index){
		getListProperty(PROP_HEADER).remove(index);
	} //method

	public void swapHeaderElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_HEADER).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_HEADER).get(index2)).getString();
		((StringProperty)getList(PROP_HEADER).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_HEADER).get(index2)).setString(tmp1);
	} //method

	public String getHeaderElement(int index){
		StringProperty p = (StringProperty)getList(PROP_HEADER).get(index);
		return p.getString();
	} //method

	public int getFooterSize(){
		return getList(PROP_FOOTER).size();
	}

	public void addFooterElement(String box){
		getListPropertyAnyCase(PROP_FOOTER).add(new StringProperty("" + box, box));
	} //method

	public void removeFooterElement(int index){
		getListProperty(PROP_FOOTER).remove(index);
	} //method

	public void swapFooterElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_FOOTER).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_FOOTER).get(index2)).getString();
		((StringProperty)getList(PROP_FOOTER).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_FOOTER).get(index2)).setString(tmp1);
	} //method

	public String getFooterElement(int index){
		StringProperty p = (StringProperty)getList(PROP_FOOTER).get(index);
		return p.getString();
	} //method

	public int getLocalizationsSize(){
		return getList(PROP_LOCALIZATIONS).size();
	}

	public void addLocalizationsElement(String localization){
		getListPropertyAnyCase(PROP_LOCALIZATIONS).add(new StringProperty("" + localization, localization));
	} //method

	public void removeLocalizationsElement(int index){
		getListProperty(PROP_LOCALIZATIONS).remove(index);
	} //method

	public void swapLocalizationsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).getString();
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_LOCALIZATIONS).get(index2)).setString(tmp1);
	} //method

	public String getLocalizationsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_LOCALIZATIONS).get(index);
		return p.getString();
	} //method


	public int compareTo(Pagex comparable){
		return compareTo(comparable, PagexSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		PagexDocument anotherDoc = (PagexDocument) anotherComparable;
		switch(method){
			case PagexSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case PagexSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case PagexSortType.SORT_BY_LOCALIZEDNAME:
				return BasicComparable.compareString(getLocalizedName(), anotherDoc.getLocalizedName());
			case PagexSortType.SORT_BY_TITLE:
				return BasicComparable.compareString(getTitle(), anotherDoc.getTitle());
			case PagexSortType.SORT_BY_KEYWORDS:
				return BasicComparable.compareString(getKeywords(), anotherDoc.getKeywords());
			case PagexSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			case PagexSortType.SORT_BY_HTTPSONLY:
				return BasicComparable.compareBoolean(getHttpsonly(), anotherDoc.getHttpsonly());
			case PagexSortType.SORT_BY_TEMPLATE:
				return BasicComparable.compareString(getTemplate(), anotherDoc.getTemplate());
			case PagexSortType.SORT_BY_ACCESSOPERATION:
				return BasicComparable.compareString(getAccessOperation(), anotherDoc.getAccessOperation());
			case PagexSortType.SORT_BY_FEATURE:
				return BasicComparable.compareString(getFeature(), anotherDoc.getFeature());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Pagex";
	}

	public String getDefinedParentName(){
		return "ASWebData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getLocalizedNameEN());
		footprint.append(getTitleEN());
		footprint.append(getKeywordsEN());
		footprint.append(getDescriptionEN());
		footprint.append(getMediaLinks());
		footprint.append(getScripts());
		footprint.append(getAttributes());
		footprint.append(getC1());
		footprint.append(getC2());
		footprint.append(getC3());
		footprint.append(getHeader());
		footprint.append(getFooter());
		footprint.append(getLocalizations());
		footprint.append(getHttpsonly());
		footprint.append(getTemplate());
		footprint.append(getAccessOperation());
		footprint.append(getFeature());
		return MD5Util.getMD5Hash(footprint);
	}
	public void copyLANG2LANG(String sourceLanguage, String destLanguage){
	}


	public boolean isMultilingualDisabledInstance(){
		try{
			return ((BooleanProperty)getInternalProperty(INT_PROPERTY_MULTILINGUAL_DISABLED)).getboolean();
		}catch(NoSuchPropertyException e){
			return false;
		}
	}

	public void setMultilingualDisabledInstance(boolean value){
		setInternalProperty(new BooleanProperty(INT_PROPERTY_MULTILINGUAL_DISABLED, value));
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof PagexDocument) && ((PagexDocument)o).getId().equals(getId()));
	}
}
