/**
 ********************************************************************************
 *** AttributeDocument.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import java.util.List;
import net.anotheria.anodoc.data.StringProperty;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class AttributeDocument extends AbstractASGDocument implements Attribute, IComparable{

	public AttributeDocument() {
		super("");
	}

	public AttributeDocument(String id){
		super(id);
	}

	public AttributeDocument(AttributeDocument toClone){
		super(toClone);
	}

	AttributeDocument(AttributeBuilder builder){
		super("");
		setName(builder.name);
		setKey(builder.key);
		setValue(builder.value);
		setSubattributes(builder.subattributes);
		setGuards(builder.guards);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getKey(){
		return getString(PROP_KEY);
	}

	public void setKey(String value){
		setString(PROP_KEY, value);
	}

	public String getValue(){
		return getString(PROP_VALUE);
	}

	public void setValue(String value){
		setString(PROP_VALUE, value);
	}

	public List<String> getSubattributes(){
		return copyToStringList(getList(PROP_SUBATTRIBUTES));
	}

	public void setSubattributes(List<String> value){
		setList(PROP_SUBATTRIBUTES, copyFromStringList(value));
	}

	public List<String> getGuards(){
		return copyToStringList(getList(PROP_GUARDS));
	}

	public void setGuards(List<String> value){
		setList(PROP_GUARDS, copyFromStringList(value));
	}


	public String toString(){
		String ret = "Attribute ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "key: "+getKey();
		ret += ", ";
		ret += "value: "+getValue();
		ret += ", ";
		ret += "subattributes: "+getSubattributes();
		ret += ", ";
		ret += "guards: "+getGuards();
		return ret;
	}

	public int getSubattributesSize(){
		return getList(PROP_SUBATTRIBUTES).size();
	}

	public void addSubattributesElement(String type){
		getListPropertyAnyCase(PROP_SUBATTRIBUTES).add(new StringProperty("" + type, type));
	} //method

	public void removeSubattributesElement(int index){
		getListProperty(PROP_SUBATTRIBUTES).remove(index);
	} //method

	public void swapSubattributesElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_SUBATTRIBUTES).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_SUBATTRIBUTES).get(index2)).getString();
		((StringProperty)getList(PROP_SUBATTRIBUTES).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_SUBATTRIBUTES).get(index2)).setString(tmp1);
	} //method

	public String getSubattributesElement(int index){
		StringProperty p = (StringProperty)getList(PROP_SUBATTRIBUTES).get(index);
		return p.getString();
	} //method

	public int getGuardsSize(){
		return getList(PROP_GUARDS).size();
	}

	public void addGuardsElement(String guard){
		getListPropertyAnyCase(PROP_GUARDS).add(new StringProperty("" + guard, guard));
	} //method

	public void removeGuardsElement(int index){
		getListProperty(PROP_GUARDS).remove(index);
	} //method

	public void swapGuardsElement(int index1, int index2){
		String tmp1, tmp2;
		tmp1 = ((StringProperty)getList(PROP_GUARDS).get(index1)).getString();
		tmp2 = ((StringProperty)getList(PROP_GUARDS).get(index2)).getString();
		((StringProperty)getList(PROP_GUARDS).get(index1)).setString(tmp2);
		((StringProperty)getList(PROP_GUARDS).get(index2)).setString(tmp1);
	} //method

	public String getGuardsElement(int index){
		StringProperty p = (StringProperty)getList(PROP_GUARDS).get(index);
		return p.getString();
	} //method


	public int compareTo(Attribute comparable){
		return compareTo(comparable, AttributeSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		AttributeDocument anotherDoc = (AttributeDocument) anotherComparable;
		switch(method){
			case AttributeSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case AttributeSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case AttributeSortType.SORT_BY_KEY:
				return BasicComparable.compareString(getKey(), anotherDoc.getKey());
			case AttributeSortType.SORT_BY_VALUE:
				return BasicComparable.compareString(getValue(), anotherDoc.getValue());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "Attribute";
	}

	public String getDefinedParentName(){
		return "ASWebData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getKey());
		footprint.append(getValue());
		footprint.append(getSubattributes());
		footprint.append(getGuards());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof AttributeDocument) && ((AttributeDocument)o).getId().equals(getId()));
	}
}
