/**
 ********************************************************************************
 *** MultiOpBoxsLocalizationsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aswebdata.data.BoxFactory;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.anosite.gen.aswebdata.bean.LocalizationsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.aswebdata.bean.LocalizationsQuickAddFB;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle;
import net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundleSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBoxsLocalizationsAction extends BaseBoxAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("aswebdataBoxLocalizationsShow"))
			return aswebdataBoxLocalizationsShow(mapping, req, res);
		if (path.equals("aswebdataBoxLocalizationsAdd"))
			return aswebdataBoxLocalizationsAdd(mapping, req, res);
		if (path.equals("aswebdataBoxLocalizationsDelete"))
			return aswebdataBoxLocalizationsDelete(mapping, req, res);
		if (path.equals("aswebdataBoxLocalizationsMove"))
			return aswebdataBoxLocalizationsMove(mapping, req, res);
		if (path.equals("aswebdataBoxLocalizationsQuickAdd"))
			return aswebdataBoxLocalizationsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand aswebdataBoxLocalizationsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box box = getASWebDataService().getBox(id);
		addBeanToRequest(req, "ownerId", id);
		checkBoxs(box, req);

		LocalizationsElementFB form = new LocalizationsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxLocalizationsElementForm", form);

		LocalizationsQuickAddFB quickAddForm = new LocalizationsQuickAddFB() ;
		quickAddForm.setOwnerId(box.getId());
		addBeanToRequest(req, "aswebdataBoxLocalizationsQuickAddForm", quickAddForm);


		//link localization to ASResourceData.LocalizationBundle
		List<LocalizationBundle> localizationbundles = getASResourceDataService().getLocalizationBundles(new LocalizationBundleSortType(LocalizationBundleSortType.SORT_BY_NAME));
		List<LabelValueBean> localizationbundlesValues = new ArrayList<LabelValueBean>(localizationbundles.size());
		for (int i=0; i<localizationbundles.size(); i++){
			net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle tmp_localizationbundle = (net.anotheria.anosite.gen.asresourcedata.data.LocalizationBundle) localizationbundles.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_localizationbundle.getId(), tmp_localizationbundle.getName()+" ["+tmp_localizationbundle.getId()+"]" );
			localizationbundlesValues.add(bean);
		}
		addBeanToRequest(req, "localizationValuesCollection", localizationbundlesValues);
		// generate list ...
		int size = box.getLocalizationsSize();
		List<LocalizationsElementFB> beans = new ArrayList<LocalizationsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = box.getLocalizationsElement(i);
			LocalizationsElementFB bean = new LocalizationsElementFB();
			bean.setOwnerId(box.getId());
			bean.setPosition(i);
			bean.setLocalization(value);
			try{
				LocalizationBundle tmp_localizationbundle = getASResourceDataService().getLocalizationBundle(value);
				bean.setDescription(tmp_localizationbundle.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand aswebdataBoxLocalizationsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Box boxCurr = getASWebDataService().getBox(id);
		canUpdateBoxs(boxCurr, req);
		checkBoxs(boxCurr, req);
		int position = getIntParameter(req, "pPosition");
		Box box = getASWebDataService().getBox(id);
		box.removeLocalizationsElement(position);
		getASWebDataService().updateBox(box);
		return aswebdataBoxLocalizationsShow(mapping, req, res);
	}

	public ActionCommand aswebdataBoxLocalizationsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Box box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(box, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(box, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(box, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(box, position);
		return aswebdataBoxLocalizationsShow(mapping, req, res);
	}

	private void moveUp(Box box, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		box.swapLocalizationsElement(position, position-1);
		getASWebDataService().updateBox(box);
	}

	private void moveTop(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		box.setLocalizations(targetList);
		getASWebDataService().updateBox(box);
	}

	private void moveDown(Box box, int position) throws ASGRuntimeException {
		if (position<box.getLocalizationsSize()-1){
			box.swapLocalizationsElement(position, position+1);
			getASWebDataService().updateBox(box);
		}
	}

	private void moveBottom(Box box, int position) throws ASGRuntimeException {
		List<String> targetList = box.getLocalizations();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		box.setLocalizations(targetList);
		getASWebDataService().updateBox(box);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand aswebdataBoxLocalizationsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsElementFB form = new LocalizationsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		box.addLocalizationsElement(form.getLocalization());
		getASWebDataService().updateBox(box);
		return aswebdataBoxLocalizationsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand aswebdataBoxLocalizationsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		LocalizationsQuickAddFB form = new LocalizationsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Box box;
		box = getASWebDataService().getBox(id);
		canUpdateBoxs(box, req);
		checkBoxs(box, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				box.addLocalizationsElement(""+i);
			}
		}
		getASWebDataService().updateBox(box);
		return aswebdataBoxLocalizationsShow(mapping, req, res);
	}

}
