/**
 ********************************************************************************
 *** BaseAttributeAction.java                                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aswebdata.action;

import net.anotheria.anosite.gen.shared.action.BaseContentAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseAttributeAction extends BaseContentAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Attribute";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASWebData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Attribute";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Attribute attribute) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASWebData.Attribute").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Attribute", attribute, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Attribute", attribute, "key");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.key", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Attribute", attribute, "value");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.value", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Attribute", attribute, "subattributes");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.subattributes", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASWebData.Attribute", attribute, "guards");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.guards", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockAttributes(Attribute attribute, HttpServletRequest req) throws Exception{
		if(attribute instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)attribute;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASWebDataService().updateAttribute( attribute);
			logger.info("Lock-OPERATION, document with id : ["+attribute.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockAttributes(Attribute attribute, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(attribute instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)attribute;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASWebDataService().updateAttribute( attribute);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+attribute.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+attribute.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkAttributes(Attribute attribute, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = attribute instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)attribute).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)attribute).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockAttributes(attribute, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateAttributes(Attribute attribute, HttpServletRequest req) throws Exception{
		if(attribute instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)attribute, false, getUserId(req));
		}
		if (isTimeoutReached(attribute)) {
			checkAttributes(attribute, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(attribute, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Attribute attribute){
		if (attribute instanceof LockableObject) {
			LockableObject lock = (LockableObject)attribute;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Attribute attribute, HttpServletRequest req){
		if (attribute instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)attribute;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
