/**
 ********************************************************************************
 *** TransferEntryPointAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.io.IOException;
import java.io.PrintWriter;
import net.anotheria.anosite.gen.assitedata.service.ASSiteDataServiceException;
import net.anotheria.anosite.config.DocumentTransferConfig;
import org.configureme.ConfigurationManager;
import org.json.JSONException;
import net.anotheria.maf.json.JSONResponse;
import org.codehaus.jettison.json.JSONArray;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import net.anotheria.anosite.util.staticutil.JerseyClientUtil;

public class TransferEntryPointAction extends BaseEntryPointAction{


	private static final int STATUS_OK = 201;
	private static final String ERROR = "error";

	private DocumentTransferConfig config = DocumentTransferConfig.getInstance();

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateTransferActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{

		JSONResponse response = new JSONResponse();
		if (ConfigurationManager.INSTANCE.getDefaultEnvironment().expandedStringForm().equals("prod")) {
			response.addError(ERROR, "Environment is prod");
			writeTextToResponse(res, response);
			return null;
		}

		String id = getStringParameter(req, PARAM_ID);
		JSONArray data = new JSONArray();
		try {
			getASSiteDataService().fetchEntryPoint(id, new HashSet<String>(), data);
		}catch(ASSiteDataServiceException e){
			response.addError(ERROR, "Problem occurred when fetching info about documents -" + e.getMessage());
			writeTextToResponse(res, response);
			return null;
		}

		Client client = JerseyClientUtil.getClientInstance();
		for (String domain :config.getDomains()) {
			Response clientResponse = client.target(domain + "/api/entrypoint")
			 		.request(MediaType.APPLICATION_JSON)
			 		.post(Entity.entity(data.toString(), MediaType.APPLICATION_JSON));

			if (clientResponse.getStatus() != STATUS_OK) {
				clientResponse.close();
				response.addError(ERROR, "Couldn't save transferred objects, status expected 201, got status - " + clientResponse.getStatus());
				writeTextToResponse(res, response);
			}

			clientResponse.close();
		}
		return null;
	}

	private void writeTextToResponse(final HttpServletResponse res, final JSONResponse jsonResponse) throws IOException, JSONException {
		res.setCharacterEncoding("UTF-8");
		res.setContentType("application/json");
		PrintWriter writer = res.getWriter();
		writer.write(jsonResponse.toString());
		writer.flush();
	}
}
