/**
 ********************************************************************************
 *** MultiOpPageTemplatesScriptsAction.java                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.assitedata.data.PageTemplateFactory;
import net.anotheria.anosite.gen.assitedata.data.PageTemplate;
import net.anotheria.anosite.gen.assitedata.bean.ScriptsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.assitedata.bean.ScriptsQuickAddFB;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.data.ScriptSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpPageTemplatesScriptsAction extends BasePageTemplateAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataPageTemplateScriptsShow"))
			return assitedataPageTemplateScriptsShow(mapping, req, res);
		if (path.equals("assitedataPageTemplateScriptsAdd"))
			return assitedataPageTemplateScriptsAdd(mapping, req, res);
		if (path.equals("assitedataPageTemplateScriptsDelete"))
			return assitedataPageTemplateScriptsDelete(mapping, req, res);
		if (path.equals("assitedataPageTemplateScriptsMove"))
			return assitedataPageTemplateScriptsMove(mapping, req, res);
		if (path.equals("assitedataPageTemplateScriptsQuickAdd"))
			return assitedataPageTemplateScriptsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand assitedataPageTemplateScriptsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		addBeanToRequest(req, "ownerId", id);
		checkPageTemplates(pagetemplate, req);

		ScriptsElementFB form = new ScriptsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(pagetemplate.getId());
		addBeanToRequest(req, "assitedataPageTemplateScriptsElementForm", form);

		ScriptsQuickAddFB quickAddForm = new ScriptsQuickAddFB() ;
		quickAddForm.setOwnerId(pagetemplate.getId());
		addBeanToRequest(req, "assitedataPageTemplateScriptsQuickAddForm", quickAddForm);


		//link scripts to ASSiteData.Script
		List<Script> scripts = getASSiteDataService().getScripts(new ScriptSortType(ScriptSortType.SORT_BY_NAME));
		List<LabelValueBean> scriptsValues = new ArrayList<LabelValueBean>(scripts.size());
		for (int i=0; i<scripts.size(); i++){
			net.anotheria.anosite.gen.assitedata.data.Script tmp_script = (net.anotheria.anosite.gen.assitedata.data.Script) scripts.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_script.getId(), tmp_script.getName()+" ["+tmp_script.getId()+"]" );
			scriptsValues.add(bean);
		}
		addBeanToRequest(req, "scriptsValuesCollection", scriptsValues);
		// generate list ...
		int size = pagetemplate.getScriptsSize();
		List<ScriptsElementFB> beans = new ArrayList<ScriptsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = pagetemplate.getScriptsElement(i);
			ScriptsElementFB bean = new ScriptsElementFB();
			bean.setOwnerId(pagetemplate.getId());
			bean.setPosition(i);
			bean.setScripts(value);
			try{
				Script tmp_script = getASSiteDataService().getScript(value);
				bean.setDescription(tmp_script.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand assitedataPageTemplateScriptsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		PageTemplate pagetemplateCurr = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplateCurr, req);
		checkPageTemplates(pagetemplateCurr, req);
		int position = getIntParameter(req, "pPosition");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		pagetemplate.removeScriptsElement(position);
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateScriptsShow(mapping, req, res);
	}

	public ActionCommand assitedataPageTemplateScriptsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		PageTemplate pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(pagetemplate, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(pagetemplate, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(pagetemplate, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(pagetemplate, position);
		return assitedataPageTemplateScriptsShow(mapping, req, res);
	}

	private void moveUp(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		pagetemplate.swapScriptsElement(position, position-1);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	private void moveTop(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pagetemplate.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		pagetemplate.setScripts(targetList);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	private void moveDown(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		if (position<pagetemplate.getScriptsSize()-1){
			pagetemplate.swapScriptsElement(position, position+1);
			getASSiteDataService().updatePageTemplate(pagetemplate);
		}
	}

	private void moveBottom(PageTemplate pagetemplate, int position) throws ASGRuntimeException {
		List<String> targetList = pagetemplate.getScripts();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		pagetemplate.setScripts(targetList);
		getASSiteDataService().updatePageTemplate(pagetemplate);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand assitedataPageTemplateScriptsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsElementFB form = new ScriptsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PageTemplate pagetemplate;
		pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		pagetemplate.addScriptsElement(form.getScripts());
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateScriptsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand assitedataPageTemplateScriptsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		ScriptsQuickAddFB form = new ScriptsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		PageTemplate pagetemplate;
		pagetemplate = getASSiteDataService().getPageTemplate(id);
		canUpdatePageTemplates(pagetemplate, req);
		checkPageTemplates(pagetemplate, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				pagetemplate.addScriptsElement(""+i);
			}
		}
		getASSiteDataService().updatePageTemplate(pagetemplate);
		return assitedataPageTemplateScriptsShow(mapping, req, res);
	}

}
