/**
 ********************************************************************************
 *** MultiOpDialogScriptsAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.ScriptFactory;
import net.anotheria.anosite.gen.assitedata.data.Script;
import net.anotheria.anosite.gen.assitedata.bean.EditScriptFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogScriptsAction extends BaseScriptAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataScriptDelete"))
			return assitedataScriptDelete(mapping, req, res);
		if (path.equals("assitedataScriptDuplicate"))
			return assitedataScriptDuplicate(mapping, req, res);
		if (path.equals("assitedataScriptUpdate"))
			return assitedataScriptUpdate(mapping, req, res);
		if (path.equals("assitedataScriptClose"))
			return assitedataScriptClose(mapping, req, res);
		if (path.equals("assitedataScriptLock"))
			return assitedataScriptLock(mapping, req, res);
		if (path.equals("assitedataScriptUnLock"))
			return assitedataScriptUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataScriptDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Script scriptCurr = getASSiteDataService().getScript(id);
			if (scriptCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)scriptCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteScript(id);
		}
		res.sendRedirect("assitedataScriptShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataScriptDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Script scriptSrc = getASSiteDataService().getScript(id);
		Script scriptDest = ScriptFactory.createScript(scriptSrc);



		Script scriptCreated = getASSiteDataService().createScript(scriptDest);
		res.sendRedirect("assitedataScriptEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+scriptCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataScriptUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditScriptFB form = new EditScriptFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Script script = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		script = (Script)getASSiteDataService().getScript(form.getId()).clone();
	}else{
		script = ScriptFactory.createScript();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	script.setName(form.getName());
	script.setFile(form.getFile());
	script.setLink(form.getLink());
	script.setContent(form.getContent());
	script.setBrowserFiltering(form.getBrowserFiltering());
	// skipped container guards

	Script updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createScript(script);
	}else{
		canUpdateScripts(script, req);
		checkScripts(script, req);
		updatedCopy = getASSiteDataService().updateScript(script);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataScriptEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(script, req);
		res.sendRedirect("assitedataScriptShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Script script, HttpServletRequest req) throws Exception{
	if(((LockableObject)script).isLocked())
		unLockScripts(script, req, false);
}

public ActionCommand assitedataScriptLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Script scriptCurr = id != null && !id.equals("") ? getASSiteDataService().getScript(id) : null;
	if(scriptCurr != null && scriptCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)scriptCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockScripts(scriptCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, scriptCurr));
	return null;
}

public ActionCommand assitedataScriptUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Script scriptCurr = id != null && !id.equals("") ? getASSiteDataService().getScript(id) : null;
	if(scriptCurr != null && scriptCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)scriptCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockScripts(scriptCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, scriptCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Script item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataScriptShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataScriptEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataScriptShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataScriptClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Script scriptCurr = id != null && !id.equals("") ? getASSiteDataService().getScript(id) : null;
	if(scriptCurr != null && scriptCurr instanceof LockableObject && ((LockableObject)scriptCurr).isLocked()) 
		unLockScripts(scriptCurr, req, false);
	res.sendRedirect("assitedataScriptShow?ts="+System.currentTimeMillis());
	return null;
}

}
