/**
 ********************************************************************************
 *** MultiOpDialogEntryPointsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assitedata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.assitedata.data.EntryPointFactory;
import net.anotheria.anosite.gen.assitedata.data.EntryPoint;
import net.anotheria.anosite.gen.assitedata.bean.EditEntryPointFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogEntryPointsAction extends BaseEntryPointAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("assitedataEntryPointDelete"))
			return assitedataEntryPointDelete(mapping, req, res);
		if (path.equals("assitedataEntryPointDuplicate"))
			return assitedataEntryPointDuplicate(mapping, req, res);
		if (path.equals("assitedataEntryPointUpdate"))
			return assitedataEntryPointUpdate(mapping, req, res);
		if (path.equals("assitedataEntryPointClose"))
			return assitedataEntryPointClose(mapping, req, res);
		if (path.equals("assitedataEntryPointLock"))
			return assitedataEntryPointLock(mapping, req, res);
		if (path.equals("assitedataEntryPointUnLock"))
			return assitedataEntryPointUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand assitedataEntryPointDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			EntryPoint entrypointCurr = getASSiteDataService().getEntryPoint(id);
			if (entrypointCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)entrypointCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASSiteDataService().deleteEntryPoint(id);
		}
		res.sendRedirect("assitedataEntryPointShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand assitedataEntryPointDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EntryPoint entrypointSrc = getASSiteDataService().getEntryPoint(id);
		EntryPoint entrypointDest = EntryPointFactory.createEntryPoint(entrypointSrc);



		EntryPoint entrypointCreated = getASSiteDataService().createEntryPoint(entrypointDest);
		res.sendRedirect("assitedataEntryPointEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+entrypointCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand assitedataEntryPointUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditEntryPointFB form = new EditEntryPointFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		EntryPoint entrypoint = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		entrypoint = (EntryPoint)getASSiteDataService().getEntryPoint(form.getId()).clone();
	}else{
		entrypoint = EntryPointFactory.createEntryPoint();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	entrypoint.setName(form.getName());
	entrypoint.setStartPage(form.getStartPage());
	entrypoint.setStartSite(form.getStartSite());
	entrypoint.setType(form.getType());
	entrypoint.setDefaultEntry(form.isDefaultEntry());
	// skipped container domains

	EntryPoint updatedCopy = null;
	if (create){
		updatedCopy = getASSiteDataService().createEntryPoint(entrypoint);
	}else{
		canUpdateEntryPoints(entrypoint, req);
		checkEntryPoints(entrypoint, req);
		updatedCopy = getASSiteDataService().updateEntryPoint(entrypoint);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("assitedataEntryPointEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(entrypoint, req);
		res.sendRedirect("assitedataEntryPointShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(EntryPoint entrypoint, HttpServletRequest req) throws Exception{
	if(((LockableObject)entrypoint).isLocked())
		unLockEntryPoints(entrypoint, req, false);
}

public ActionCommand assitedataEntryPointLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	EntryPoint entrypointCurr = id != null && !id.equals("") ? getASSiteDataService().getEntryPoint(id) : null;
	if(entrypointCurr != null && entrypointCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)entrypointCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockEntryPoints(entrypointCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, entrypointCurr));
	return null;
}

public ActionCommand assitedataEntryPointUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	EntryPoint entrypointCurr = id != null && !id.equals("") ? getASSiteDataService().getEntryPoint(id) : null;
	if(entrypointCurr != null && entrypointCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)entrypointCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockEntryPoints(entrypointCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, entrypointCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, EntryPoint item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "assitedataEntryPointShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "assitedataEntryPointEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "assitedataEntryPointShow?ts="+System.currentTimeMillis();
}

public ActionCommand assitedataEntryPointClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	EntryPoint entrypointCurr = id != null && !id.equals("") ? getASSiteDataService().getEntryPoint(id) : null;
	if(entrypointCurr != null && entrypointCurr instanceof LockableObject && ((LockableObject)entrypointCurr).isLocked()) 
		unLockEntryPoints(entrypointCurr, req, false);
	res.sendRedirect("assitedataEntryPointShow?ts="+System.currentTimeMillis());
	return null;
}

}
